/*
 * Decompiled with CFR 0.152.
 */
package pmp.core.type;

import java.util.EnumSet;
import java.util.Set;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import pmp.PlantMegaPack;
import pmp.core.data.init.DataInit;
import pmp.core.data.init.DataInitBeacc;
import pmp.core.data.init.DataInitBeacw;
import pmp.core.data.init.DataInitDesec;
import pmp.core.data.init.DataInitDesew;
import pmp.core.data.init.DataInitDeshc;
import pmp.core.data.init.DataInitDeshw;
import pmp.core.data.init.DataInitForec;
import pmp.core.data.init.DataInitForew;
import pmp.core.data.init.DataInitForhc;
import pmp.core.data.init.DataInitForhw;
import pmp.core.data.init.DataInitFroze;
import pmp.core.data.init.DataInitFrozr;
import pmp.core.data.init.DataInitJungh;
import pmp.core.data.init.DataInitJungl;
import pmp.core.data.init.DataInitMesa;
import pmp.core.data.init.DataInitMount;
import pmp.core.data.init.DataInitOcead;
import pmp.core.data.init.DataInitOceaf;
import pmp.core.data.init.DataInitOcean;
import pmp.core.data.init.DataInitPlain;
import pmp.core.data.init.DataInitRivec;
import pmp.core.data.init.DataInitRiveh;
import pmp.core.data.init.DataInitRivew;
import pmp.core.data.init.DataInitSavan;
import pmp.core.data.init.DataInitSwamh;
import pmp.core.data.init.DataInitSwamp;
import pmp.core.def.DefBiomeHabitats;
import pmp.core.def.DefHabitat;
import pmp.worldgen.WorldgenHelpers;

public enum TypeBiome {
    BEACC("beacc", '7', 10, 10, DefBiomeHabitats.BEACH, DataInitBeacc.class),
    BEACW("beacw", '7', 10, 10, DefBiomeHabitats.BEACH, DataInitBeacw.class),
    DESEC("desec", 'e', 0, 0, DefBiomeHabitats.BIOME_ALL, DataInitDesec.class),
    DESHC("deshc", 'e', 0, 0, DefBiomeHabitats.BIOME_ALL, DataInitDeshc.class),
    DESEW("desew", 'e', 10, 0, DefBiomeHabitats.BIOME_ALL, DataInitDesew.class),
    DESHW("deshw", 'e', 10, 0, DefBiomeHabitats.BIOME_ALL, DataInitDeshw.class),
    FOREC("forec", '2', 10, 10, DefBiomeHabitats.BIOME_ALL, DataInitForec.class),
    FORHC("forhc", '2', 10, 10, DefBiomeHabitats.BIOME_ALL, DataInitForhc.class),
    FOREW("forew", '2', 10, 10, DefBiomeHabitats.BIOME_ALL, DataInitForew.class),
    FORHW("forhw", '2', 10, 10, DefBiomeHabitats.BIOME_ALL, DataInitForhw.class),
    FROZE("froze", '3', 10, 10, DefBiomeHabitats.FROZEN, DataInitFroze.class),
    FROZR("frozr", '3', 10, 10, DefBiomeHabitats.FROZEN, DataInitFrozr.class),
    JUNGL("jungl", 'a', 10, 10, DefBiomeHabitats.BIOME_ALL, DataInitJungl.class),
    JUNGH("jungh", 'a', 10, 10, DefBiomeHabitats.BIOME_ALL, DataInitJungh.class),
    MESA("mesa", '6', 10, 10, DefBiomeHabitats.BIOME_ALL, DataInitMesa.class),
    MOUNT("mount", 'd', 10, 10, DefBiomeHabitats.BIOME_ALL, DataInitMount.class),
    OCEAN("ocean", '9', 10, 0, DefBiomeHabitats.MARINE, DataInitOcean.class),
    OCEAD("ocead", '9', 0, 0, DefBiomeHabitats.MARINE, DataInitOcead.class),
    OCEAF("oceaf", '9', 0, 0, DefBiomeHabitats.MARINE, DataInitOceaf.class),
    PLAIN("plain", 'a', 5, 10, DefBiomeHabitats.BIOME_ALL, DataInitPlain.class),
    RIVEC("rivec", 'b', 10, 10, DefBiomeHabitats.BIOME_ALL, DataInitRivec.class),
    RIVEW("rivew", 'b', 20, 20, DefBiomeHabitats.BIOME_ALL, DataInitRivew.class),
    RIVEH("riveh", 'b', 20, 20, DefBiomeHabitats.BIOME_ALL, DataInitRiveh.class),
    SAVAN("savan", '6', 5, 5, DefBiomeHabitats.BIOME_ALL, DataInitSavan.class),
    SWAMP("swamp", 'c', 10, 10, DefBiomeHabitats.BIOME_ALL, DataInitSwamp.class),
    SWAMH("swamh", 'c', 10, 10, DefBiomeHabitats.BIOME_ALL, DataInitSwamh.class);

    public final String resourceName;
    public final char colorCode;
    public final int defaultGenRatePlants;
    public final int defaultGenRateTrees;
    public final DefBiomeHabitats habitats;
    public final Class<? extends DataInit> dataInitClass;

    private TypeBiome(String resourceName, char colorCode, int defaultGenRatePlants, int defaultGenRateTrees, DefBiomeHabitats habitats, Class<? extends DataInit> dataInitClass) {
        this.resourceName = resourceName;
        this.colorCode = colorCode;
        this.defaultGenRatePlants = defaultGenRatePlants;
        this.defaultGenRateTrees = defaultGenRateTrees;
        this.habitats = habitats;
        this.dataInitClass = dataInitClass;
    }

    public EnumSet<DefHabitat> getHabitats() {
        return this.habitats.habitats;
    }

    public String getLocalizedName() {
        return I18n.func_135052_a((String)String.format("biotp.%s", this.resourceName), (Object[])new Object[0]);
    }

    public String getLocalizedNameFormatted() {
        return String.format("\u00a7%s%s\u00a7r", Character.valueOf(this.colorCode), this.getLocalizedName());
    }

    public static TypeBiome getBiomeTypeFromName(String typeName) {
        for (TypeBiome type : TypeBiome.values()) {
            if (!typeName.matches(type.resourceName)) continue;
            return type;
        }
        return null;
    }

    public static TypeBiome getBiomeType(World world, Biome biome, BlockPos pos) {
        Set biomeTypes = BiomeDictionary.getTypes((Biome)biome);
        boolean beach = biomeTypes.contains(BiomeDictionary.Type.BEACH);
        boolean cold = biomeTypes.contains(BiomeDictionary.Type.COLD);
        boolean coniferous = biomeTypes.contains(BiomeDictionary.Type.CONIFEROUS);
        boolean forest = biomeTypes.contains(BiomeDictionary.Type.FOREST);
        boolean hills = biomeTypes.contains(BiomeDictionary.Type.HILLS);
        boolean hot = biomeTypes.contains(BiomeDictionary.Type.HOT);
        boolean jungle = biomeTypes.contains(BiomeDictionary.Type.JUNGLE);
        boolean mesa = biomeTypes.contains(BiomeDictionary.Type.MESA);
        boolean mountain = biomeTypes.contains(BiomeDictionary.Type.MOUNTAIN);
        boolean mushroom = biomeTypes.contains(BiomeDictionary.Type.MUSHROOM);
        boolean ocean = biomeTypes.contains(BiomeDictionary.Type.OCEAN);
        boolean plains = biomeTypes.contains(BiomeDictionary.Type.PLAINS);
        boolean river = biomeTypes.contains(BiomeDictionary.Type.RIVER);
        boolean sandy = biomeTypes.contains(BiomeDictionary.Type.SANDY);
        boolean savanna = biomeTypes.contains(BiomeDictionary.Type.SAVANNA);
        boolean snowy = biomeTypes.contains(BiomeDictionary.Type.SNOWY);
        boolean swamp = biomeTypes.contains(BiomeDictionary.Type.SWAMP);
        if (mushroom) {
            return null;
        }
        if (ocean) {
            if (biome == Biomes.field_150575_M) {
                return OCEAD;
            }
            if (cold || snowy) {
                return OCEAF;
            }
            return OCEAN;
        }
        if (river) {
            if (cold || snowy) {
                return FROZR;
            }
            float temp = WorldgenHelpers.getNearbyAverageTemp(world, pos, PlantMegaPack.settings.worldgenTempDetectRadius);
            return temp < 0.5125f ? RIVEC : (temp < 1.0f ? RIVEW : RIVEH);
        }
        if (beach) {
            if (cold || snowy) {
                return BEACC;
            }
            return BEACW;
        }
        if (cold || snowy) {
            if (forest || coniferous) {
                return hills ? FORHC : FOREC;
            }
            return FROZE;
        }
        if (mesa) {
            return MESA;
        }
        if (jungle) {
            if (hills) {
                return JUNGH;
            }
            return JUNGL;
        }
        if (swamp) {
            return hills ? SWAMH : SWAMP;
        }
        if (savanna) {
            return SAVAN;
        }
        if (sandy) {
            if (hot) {
                return hills ? DESHW : DESEW;
            }
            return hills ? DESHC : DESEC;
        }
        if (mountain) {
            if (forest) {
                return hills ? FORHC : FOREC;
            }
            return MOUNT;
        }
        if (forest) {
            if (cold || snowy || coniferous) {
                return hills ? FORHC : FOREC;
            }
            return hills ? FORHW : FOREW;
        }
        if (plains) {
            return PLAIN;
        }
        return null;
    }
}

