/*
 * Decompiled with CFR 0.152.
 */
package pmp.core.data.init;

import pmp.core.data.DataBiome;
import pmp.core.data.DataHabitat;
import pmp.core.data.init.DataInit;
import pmp.core.def.DefPlant;
import pmp.core.def.DefTree;

public class DataInitSwamh
extends DataInit {
    @Override
    public void applyDefaultBiomeSettings(DataBiome biome) {
        biome.worldgenRatePlants = biome.typeBiome.defaultGenRatePlants;
        biome.worldgenRateTrees = biome.typeBiome.defaultGenRateTrees;
    }

    @Override
    public void applyDefaultHabitatSettings(DataHabitat dataHabitat) {
        dataHabitat.worldgenRatePlants = 0;
        dataHabitat.worldgenRateTrees = 0;
        switch (dataHabitat.habitat) {
            case TREE_EPIPHYTE: {
                dataHabitat.worldgenRatePlants = 15;
                break;
            }
            case TREE_VINE: {
                dataHabitat.worldgenRatePlants = 15;
                break;
            }
            case LAND_BIOME_EDGE: {
                dataHabitat.worldgenRatePlants = 15;
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                dataHabitat.worldgenRatePlants = 15;
                break;
            }
            case LAND_OPEN: {
                dataHabitat.worldgenRatePlants = 15;
                dataHabitat.worldgenRateTrees = 10;
                break;
            }
            case LAND_SHADE: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.worldgenRatePlants = 15;
                break;
            }
            case LAND_SLOPE_SHADE: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.worldgenRatePlants = 35;
                break;
            }
            case LAND_WATER_EDGE_SHADE: {
                dataHabitat.worldgenRatePlants = 15;
                break;
            }
            case LAND_TREE_BASE: {
                dataHabitat.worldgenRatePlants = 15;
                break;
            }
            case FRESHWATER_DEEP: {
                dataHabitat.worldgenRatePlants = 20;
                break;
            }
            case FRESHWATER_FLOATING: {
                dataHabitat.worldgenRatePlants = 15;
                break;
            }
            case FRESHWATER_MARGIN: {
                dataHabitat.worldgenRatePlants = 25;
                break;
            }
        }
    }

    @Override
    public void applyDefaultHabitatPlants(DataHabitat dataHabitat) {
        dataHabitat.clearHabitatPlants();
        switch (dataHabitat.habitat) {
            case TREE_EPIPHYTE: {
                dataHabitat.addPlant(DefPlant.EPIPH_ARTCO, 50, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.EPIPH_FRAGF, 50, 0, 0, 0);
                break;
            }
            case TREE_VINE: {
                dataHabitat.addPlant(DefPlant.VINE_SILVC, 50, 0, 0, 0);
                break;
            }
            case LAND_BIOME_EDGE: {
                dataHabitat.addPlant(DefPlant.WETLA_CEDCY, 50, 1, 15, 1);
                dataHabitat.addPlant(DefPlant.WETLA_CEDGL, 75, 2, 20, 1);
                dataHabitat.addPlant(DefPlant.WETLA_CEDPY, 50, 1, 15, 1);
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                dataHabitat.addPlant(DefPlant.MEDIU_CINNF, 10, 1, 15, 2);
                dataHabitat.addPlant(DefPlant.WETLA_CLUBR, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.WETLA_COMRU, 50, 1, 20, 1);
                break;
            }
            case LAND_OPEN: {
                dataHabitat.addPlant(DefPlant.GRNDC_GRLIG, 90, 2, 25, 2);
                dataHabitat.addPlant(DefPlant.MEDIU_CINNF, 10, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.LARGE_BLEPA, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.LARGE_DRACY, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.LARGE_GCANE, 5, 1, 20, 1);
                break;
            }
            case LAND_SHADE: {
                dataHabitat.addPlant(DefPlant.GRNDC_MOSS, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.WETLA_BLUST, 50, 1, 15, 1);
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.addPlant(DefPlant.GRNDC_GRLIG, 80, 1, 25, 2);
                dataHabitat.addPlant(DefPlant.LARGE_BLEPA, 10, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.LARGE_DRACY, 10, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.LARGE_GCANE, 10, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.LARGE_GHORS, 10, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.WETLA_CEDCY, 20, 1, 15, 1);
                dataHabitat.addPlant(DefPlant.WETLA_CEDGL, 35, 2, 20, 1);
                dataHabitat.addPlant(DefPlant.WETLA_CEDPY, 20, 1, 15, 1);
                dataHabitat.addPlant(DefPlant.WETLA_CLUBR, 40, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.WETLA_COMRU, 40, 1, 20, 2);
                break;
            }
            case LAND_SLOPE_SHADE: {
                dataHabitat.addPlant(DefPlant.GRNDC_GRLIG, 15, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.WETLA_BLUST, 50, 1, 15, 1);
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.addPlant(DefPlant.BAMB_SHTAS, 5, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.WETLA_CATTA, 90, 2, 45, 0);
                dataHabitat.addPlant(DefPlant.WETLA_CLUBR, 15, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.WETLA_COMRU, 15, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.WETLA_CORDG, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.WETLA_FIREF, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.WETLA_FLORU, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.WETLA_OSTFE, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.WETLA_REEDM, 10, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.WETLA_STRBB, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.WETLA_SWAMW, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.WETLA_TORLI, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.WETLA_WAHOR, 10, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.WETLA_WHTTH, 5, 1, 20, 1);
                break;
            }
            case LAND_WATER_EDGE_SHADE: {
                dataHabitat.addPlant(DefPlant.WETLA_PICKW, 50, 2, 30, 0);
                break;
            }
            case LAND_TREE_BASE: {
                dataHabitat.addPlant(DefPlant.WETLA_BLUST, 50, 0, 0, 0);
                break;
            }
            case FRESHWATER_DEEP: {
                dataHabitat.addPlant(DefPlant.FRESH_CAWAW, 30, 1, 40, 1);
                dataHabitat.addPlant(DefPlant.FRESH_EELGR, 50, 1, 40, 1);
                break;
            }
            case FRESHWATER_FLOATING: {
                dataHabitat.addPlant(DefPlant.FLOAT_ARRLL, 10, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_DUCKW, 90, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WAHYA, 10, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WASHI, 5, 1, 20, 0);
                break;
            }
            case FRESHWATER_MARGIN: {
                dataHabitat.addPlant(DefPlant.CROPA_CENTE, 5, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.IMMER_ARRAR, 5, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.IMMER_COMRD, 70, 2, 35, 0);
                dataHabitat.addPlant(DefPlant.IMMER_DUCKP, 5, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.IMMER_SIMBR, 5, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.IMMER_SOFBU, 5, 1, 20, 0);
                break;
            }
        }
    }

    @Override
    public void applyDefaultHabitatTrees(DataHabitat dataHabitat) {
        dataHabitat.clearHabitatTrees();
        switch (dataHabitat.habitat) {
            case LAND_BIOME_EDGE: {
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                break;
            }
            case LAND_OPEN: {
                dataHabitat.addTree(DefTree.OAK_ENGLI, 50);
                break;
            }
            case LAND_SLOPE: {
                break;
            }
            case LAND_WATER_EDGE: {
                break;
            }
        }
    }
}

