/*
 * Decompiled with CFR 0.152.
 */
package pmp.core.data.init;

import pmp.core.data.DataBiome;
import pmp.core.data.DataHabitat;
import pmp.core.data.init.DataInit;
import pmp.core.def.DefPlant;
import pmp.core.def.DefTree;

public class DataInitRivew
extends DataInit {
    @Override
    public void applyDefaultBiomeSettings(DataBiome biome) {
        biome.worldgenRatePlants = biome.typeBiome.defaultGenRatePlants;
        biome.worldgenRateTrees = biome.typeBiome.defaultGenRateTrees;
    }

    @Override
    public void applyDefaultHabitatSettings(DataHabitat dataHabitat) {
        dataHabitat.worldgenRatePlants = 0;
        dataHabitat.worldgenRateTrees = 0;
        switch (dataHabitat.habitat) {
            case TREE_EPIPHYTE: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case TREE_VINE: {
                dataHabitat.worldgenRatePlants = 5;
                break;
            }
            case LAND_BIOME_EDGE: {
                dataHabitat.worldgenRatePlants = 15;
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                dataHabitat.worldgenRatePlants = 15;
                dataHabitat.worldgenRateTrees = 20;
                break;
            }
            case LAND_OPEN: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case LAND_SHADE: {
                dataHabitat.worldgenRatePlants = 20;
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.worldgenRatePlants = 15;
                break;
            }
            case LAND_SLOPE_SHADE: {
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.worldgenRatePlants = 35;
                break;
            }
            case LAND_WATER_EDGE_SHADE: {
                dataHabitat.worldgenRatePlants = 20;
                break;
            }
            case LAND_TREE_BASE: {
                dataHabitat.worldgenRatePlants = 20;
                break;
            }
            case FRESHWATER_DEEP: {
                dataHabitat.worldgenRatePlants = 20;
                break;
            }
            case FRESHWATER_FLOATING: {
                dataHabitat.worldgenRatePlants = 15;
                break;
            }
            case FRESHWATER_MARGIN: {
                dataHabitat.worldgenRatePlants = 15;
                break;
            }
        }
    }

    @Override
    public void applyDefaultHabitatPlants(DataHabitat dataHabitat) {
        dataHabitat.clearHabitatPlants();
        switch (dataHabitat.habitat) {
            case TREE_EPIPHYTE: {
                dataHabitat.addPlant(DefPlant.EPIPH_FRAGF, 75, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.EPIPH_TURKT, 10, 0, 0, 0);
                break;
            }
            case TREE_VINE: {
                dataHabitat.addPlant(DefPlant.VINE_WISTE_BLU, 50, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.VINE_WISTE_CYA, 50, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.VINE_WISTE_GRN, 50, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.VINE_WISTE_ORA, 50, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.VINE_WISTE_PNK, 50, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.VINE_WISTE_PUR, 50, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.VINE_WISTE_RED, 50, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.VINE_WISTE_WHT, 50, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.VINE_WISTE_YEL, 50, 0, 0, 0);
                break;
            }
            case LAND_BIOME_EDGE: {
                dataHabitat.addPlant(DefPlant.FOREW_MAIDG, 50, 1, 25, 2);
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                dataHabitat.addPlant(DefPlant.FOREW_MAIDG, 50, 1, 25, 2);
                break;
            }
            case LAND_OPEN: {
                dataHabitat.addPlant(DefPlant.FOREW_MAIDG, 50, 1, 25, 2);
                break;
            }
            case LAND_SHADE: {
                dataHabitat.addPlant(DefPlant.FOREW_KANGF, 50, 1, 20, 2);
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.addPlant(DefPlant.MEDIU_CINNF, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.WETLA_OSTFE, 10, 2, 10, 1);
                dataHabitat.addPlant(DefPlant.WETLA_REEDM, 50, 2, 25, 2);
                break;
            }
            case LAND_SLOPE_SHADE: {
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.addPlant(DefPlant.WETLA_CATTA, 80, 1, 40, 0);
                dataHabitat.addPlant(DefPlant.WETLA_CLUBR, 15, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.WETLA_COMRU, 15, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.WETLA_FLORU, 5, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.WETLA_REEDM, 30, 2, 20, 2);
                dataHabitat.addPlant(DefPlant.WETLA_STRBB, 5, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.WETLA_WAHOR, 10, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.WETLA_WHTTH, 5, 1, 20, 0);
                break;
            }
            case LAND_WATER_EDGE_SHADE: {
                dataHabitat.addPlant(DefPlant.WETLA_PICKW, 40, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.WETLA_REEDM, 50, 2, 20, 1);
                dataHabitat.addPlant(DefPlant.WETLA_STRBB, 25, 1, 20, 0);
                break;
            }
            case LAND_TREE_BASE: {
                dataHabitat.addPlant(DefPlant.WETLA_REEDM, 50, 2, 20, 1);
                break;
            }
            case FRESHWATER_DEEP: {
                dataHabitat.addPlant(DefPlant.FRESH_AMAZS, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FRESH_CAWAW, 80, 2, 20, 1);
                dataHabitat.addPlant(DefPlant.FRESH_COONT, 25, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FRESH_CRYWE, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FRESH_DWHGR, 20, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FRESH_EELGR, 15, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FRESH_MONDG, 10, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FRESH_WAWIS, 10, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FRESH_WRWAN, 10, 1, 20, 1);
                break;
            }
            case FRESHWATER_FLOATING: {
                dataHabitat.addPlant(DefPlant.FLOAT_ARRLL, 50, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_CRFLH, 50, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_DUCKW, 50, 2, 35, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_RERFL, 50, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_VARPL, 50, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WACHE, 50, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WALET, 50, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WASHI, 50, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WALIL_BLU, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WALIL_CYA, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WALIL_GRN, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WALIL_ORA, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WALIL_PNK, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WALIL_PUR, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WALIL_RED, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WALIL_WHT, 5, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.FLOAT_WALIL_YEL, 5, 0, 0, 0);
                break;
            }
            case FRESHWATER_MARGIN: {
                dataHabitat.addPlant(DefPlant.CROPA_ASIAR, 2, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.CROPA_LAKSA, 2, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.CROPA_SACRL, 2, 1, 15, 0);
                dataHabitat.addPlant(DefPlant.CROPA_WACRE, 2, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.CROPA_WASPI, 2, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.CROPA_WILDR, 2, 1, 20, 0);
                dataHabitat.addPlant(DefPlant.IMMER_ARRAR, 10, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.IMMER_COMRD, 70, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.IMMER_DUCKP, 10, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.IMMER_EURBR, 10, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.IMMER_SIMBR, 10, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.IMMER_SOFBU, 10, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.IMMER_WAMAN, 10, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.IMMER_YELFL, 5, 0, 0, 0);
                break;
            }
        }
    }

    @Override
    public void applyDefaultHabitatTrees(DataHabitat dataHabitat) {
        dataHabitat.clearHabitatTrees();
        switch (dataHabitat.habitat) {
            case LAND_BIOME_EDGE: {
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                dataHabitat.addTree(DefTree.BIRCH_WATER, 50);
                break;
            }
            case LAND_OPEN: {
                break;
            }
            case LAND_SLOPE: {
                break;
            }
            case LAND_WATER_EDGE: {
                break;
            }
        }
    }
}

