/*
 * Decompiled with CFR 0.152.
 */
package pmp.core.data.init;

import pmp.core.data.DataBiome;
import pmp.core.data.DataHabitat;
import pmp.core.data.init.DataInit;
import pmp.core.def.DefPlant;
import pmp.core.def.DefTree;

public class DataInitForhc
extends DataInit {
    @Override
    public void applyDefaultBiomeSettings(DataBiome biome) {
        biome.worldgenRatePlants = biome.typeBiome.defaultGenRatePlants;
        biome.worldgenRateTrees = biome.typeBiome.defaultGenRateTrees;
    }

    @Override
    public void applyDefaultHabitatSettings(DataHabitat dataHabitat) {
        dataHabitat.worldgenRatePlants = 0;
        dataHabitat.worldgenRateTrees = 0;
        switch (dataHabitat.habitat) {
            case TREE_EPIPHYTE: {
                dataHabitat.worldgenRatePlants = 5;
                break;
            }
            case TREE_VINE: {
                break;
            }
            case LAND_BIOME_EDGE: {
                dataHabitat.worldgenRateTrees = 10;
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case LAND_OPEN: {
                dataHabitat.worldgenRatePlants = 5;
                dataHabitat.worldgenRateTrees = 5;
                break;
            }
            case LAND_SHADE: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case LAND_SLOPE_SHADE: {
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case LAND_WATER_EDGE_SHADE: {
                break;
            }
            case LAND_TREE_BASE: {
                dataHabitat.worldgenRatePlants = 25;
                break;
            }
            case FRESHWATER_DEEP: {
                break;
            }
            case FRESHWATER_FLOATING: {
                break;
            }
            case FRESHWATER_MARGIN: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
        }
    }

    @Override
    public void applyDefaultHabitatPlants(DataHabitat dataHabitat) {
        dataHabitat.clearHabitatPlants();
        switch (dataHabitat.habitat) {
            case TREE_EPIPHYTE: {
                dataHabitat.addPlant(DefPlant.EPIPH_APADW, 50, 0, 0, 0);
                dataHabitat.addPlant(DefPlant.EPIPH_ARTCO, 50, 0, 0, 0);
                break;
            }
            case TREE_VINE: {
                break;
            }
            case LAND_BIOME_EDGE: {
                dataHabitat.addPlant(DefPlant.FOREC_BUTTB, 50, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FOREC_NINEB, 50, 1, 20, 1);
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                dataHabitat.addPlant(DefPlant.FOREC_BARBE, 12, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FOREC_BUTTB, 50, 1, 20, 1);
                break;
            }
            case LAND_OPEN: {
                dataHabitat.addPlant(DefPlant.BBUSH_SNOW, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FOREC_ALPTH, 25, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FOREC_ARCGE, 12, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FOREC_BUTTB, 12, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FOREC_FOAMF, 12, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FOREC_JUNSA, 12, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FOREC_KERRI, 12, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FOREC_LAVEN, 12, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FOREC_LOBRO, 12, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FOREC_MEZER, 12, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FOREC_NORPP, 12, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FOREC_PERUL, 12, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FOREC_STOSP, 12, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FOREC_WILDM, 12, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FOREC_WOLKN, 12, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FOREC_WOODS, 12, 1, 20, 1);
                break;
            }
            case LAND_SHADE: {
                dataHabitat.addPlant(DefPlant.FUNGU_DEATC, 20, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FUNGU_GCLUB, 20, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FUNGU_PARAS, 20, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.GRNDC_CLOVE, 5, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.GRNDC_LVGRN, 80, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.GRNDC_TWIG, 10, 1, 20, 1);
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.addPlant(DefPlant.FOREC_BARBE, 12, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.MEDIU_SHEEL, 50, 1, 20, 2);
                break;
            }
            case LAND_SLOPE_SHADE: {
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.addPlant(DefPlant.FOREC_MAIDS, 10, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.FOREC_WOODS, 10, 1, 20, 1);
                dataHabitat.addPlant(DefPlant.WETLA_CLUBR, 50, 1, 15, 0);
                dataHabitat.addPlant(DefPlant.WETLA_REEDM, 50, 1, 20, 1);
                break;
            }
            case LAND_WATER_EDGE_SHADE: {
                break;
            }
            case LAND_TREE_BASE: {
                dataHabitat.addPlant(DefPlant.FOREC_WOODS, 50, 1, 20, 1);
                break;
            }
            case FRESHWATER_DEEP: {
                break;
            }
            case FRESHWATER_FLOATING: {
                break;
            }
            case FRESHWATER_MARGIN: {
                dataHabitat.addPlant(DefPlant.IMMER_GREYS, 50, 1, 15, 0);
                break;
            }
        }
    }

    @Override
    public void applyDefaultHabitatTrees(DataHabitat dataHabitat) {
        dataHabitat.clearHabitatTrees();
        switch (dataHabitat.habitat) {
            case LAND_BIOME_EDGE: {
                dataHabitat.addTree(DefTree.SPRUC_RED, 50);
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                break;
            }
            case LAND_OPEN: {
                dataHabitat.addTree(DefTree.SPRUC_RED, 50);
                break;
            }
            case LAND_SLOPE: {
                break;
            }
            case LAND_WATER_EDGE: {
                break;
            }
        }
    }
}

