/*
 * Decompiled with CFR 0.152.
 */
package pmp.core.data.init;

import pmp.core.data.DataBiome;
import pmp.core.data.DataHabitat;
import pmp.core.data.init.DataInit;
import pmp.core.def.DefPlant;

public class DataInitDesew
extends DataInit {
    @Override
    public void applyDefaultBiomeSettings(DataBiome biome) {
        biome.worldgenRatePlants = biome.typeBiome.defaultGenRatePlants;
        biome.worldgenRateTrees = biome.typeBiome.defaultGenRateTrees;
    }

    @Override
    public void applyDefaultHabitatSettings(DataHabitat dataHabitat) {
        dataHabitat.worldgenRatePlants = 0;
        dataHabitat.worldgenRateTrees = 0;
        switch (dataHabitat.habitat) {
            case TREE_EPIPHYTE: {
                break;
            }
            case TREE_VINE: {
                break;
            }
            case LAND_BIOME_EDGE: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case LAND_OPEN: {
                break;
            }
            case LAND_SHADE: {
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case LAND_SLOPE_SHADE: {
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.worldgenRatePlants = 20;
                break;
            }
            case LAND_WATER_EDGE_SHADE: {
                break;
            }
            case LAND_TREE_BASE: {
                break;
            }
            case FRESHWATER_DEEP: {
                break;
            }
            case FRESHWATER_FLOATING: {
                break;
            }
            case FRESHWATER_MARGIN: {
                break;
            }
        }
    }

    @Override
    public void applyDefaultHabitatPlants(DataHabitat dataHabitat) {
        dataHabitat.clearHabitatPlants();
        switch (dataHabitat.habitat) {
            case TREE_EPIPHYTE: {
                break;
            }
            case TREE_VINE: {
                break;
            }
            case LAND_BIOME_EDGE: {
                dataHabitat.addPlant(DefPlant.DESER_BRITT, 50, 2, 15, 2);
                dataHabitat.addPlant(DefPlant.DESER_BRLFG, 50, 2, 15, 2);
                dataHabitat.addPlant(DefPlant.DESER_BROOM, 50, 2, 15, 2);
                dataHabitat.addPlant(DefPlant.DESER_KANGP, 50, 2, 15, 2);
                dataHabitat.addPlant(DefPlant.DESER_PENON, 50, 2, 15, 2);
                dataHabitat.addPlant(DefPlant.DESER_SEEPW, 50, 2, 15, 2);
                dataHabitat.addPlant(DefPlant.DESER_WHTSA, 50, 2, 15, 2);
                dataHabitat.addPlant(DefPlant.FUNGU_BLPOW, 50, 1, 20, 1);
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                dataHabitat.addPlant(DefPlant.DESER_APAPL, 50, 2, 15, 2);
                dataHabitat.addPlant(DefPlant.DESER_OCOTI, 50, 2, 20, 2);
                break;
            }
            case LAND_OPEN: {
                break;
            }
            case LAND_SHADE: {
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.addPlant(DefPlant.CACTU_ARMAT, 20, 2, 15, 2);
                dataHabitat.addPlant(DefPlant.CACTU_BASEB, 50, 2, 15, 2);
                dataHabitat.addPlant(DefPlant.CACTU_CHIMH, 20, 2, 15, 2);
                dataHabitat.addPlant(DefPlant.CACTU_GLDCE, 50, 2, 15, 2);
                dataHabitat.addPlant(DefPlant.CACTU_GLDSA, 50, 2, 15, 2);
                dataHabitat.addPlant(DefPlant.CACTU_MATAU, 50, 2, 15, 2);
                dataHabitat.addPlant(DefPlant.CACTU_PRPEA, 50, 2, 15, 2);
                dataHabitat.addPlant(DefPlant.CACTU_SNOWP, 50, 2, 15, 2);
                dataHabitat.addPlant(DefPlant.CACTU_TOOTH, 50, 2, 15, 2);
                dataHabitat.addPlant(DefPlant.DESER_APAPL, 35, 2, 15, 2);
                dataHabitat.addPlant(DefPlant.DESER_BRITT, 35, 2, 15, 2);
                dataHabitat.addPlant(DefPlant.DESER_BRLFG, 35, 2, 15, 2);
                dataHabitat.addPlant(DefPlant.DESER_BROOM, 35, 2, 15, 2);
                dataHabitat.addPlant(DefPlant.DESER_KANGP, 35, 2, 15, 2);
                dataHabitat.addPlant(DefPlant.DESER_OCOTI, 35, 2, 15, 2);
                dataHabitat.addPlant(DefPlant.DESER_PENON, 35, 2, 15, 2);
                dataHabitat.addPlant(DefPlant.DESER_SEEPW, 35, 2, 15, 2);
                dataHabitat.addPlant(DefPlant.DESER_WHTSA, 35, 2, 15, 2);
                dataHabitat.addPlant(DefPlant.LARGE_SAGUA, 35, 2, 15, 2);
                break;
            }
            case LAND_SLOPE_SHADE: {
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.addPlant(DefPlant.MEDIU_WOOLB, 15, 2, 15, 1);
                dataHabitat.addPlant(DefPlant.PLAIN_SWGRA, 60, 2, 20, 1);
                dataHabitat.addPlant(DefPlant.SAVAN_TEXTI, 5, 1, 15, 1);
                break;
            }
            case LAND_WATER_EDGE_SHADE: {
                break;
            }
            case LAND_TREE_BASE: {
                break;
            }
            case FRESHWATER_DEEP: {
                break;
            }
            case FRESHWATER_FLOATING: {
                break;
            }
            case FRESHWATER_MARGIN: {
                break;
            }
        }
    }

    @Override
    public void applyDefaultHabitatTrees(DataHabitat dataHabitat) {
        dataHabitat.clearHabitatTrees();
        switch (dataHabitat.habitat) {
            case LAND_BIOME_EDGE: {
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                break;
            }
            case LAND_OPEN: {
                break;
            }
            case LAND_SLOPE: {
                break;
            }
            case LAND_WATER_EDGE: {
                break;
            }
        }
    }
}

