/*
 * Decompiled with CFR 0.152.
 */
package pmp.core.data.init;

import pmp.core.data.DataBiome;
import pmp.core.data.DataHabitat;
import pmp.core.data.init.DataInit;
import pmp.core.def.DefPlant;

public class DataInitBeacc
extends DataInit {
    @Override
    public void applyDefaultBiomeSettings(DataBiome biome) {
        biome.worldgenRatePlants = biome.typeBiome.defaultGenRatePlants;
        biome.worldgenRateTrees = biome.typeBiome.defaultGenRateTrees;
    }

    @Override
    public void applyDefaultHabitatSettings(DataHabitat dataHabitat) {
        dataHabitat.worldgenRatePlants = 0;
        dataHabitat.worldgenRateTrees = 0;
        switch (dataHabitat.habitat) {
            case TREE_EPIPHYTE: {
                break;
            }
            case TREE_VINE: {
                break;
            }
            case LAND_BIOME_EDGE: {
                dataHabitat.worldgenRatePlants = 5;
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                dataHabitat.worldgenRatePlants = 5;
                break;
            }
            case LAND_OPEN: {
                dataHabitat.worldgenRatePlants = 15;
                break;
            }
            case LAND_SHADE: {
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.worldgenRatePlants = 15;
                break;
            }
            case LAND_SLOPE_SHADE: {
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.worldgenRatePlants = 10;
                break;
            }
            case LAND_WATER_EDGE_SHADE: {
                break;
            }
            case LAND_TREE_BASE: {
                break;
            }
            case MARINE_DEEP: {
                break;
            }
            case MARINE_FLOATING: {
                break;
            }
            case MARINE_MARGIN: {
                break;
            }
        }
    }

    @Override
    public void applyDefaultHabitatPlants(DataHabitat dataHabitat) {
        dataHabitat.clearHabitatPlants();
        switch (dataHabitat.habitat) {
            case TREE_EPIPHYTE: {
                break;
            }
            case TREE_VINE: {
                break;
            }
            case LAND_BIOME_EDGE: {
                dataHabitat.addPlant(DefPlant.BEACH_CYPGR, 50, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.BEACH_CYPYE, 50, 1, 20, 2);
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                dataHabitat.addPlant(DefPlant.BEACH_CYPGR, 50, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.BEACH_CYPYE, 50, 1, 20, 2);
                break;
            }
            case LAND_OPEN: {
                dataHabitat.addPlant(DefPlant.BEACH_CYPGR, 50, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.BEACH_CYPYE, 50, 1, 20, 2);
                break;
            }
            case LAND_SHADE: {
                break;
            }
            case LAND_SLOPE: {
                dataHabitat.addPlant(DefPlant.BEACH_CYPGR, 50, 1, 20, 2);
                dataHabitat.addPlant(DefPlant.BEACH_CYPYE, 50, 1, 20, 2);
                break;
            }
            case LAND_SLOPE_SHADE: {
                break;
            }
            case LAND_WATER_EDGE: {
                dataHabitat.addPlant(DefPlant.BEACH_HITBU, 50, 3, 15, 2);
                break;
            }
            case LAND_WATER_EDGE_SHADE: {
                break;
            }
            case LAND_TREE_BASE: {
                break;
            }
            case FRESHWATER_DEEP: {
                break;
            }
            case FRESHWATER_FLOATING: {
                break;
            }
            case FRESHWATER_MARGIN: {
                break;
            }
        }
    }

    @Override
    public void applyDefaultHabitatTrees(DataHabitat dataHabitat) {
        dataHabitat.clearHabitatTrees();
        switch (dataHabitat.habitat) {
            case LAND_BIOME_EDGE: {
                break;
            }
            case LAND_BIOME_EDGE_SLOPE: {
                break;
            }
            case LAND_OPEN: {
                break;
            }
            case LAND_SLOPE: {
                break;
            }
            case LAND_WATER_EDGE: {
                break;
            }
        }
    }
}

