/*
 * Decompiled with CFR 0.152.
 */
package pmp.core.data;

import java.io.PrintWriter;
import pmp.core.def.DefHabitat;
import pmp.core.def.DefPlant;

public class DataHabitatPlant {
    private final DefHabitat habitat;
    private final DefPlant defPlant;
    public int spawnWeight;
    public int clusterRadius;
    public int clusterChance;
    public int maxElevRange;

    public DataHabitatPlant(DefHabitat habitat, DefPlant defPlant) {
        this.habitat = habitat;
        this.defPlant = defPlant;
        this.applyDefaultSettings();
    }

    public DataHabitatPlant(DefHabitat habitat, DefPlant defPlant, int spawnWeight, int clusterRadius, int clusterChance, int maxElevRange) {
        this.habitat = habitat;
        this.defPlant = defPlant;
        this.spawnWeight = spawnWeight;
        this.clusterRadius = clusterRadius;
        this.clusterChance = clusterChance;
        this.maxElevRange = maxElevRange;
    }

    public DefPlant getDefPlant() {
        return this.defPlant;
    }

    public void applyDefaultSettings() {
        this.spawnWeight = this.defPlant.plantCategory.defaultSpawnWeight;
        this.clusterRadius = 1;
        this.clusterChance = 25;
        this.maxElevRange = this.defPlant.maxElevRange;
    }

    public void loadSettings(String dataLine) {
        String[] data = dataLine.split(",");
        this.spawnWeight = Integer.valueOf(data[1]);
        this.clusterRadius = Integer.valueOf(data[2]);
        this.clusterChance = Integer.valueOf(data[3]);
    }

    public void saveSettings(PrintWriter pw) {
        pw.println(String.format("h.%s:p|%s,%d,%d,%d,%d", this.habitat.habitatName, this.defPlant.getBlockName(), this.spawnWeight, this.clusterRadius, this.clusterChance, this.maxElevRange));
    }
}

