/*
 * Decompiled with CFR 0.152.
 */
package pmp.core;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraftforge.oredict.OreDictionary;
import pmp.PlantMegaPack;
import pmp.core.def.DefBlock;
import pmp.core.def.DefFood;
import pmp.core.def.DefItem;
import pmp.core.def.DefPlant;
import pmp.core.def.DefSeed;
import pmp.core.def.DefWorkbench;
import pmp.core.type.TypeBlock;
import pmp.core.type.TypeFood;
import pmp.core.type.TypePlantCat;

public abstract class ModOreDict {
    public static void registerOreDict() {
        ModOreDict.registerVanillaItems();
        ModOreDict.registerOreDictNames();
    }

    private static void registerOreDictNames() {
        for (DefWorkbench defWorkbench : DefWorkbench.values()) {
            ModOreDict.registerOreDictName(defWorkbench.oreDictName, PlantMegaPack.objects.getWorkbenchBlock(defWorkbench));
        }
        for (DefBlock defBlock : DefBlock.values()) {
            TypeBlock blockType = defBlock.getBlockType();
            if (blockType == TypeBlock.DOORW || blockType == TypeBlock.DOORM) continue;
            ModOreDict.registerOreDictName(defBlock.getOreDictName(), PlantMegaPack.objects.getBlock(defBlock));
            if (blockType == TypeBlock.LOGBA || blockType == TypeBlock.LOGWD) {
                ModOreDict.registerOreDictName("logWood", PlantMegaPack.objects.getBlock(defBlock));
                continue;
            }
            if (blockType == TypeBlock.PLANK) {
                ModOreDict.registerOreDictName("plankWood", PlantMegaPack.objects.getBlock(defBlock));
                continue;
            }
            if (blockType == TypeBlock.SLABW) {
                ModOreDict.registerOreDictName("slabWood", PlantMegaPack.objects.getBlock(defBlock));
                continue;
            }
            if (blockType != TypeBlock.STAIW) continue;
            ModOreDict.registerOreDictName("stairWood", PlantMegaPack.objects.getBlock(defBlock));
        }
        for (Enum enum_ : DefPlant.values()) {
            ModOreDict.registerOreDictName(((DefPlant)enum_).getOreDictName(), PlantMegaPack.objects.getPlant((DefPlant)enum_));
            if (((DefPlant)enum_).plantCategory == TypePlantCat.FUNGU && !((DefPlant)enum_).isPoison()) {
                ModOreDict.registerOreDictName("foodMushroom", PlantMegaPack.objects.getPlant((DefPlant)enum_));
                continue;
            }
            if (((DefPlant)enum_).plantCategory == TypePlantCat.LEAVE) {
                ModOreDict.registerOreDictName("treeLeaves", PlantMegaPack.objects.getPlant((DefPlant)enum_));
                continue;
            }
            if (((DefPlant)enum_).plantCategory != TypePlantCat.SAPLI) continue;
            ModOreDict.registerOreDictName("treeSapling", PlantMegaPack.objects.getPlant((DefPlant)enum_));
        }
        for (Enum enum_ : DefItem.values()) {
            ModOreDict.registerOreDictName(((DefItem)enum_).oreDictName, PlantMegaPack.objects.getItem((DefItem)enum_));
        }
        for (Enum enum_ : DefFood.values()) {
            ModOreDict.registerOreDictName(((DefFood)enum_).oreDictName, PlantMegaPack.objects.getFoodItem((DefFood)enum_));
            if (((DefFood)enum_).foodType == TypeFood.BERRY) {
                ModOreDict.registerOreDictName("foodBerry", PlantMegaPack.objects.getFoodItem((DefFood)enum_));
                continue;
            }
            if (((DefFood)enum_).foodType == TypeFood.FRUIT) {
                ModOreDict.registerOreDictName("foodFruit", PlantMegaPack.objects.getFoodItem((DefFood)enum_));
                continue;
            }
            if (((DefFood)enum_).foodType == TypeFood.NUT || enum_ == DefFood.SEEDF_PEANU) {
                ModOreDict.registerOreDictName("foodNut", PlantMegaPack.objects.getFoodItem((DefFood)enum_));
                continue;
            }
            if (((DefFood)enum_).foodType == TypeFood.VEGET) {
                ModOreDict.registerOreDictName("foodVegetable", PlantMegaPack.objects.getFoodItem((DefFood)enum_));
                continue;
            }
            if (enum_ == DefFood.FOOD_CORBR) {
                ModOreDict.registerOreDictName("foodBread", PlantMegaPack.objects.getFoodItem((DefFood)enum_));
                continue;
            }
            if (enum_ != DefFood.SEEDF_RICE) continue;
            ModOreDict.registerOreDictName("foodRice", PlantMegaPack.objects.getFoodItem((DefFood)enum_));
        }
        for (Enum enum_ : DefSeed.values()) {
            ModOreDict.registerOreDictName(((DefSeed)enum_).oreDictName, PlantMegaPack.objects.getSeedItem((DefSeed)enum_));
        }
    }

    private static void registerOreDictName(String oreDictName, Object object) {
        if (oreDictName == null || oreDictName.isEmpty() || object == null) {
            return;
        }
        if (object instanceof Block) {
            OreDictionary.registerOre((String)oreDictName, (Block)((Block)object));
            return;
        }
        if (object instanceof Item) {
            OreDictionary.registerOre((String)oreDictName, (Item)((Item)object));
            return;
        }
    }

    private static void registerVanillaItems() {
        ModOreDict.registerOreDictName("foodFruit", Items.field_151034_e);
        ModOreDict.registerOreDictName("foodVegetable", Items.field_185164_cV);
        ModOreDict.registerOreDictName("foodBread", Items.field_151025_P);
        ModOreDict.registerOreDictName("foodMushroom", Blocks.field_150338_P);
        ModOreDict.registerOreDictName("foodVegetable", Items.field_151172_bF);
        ModOreDict.registerOreDictName("foodMushroom", Blocks.field_150337_Q);
    }
}

