/*
 * Decompiled with CFR 0.152.
 */
package pmp.core;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;
import pmp.PlantMegaPack;
import pmp.block.BlockBaseWorkbench;
import pmp.block.BlockObjSlab;
import pmp.block.BlockObjSlabDouble;
import pmp.block.BlockTreeFruit;
import pmp.block.BlockTreeLeaves;
import pmp.block.BlockTreeSapling;
import pmp.core.ModCreativeTabs;
import pmp.core.def.DefBlock;
import pmp.core.def.DefFood;
import pmp.core.def.DefItem;
import pmp.core.def.DefPlant;
import pmp.core.def.DefSeed;
import pmp.core.def.DefTree;
import pmp.core.def.DefWorkbench;
import pmp.core.type.TypeBlock;
import pmp.core.type.TypePlant;
import pmp.core.type.TypePlantCat;
import pmp.item.ItemBaseDoor;
import pmp.item.ItemBaseFood;
import pmp.item.ItemBaseSapling;
import pmp.item.ItemBaseSeed;
import pmp.item.ItemBaseWorkbench;

public class ModObjects {
    public static final ResourceLocation TEXTURE_INDICATORS = new ResourceLocation(String.format("%s:textures/blocks/mod_indicat.png", "pmp"));
    private int createdBlocks = 0;
    private int createdPlants = 0;
    private int createdTrees = 0;
    private int createdItems = 0;
    public static ItemArmor.ArmorMaterial ARMOR_MATERIAL_BLACK_IRON;
    private Map<DefWorkbench, Block> workbenchBlocks = new HashMap<DefWorkbench, Block>(DefWorkbench.values().length);
    private Map<DefBlock, Block> blocks = new HashMap<DefBlock, Block>(DefBlock.values().length);
    private Map<DefBlock, ItemBaseDoor> doorItems = new HashMap<DefBlock, ItemBaseDoor>();
    private Map<DefPlant, Block> plants = new HashMap<DefPlant, Block>(DefPlant.values().length);
    private ArrayList<DefPlant> flowers = new ArrayList();
    private Map<DefTree, BlockTreeSapling> saplings = new HashMap<DefTree, BlockTreeSapling>(DefTree.values().length);
    private Map<DefTree, BlockTreeLeaves> leaves = new HashMap<DefTree, BlockTreeLeaves>(DefTree.values().length);
    private Map<DefTree, Block> treeFruits = new HashMap<DefTree, Block>();
    private Map<DefItem, Item> items = new HashMap<DefItem, Item>(DefItem.values().length);
    private Map<DefFood, Item> foodItems = new HashMap<DefFood, Item>(DefFood.values().length);
    private Map<DefSeed, Item> seedItems = new HashMap<DefSeed, Item>(DefSeed.values().length);
    private List<DefPlant> listCrops = new ArrayList<DefPlant>();

    public ModObjects() {
        this.createPlants();
        this.createSaplings();
        this.createLeaves();
        this.createTreeFruits();
        this.createWorkbenchBlocks();
        this.createBlocks();
        this.createItems();
        this.createFoodItems();
        this.createSeedItems();
    }

    public void preInitClient() {
        this.preInitPlants();
        this.preInitSaplings();
        this.preInitLeaves();
        this.preInitBlocks();
        this.preInitItems();
    }

    public void initClient() {
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        this.initPlants(renderItem);
        this.initSaplings(renderItem);
        this.initLeaves(renderItem);
        this.initItems(renderItem);
        this.initWorkbenchBlocks(renderItem);
        this.initBlocks(renderItem);
    }

    public void postInitClient() {
        this.postInitPlants();
        this.postInitSaplings();
        this.postInitLeaves();
    }

    public void outputLogInfo() {
        PlantMegaPack.instance.logOutput(Level.INFO, String.format("Blocks       : %d", this.createdBlocks));
        PlantMegaPack.instance.logOutput(Level.INFO, String.format("Plants       : %d", this.createdPlants));
        PlantMegaPack.instance.logOutput(Level.INFO, String.format("Trees        : %d", this.createdTrees));
        PlantMegaPack.instance.logOutput(Level.INFO, String.format("Items        : %d", this.createdItems));
    }

    private void createWorkbenchBlocks() {
        for (DefWorkbench defWorkbench : DefWorkbench.values()) {
            BlockBaseWorkbench block = new BlockBaseWorkbench(defWorkbench);
            this.workbenchBlocks.put(defWorkbench, (Block)block);
            ++this.createdBlocks;
            block.func_149663_c(defWorkbench.getBlockName());
            block.setRegistryName("pmp", defWorkbench.getBlockName());
            ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
            ItemBaseWorkbench item = new ItemBaseWorkbench(defWorkbench, (Block)block);
            item.func_77655_b(defWorkbench.getBlockName());
            item.setRegistryName("pmp", defWorkbench.getBlockName());
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
        }
    }

    private void initWorkbenchBlocks(RenderItem renderItem) {
        for (DefWorkbench defWorkbench : DefWorkbench.values()) {
            String resourceName = String.format("%s:%s", "pmp", defWorkbench.getBlockName());
            renderItem.func_175037_a().func_178086_a(Item.func_150898_a((Block)this.workbenchBlocks.get((Object)defWorkbench)), 0, new ModelResourceLocation(resourceName, "inventory"));
        }
    }

    public Block getWorkbenchBlock(DefWorkbench defWorkbench) {
        return this.workbenchBlocks.get((Object)defWorkbench);
    }

    private void createBlocks() {
        Block slabDouble = null;
        try {
            for (DefBlock defBlock : DefBlock.values()) {
                Item item;
                Constructor<? extends Item> itemCon;
                Constructor<? extends Block> blockCon = defBlock.getBlockType().blockClass.getConstructor(DefBlock.class);
                Block block = blockCon.newInstance(new Object[]{defBlock});
                this.blocks.put(defBlock, block);
                ++this.createdBlocks;
                String blockName = defBlock.getBlockName();
                block.func_149663_c(blockName);
                block.setRegistryName("pmp", blockName);
                ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
                if (!defBlock.isHiddenBlock()) {
                    block.func_149647_a((CreativeTabs)PlantMegaPack.creativeTabs.getTab(ModCreativeTabs.ModTab.PMP));
                }
                if (defBlock.getBlockType().isDoubleSlab()) {
                    slabDouble = block;
                }
                if (defBlock.getBlockType().isSlab()) {
                    ((BlockObjSlabDouble)slabDouble).setSingleSlabBlock((BlockObjSlab)block);
                }
                if (defBlock.getBlockType().isSlab() || defBlock.getBlockType().isDoubleSlab()) {
                    itemCon = defBlock.getBlockType().itemClass.getConstructor(DefBlock.class, Block.class, Block.class);
                    item = itemCon.newInstance(new Object[]{defBlock, block, slabDouble});
                } else {
                    itemCon = defBlock.getBlockType().itemClass.getConstructor(DefBlock.class, Block.class);
                    item = itemCon.newInstance(new Object[]{defBlock, block});
                }
                if (defBlock.getBlockType() == TypeBlock.DOORM || defBlock.getBlockType() == TypeBlock.DOORW) {
                    this.doorItems.put(defBlock, (ItemBaseDoor)item);
                }
                item.func_77655_b(blockName);
                item.setRegistryName("pmp", blockName);
                ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void preInitBlocks() {
    }

    private void initBlocks(RenderItem renderItem) {
        for (DefBlock defBlock : DefBlock.values()) {
            String resourceName = String.format("%s:%s", "pmp", defBlock.getBlockName());
            renderItem.func_175037_a().func_178086_a(Item.func_150898_a((Block)this.blocks.get((Object)defBlock)), 0, new ModelResourceLocation(resourceName, "inventory"));
            if (defBlock.getBlockType() != TypeBlock.DOORM && defBlock.getBlockType() != TypeBlock.DOORW) continue;
            renderItem.func_175037_a().func_178086_a((Item)this.doorItems.get((Object)defBlock), 0, new ModelResourceLocation(resourceName, "inventory"));
        }
    }

    public Block getBlock(DefBlock defBlock) {
        return this.blocks.get((Object)defBlock);
    }

    private void createPlants() {
        try {
            for (DefPlant defPlant : DefPlant.values()) {
                Constructor<? extends Block> blockCon = defPlant.plantType.blockClass.getConstructor(DefPlant.class);
                Block block = blockCon.newInstance(defPlant);
                this.plants.put(defPlant, block);
                if (defPlant.plantType == TypePlant.FLOWR) {
                    this.flowers.add(defPlant);
                }
                ++this.createdPlants;
                String blockName = defPlant.getBlockName();
                block.func_149663_c(blockName);
                block.setRegistryName("pmp", blockName);
                ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
                block.func_149647_a((CreativeTabs)PlantMegaPack.creativeTabs.getTab(ModCreativeTabs.ModTab.PMP));
                Constructor<? extends Item> itemCon = defPlant.plantType.getItemClass().getConstructor(DefPlant.class, Block.class);
                Item item = itemCon.newInstance(defPlant, block);
                item.func_77655_b(blockName);
                item.setRegistryName("pmp", blockName);
                ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
                if (defPlant.plantCategory != TypePlantCat.CROPL) continue;
                this.listCrops.add(defPlant);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void preInitPlants() {
    }

    private void initPlants(RenderItem renderItem) {
        for (DefPlant defPlant : DefPlant.values()) {
            String resourceName = String.format("%s:%s", "pmp", defPlant.getBlockName());
            renderItem.func_175037_a().func_178086_a(Item.func_150898_a((Block)this.plants.get(defPlant)), 0, new ModelResourceLocation(resourceName, "inventory"));
        }
    }

    private void postInitPlants() {
    }

    public Block getPlant(DefPlant defPlant) {
        return this.plants.get(defPlant);
    }

    public DefPlant getRandomFlowerPlantDef(Random random) {
        return this.flowers.get(random.nextInt(this.flowers.size()));
    }

    private void createSaplings() {
        for (DefTree defTree : DefTree.values()) {
            BlockTreeSapling block = new BlockTreeSapling(defTree);
            this.saplings.put(defTree, block);
            String blockName = String.format("sapli_%s", defTree.blockName);
            ++this.createdTrees;
            block.func_149663_c(blockName);
            block.setRegistryName("pmp", blockName);
            ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
            block.func_149647_a(PlantMegaPack.creativeTabs.getTab(ModCreativeTabs.ModTab.PMP));
            ItemBaseSapling item = new ItemBaseSapling(defTree, (Block)block);
            item.func_77655_b(blockName);
            item.setRegistryName("pmp", blockName);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
        }
    }

    private void preInitSaplings() {
    }

    private void initSaplings(RenderItem renderItem) {
        for (DefTree defTree : DefTree.values()) {
            String resourceName = String.format("%s:sapli_%s", "pmp", defTree.blockName);
            renderItem.func_175037_a().func_178086_a(Item.func_150898_a((Block)((Block)this.saplings.get((Object)defTree))), 0, new ModelResourceLocation(resourceName, "inventory"));
        }
    }

    private void postInitSaplings() {
    }

    public Block getSapling(DefTree defTree) {
        return (Block)this.saplings.get((Object)defTree);
    }

    private void createLeaves() {
        for (DefTree defTree : DefTree.values()) {
            BlockTreeLeaves block = new BlockTreeLeaves(defTree);
            this.leaves.put(defTree, block);
            String blockName = String.format("leave_%s", defTree.blockName);
            block.func_149663_c(blockName);
            block.setRegistryName("pmp", blockName);
            ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
            block.func_149647_a(PlantMegaPack.creativeTabs.getTab(ModCreativeTabs.ModTab.PMP));
            ItemBlock item = new ItemBlock((Block)block);
            item.func_77655_b(blockName);
            item.setRegistryName("pmp", blockName);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
        }
    }

    private void preInitLeaves() {
    }

    private void initLeaves(RenderItem renderItem) {
        for (DefTree defTree : DefTree.values()) {
            String resourceName = String.format("%s:leave_%s", "pmp", defTree.blockName);
            renderItem.func_175037_a().func_178086_a(Item.func_150898_a((Block)((Block)this.leaves.get((Object)defTree))), 0, new ModelResourceLocation(resourceName, "inventory"));
        }
    }

    private void postInitLeaves() {
        for (DefTree defTree : DefTree.values()) {
            this.leaves.get((Object)defTree).init();
        }
    }

    public BlockTreeLeaves getLeaves(DefTree defTree) {
        return this.leaves.get((Object)defTree);
    }

    private void createTreeFruits() {
        try {
            for (DefTree defTree : DefTree.values()) {
                if (!defTree.hasFruit()) continue;
                Constructor blockCon = BlockTreeFruit.class.getConstructor(DefTree.class);
                Block block = (Block)blockCon.newInstance(new Object[]{defTree});
                this.treeFruits.put(defTree, block);
                block.func_149663_c(defTree.getTreeFruitName());
                block.setRegistryName("pmp", defTree.getTreeFruitName());
                ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
                block.func_149647_a(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Block getTreeFruit(DefTree defTree) {
        return this.treeFruits.get((Object)defTree);
    }

    private void createItems() {
        try {
            for (DefItem defItem : DefItem.values()) {
                Constructor<? extends Item> itemCon = defItem.itemClass.getConstructor(DefItem.class);
                Item item = itemCon.newInstance(new Object[]{defItem});
                item.func_77655_b(defItem.itemName);
                item.setRegistryName(defItem.itemName);
                ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
                item.func_77637_a((CreativeTabs)PlantMegaPack.creativeTabs.getTab(ModCreativeTabs.ModTab.PMP));
                this.items.put(defItem, item);
                ++this.createdItems;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createFoodItems() {
        for (DefFood defFood : DefFood.values()) {
            ItemBaseFood item = new ItemBaseFood(defFood);
            item.func_77655_b(defFood.itemName);
            item.setRegistryName(defFood.itemName);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
            item.func_77637_a(PlantMegaPack.creativeTabs.getTab(ModCreativeTabs.ModTab.PMP));
            this.foodItems.put(defFood, (Item)item);
            ++this.createdItems;
        }
    }

    private void createSeedItems() {
        for (DefSeed defSeed : DefSeed.values()) {
            ItemBaseSeed item = new ItemBaseSeed(defSeed);
            item.func_77655_b(defSeed.getItemName());
            item.setRegistryName(defSeed.getItemName());
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
            item.func_77637_a(PlantMegaPack.creativeTabs.getTab(ModCreativeTabs.ModTab.PMP));
            this.seedItems.put(defSeed, item);
            ++this.createdItems;
        }
    }

    private void preInitItems() {
    }

    private void initItems(RenderItem renderItem) {
        String resourceName;
        for (DefItem defItem : DefItem.values()) {
            resourceName = String.format("%s:%s", "pmp", defItem.itemName);
            renderItem.func_175037_a().func_178086_a(this.items.get((Object)defItem), 0, new ModelResourceLocation(resourceName, "inventory"));
        }
        for (Enum enum_ : DefFood.values()) {
            resourceName = String.format("%s:%s", "pmp", ((DefFood)enum_).itemName);
            renderItem.func_175037_a().func_178086_a(this.foodItems.get(enum_), 0, new ModelResourceLocation(resourceName, "inventory"));
        }
        for (Enum enum_ : DefSeed.values()) {
            resourceName = String.format("%s:%s", "pmp", ((DefSeed)enum_).getItemName());
            renderItem.func_175037_a().func_178086_a(this.seedItems.get(enum_), 0, new ModelResourceLocation(resourceName, "inventory"));
        }
    }

    public ArrayList<DefPlant> getCropsList() {
        return (ArrayList)this.listCrops;
    }

    public ItemBaseDoor getDoorItem(DefBlock defBlock) {
        return this.doorItems.get((Object)defBlock);
    }

    public Item getFoodItem(DefFood defFood) {
        return this.foodItems.get((Object)defFood);
    }

    public Item getSeedItem(DefSeed defSeed) {
        return this.seedItems.get((Object)defSeed);
    }

    public Item getItem(DefItem defItem) {
        return this.items.get((Object)defItem);
    }
}

