/*
 * Decompiled with CFR 0.152.
 */
package pmp.core;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pmp.PlantMegaPack;
import pmp.block.BlockTreeLeaves;
import pmp.core.def.DefTree;

@SideOnly(value=Side.CLIENT)
public abstract class ModColorHandlers {
    public static void initClient() {
        Minecraft minecraft = Minecraft.func_71410_x();
        BlockColors blockColors = minecraft.func_184125_al();
        ItemColors itemColors = minecraft.getItemColors();
        ModColorHandlers.registerBlockHandlers(blockColors);
        ModColorHandlers.registerItemHandlers(blockColors, itemColors);
    }

    private static void registerBlockHandlers(BlockColors blockColors) {
        for (DefTree defTree : DefTree.values()) {
            BlockTreeLeaves blockLeaves = PlantMegaPack.objects.getLeaves(defTree);
            IBlockColor blockHandler = (state, world, pos, tintIndex) -> ((BlockTreeLeaves)state.func_177230_c()).getFoliageColor();
            blockColors.func_186722_a(blockHandler, new Block[]{blockLeaves});
        }
    }

    private static void registerItemHandlers(BlockColors blockColors, ItemColors itemColors) {
        for (DefTree defTree : DefTree.values()) {
            BlockTreeLeaves blockLeaves = PlantMegaPack.objects.getLeaves(defTree);
            IItemColor itemHandler = (stack, tintIndex) -> {
                IBlockState state = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
                return blockColors.func_186724_a(state, null, null, tintIndex);
            };
            itemColors.func_186731_a(itemHandler, new Block[]{blockLeaves});
        }
    }
}

