/*
 * Decompiled with CFR 0.152.
 */
package pmp.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pmp.PlantMegaPack;
import pmp.core.def.DefFood;
import pmp.core.def.DefTree;
import pmp.core.type.TypeFood;

public class BlockTreeFruit
extends Block
implements IGrowable {
    public static final int MAX_AGE = 7;
    private final int GROWTH_RATE = 7;
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)7);
    protected static final AxisAlignedBB AABB_BERRIES = new AxisAlignedBB(0.2, 0.5, 0.2, 0.8, 1.0, 0.8);
    protected static final AxisAlignedBB AABB_FRUIT = new AxisAlignedBB(0.2, 0.5, 0.2, 0.8, 1.0, 0.8);
    private DefTree defTree;

    public BlockTreeFruit(DefTree defTree) {
        super(Material.field_151585_k);
        this.defTree = defTree;
        this.func_149647_a(null);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185850_c);
    }

    public DefFood getFoodDef() {
        return this.defTree.food;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        int i;
        if (!this.canBlockStay(world, pos, state)) {
            this.dropBlock(world, pos, state);
            return;
        }
        if (world.field_73012_v.nextInt(this.GROWTH_RATE) == 0 && (i = Integer.valueOf((Integer)state.func_177229_b((IProperty)AGE)).intValue()) < 7) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!this.canBlockStay(world, pos, state)) {
            this.dropBlock(world, pos, state);
        }
    }

    private boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        Block blockAbove = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        return blockAbove != null && blockAbove.isWood((IBlockAccess)world, pos.func_177984_a());
    }

    private void dropBlock(World world, BlockPos pos, IBlockState state) {
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        this.func_176226_b(world, pos, state, 0);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> dropped = new ArrayList<ItemStack>();
        int j = (Integer)state.func_177229_b((IProperty)AGE);
        int dropQuantity = 1;
        if (j >= 7) {
            Random rand = new Random();
            dropQuantity = 2 + rand.nextInt(4);
        }
        for (int k = 0; k < dropQuantity; ++k) {
            dropped.add(new ItemStack(PlantMegaPack.objects.getFoodItem(this.getFoodDef()), 1, 0));
        }
        return dropped;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(PlantMegaPack.objects.getFoodItem(this.getFoodDef()), 1, 0);
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return Integer.valueOf((Integer)state.func_177229_b((IProperty)AGE)) < 7;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(Integer.valueOf((Integer)state.func_177229_b((IProperty)AGE)) + 1)), 2);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (this.getFoodDef().foodType == TypeFood.BERRY) {
            return AABB_BERRIES;
        }
        return AABB_FRUIT;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean flag) {
    }
}

