/*
 * Decompiled with CFR 0.152.
 */
package pmp.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockWall;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pmp.PlantMegaPack;
import pmp.block.BlockBasePlant;
import pmp.core.ModHelpers;
import pmp.core.def.DefPlant;
import pmp.core.variant.VariantBlockSegment;

public class BlockPlantHanging
extends BlockBasePlant
implements IGrowable {
    public static final PropertyEnum<VariantBlockSegment> SEGMENT = PropertyEnum.func_177709_a((String)"segment", VariantBlockSegment.class);

    public BlockPlantHanging(DefPlant defPlant) {
        super(defPlant);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(SEGMENT, (Comparable)((Object)VariantBlockSegment.TOP)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SEGMENT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(SEGMENT, (Comparable)((Object)VariantBlockSegment.byMetadata((meta & 0xC) >> 2)));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        return meta |= ((VariantBlockSegment)((Object)state.func_177229_b(SEGMENT))).getMetadata() << 2;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean isSideSolid(IBlockState baseState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP;
    }

    @Override
    public boolean func_176196_c(World world, BlockPos pos) {
        return this.isValidConnectionBlock(world, pos.func_177984_a()) && world.func_175623_d(pos) && world.func_175623_d(pos.func_177977_b());
    }

    @Override
    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        VariantBlockSegment segment = (VariantBlockSegment)((Object)world.func_180495_p(pos).func_177229_b(SEGMENT));
        if (segment == VariantBlockSegment.TOP) {
            return this.isValidConnectionBlock(world, pos.func_177984_a()) && world.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
        }
        IBlockState stateAbove = world.func_180495_p(pos.func_177984_a());
        if (stateAbove.func_177230_c() == this) {
            segment = (VariantBlockSegment)((Object)stateAbove.func_177229_b(SEGMENT));
            return segment == VariantBlockSegment.MIDDLE || segment == VariantBlockSegment.TOP;
        }
        return false;
    }

    private boolean isValidConnectionBlock(World world, BlockPos pos) {
        if (world.isSideSolid(pos, EnumFacing.DOWN, false)) {
            return true;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        return block instanceof BlockFence || block instanceof BlockWall;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(SEGMENT, (Comparable)((Object)VariantBlockSegment.TOP));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, 0);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!this.func_180671_f(world, pos, state)) {
            if (!Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d && world.func_180495_p(pos).func_177229_b(SEGMENT) == VariantBlockSegment.TOP) {
                this.func_176226_b(world, pos, this.func_176223_P(), 0);
            }
            this.destroyPlantFromHereDownwards(world, pos);
        } else if (state.func_177229_b(SEGMENT) == VariantBlockSegment.MIDDLE && world.func_175623_d(pos.func_177977_b())) {
            world.func_180501_a(pos, this.func_176223_P().func_177226_a(SEGMENT, (Comparable)((Object)VariantBlockSegment.BOTTOM)), 3);
        }
    }

    private void destroyPlantFromHereDownwards(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        while (block == this) {
            world.func_175698_g(pos);
            pos = pos.func_177977_b();
            block = world.func_180495_p(pos).func_177230_c();
        }
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        if (world.func_180495_p(pos).func_177229_b(SEGMENT) == VariantBlockSegment.TOP) {
            return ModHelpers.countPlantHeightFromTop(world, pos, (Block)this) < PlantMegaPack.settings.plantHangingMaxHeight && this.canGrowDown(world, pos);
        }
        return false;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return this.func_176473_a(world, pos, state, true);
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        BlockPos posCur = pos;
        Block block = world.func_180495_p(posCur).func_177230_c();
        while (block == this) {
            posCur = posCur.func_177977_b();
            block = world.func_180495_p(posCur).func_177230_c();
        }
        world.func_180501_a(posCur, this.func_176223_P().func_177226_a(SEGMENT, (Comparable)((Object)VariantBlockSegment.BOTTOM)), 3);
        posCur = posCur.func_177984_a();
        if (world.func_180495_p(posCur).func_177229_b(SEGMENT) == VariantBlockSegment.BOTTOM) {
            world.func_180501_a(posCur, this.func_176223_P().func_177226_a(SEGMENT, (Comparable)((Object)VariantBlockSegment.MIDDLE)), 3);
        }
    }

    private boolean canGrowDown(World world, BlockPos pos) {
        BlockPos posCur = pos;
        Block block = world.func_180495_p(pos).func_177230_c();
        while (block == this) {
            posCur = posCur.func_177977_b();
            block = world.func_180495_p(posCur).func_177230_c();
        }
        return world.func_180495_p(posCur).func_185904_a() == Material.field_151579_a;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.NONE;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return Block.field_185505_j;
    }
}

