/*
 * Decompiled with CFR 0.152.
 */
package pmp.block;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pmp.PlantMegaPack;
import pmp.block.BlockBasePlant;
import pmp.core.def.DefCropHarvest;
import pmp.core.def.DefPlant;

public class BlockPlantClimbing
extends BlockBasePlant
implements IGrowable,
IPlantable {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)3);
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    protected static final AxisAlignedBB AABB_S = new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_W = new AxisAlignedBB(0.0, 0.0, 0.0, 0.1875, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_N = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.1875);
    protected static final AxisAlignedBB AABB_E = new AxisAlignedBB(0.8125, 0.0, 0.0, 1.0, 1.0, 1.0);

    public BlockPlantClimbing(DefPlant defPlant) {
        super(defPlant);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE, FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)((meta & 0xC) >> 2))).func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta & 3));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        meta |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() << 2;
        return meta |= Integer.valueOf((Integer)state.func_177229_b((IProperty)AGE)).intValue();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176203_a(meta).func_177226_a((IProperty)FACING, (Comparable)facing.func_176734_d());
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.DOWN || side == EnumFacing.UP) {
            return false;
        }
        return this.func_176196_c(world, pos);
    }

    @Override
    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        Block soil = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (soil == this) {
            return true;
        }
        return super.func_180671_f(world, pos, state);
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
            return false;
        }
        return this.canContinueGrowing(world, pos, state);
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        Block soil = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        return soil != null && soil != this;
    }

    public boolean isLadder(IBlockState state, IBlockAccess source, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    private boolean canContinueGrowing(World world, BlockPos pos, IBlockState state) {
        BlockPos posTarget = new BlockPos((Vec3i)pos);
        int totalHeight = 1;
        while (world.func_180495_p(posTarget.func_177984_a()).func_177230_c() == this) {
            posTarget = posTarget.func_177984_a();
            ++totalHeight;
        }
        if (world.func_180495_p(posTarget).func_177230_c() != this) {
            return false;
        }
        int topBlockGrowth = (Integer)world.func_180495_p(posTarget).func_177229_b((IProperty)AGE);
        if (totalHeight == PlantMegaPack.settings.plantClimbingMaxHeight) {
            return topBlockGrowth < 3;
        }
        if (topBlockGrowth < 3) {
            return true;
        }
        if (!world.func_175623_d(posTarget = posTarget.func_177984_a())) {
            return false;
        }
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        posTarget = posTarget.func_177972_a(facing);
        return world.func_180495_p(posTarget).isSideSolid((IBlockAccess)world, posTarget, facing.func_176734_d());
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        if (world.func_180495_p(pos).func_177230_c() != this) {
            return;
        }
        BlockPos posTarget = new BlockPos((Vec3i)pos);
        int totalHeight = 1;
        while (world.func_180495_p(posTarget.func_177984_a()).func_177230_c() == this) {
            posTarget = posTarget.func_177984_a();
            ++totalHeight;
        }
        IBlockState blockStateTarget = world.func_180495_p(posTarget);
        int curGrowth = (Integer)blockStateTarget.func_177229_b((IProperty)AGE);
        if (totalHeight == PlantMegaPack.settings.plantClimbingMaxHeight) {
            if (curGrowth < 3) {
                world.func_180501_a(posTarget, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(++curGrowth)), 2);
                return;
            }
            return;
        }
        EnumFacing attached = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (curGrowth < 3) {
            world.func_180501_a(posTarget, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(++curGrowth)), 2);
            return;
        }
        if (world.func_175623_d(posTarget = posTarget.func_177984_a()) && world.isSideSolid(posTarget.func_177972_a(attached), attached.func_176734_d(), false)) {
            world.func_180501_a(posTarget, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)attached).func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)), 2);
            return;
        }
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess source, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return direction == EnumFacing.UP && plantable == this && state.func_177230_c() == this && (Integer)state.func_177229_b((IProperty)AGE) == 3;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, block, fromPos);
        this.func_176475_e(world, pos, state);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        super.func_180650_b(world, pos, state, random);
        if (world.func_180495_p(pos).func_177230_c() != this || world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
            return;
        }
        if (random.nextInt(5) == 0 && this.canContinueGrowing(world, pos, state)) {
            this.func_176474_b(world, random, pos, state);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.NONE;
    }

    public List<ItemStack> getDrops(IBlockAccess source, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Random rand = source instanceof World ? ((World)source).field_73012_v : RANDOM;
        ret.add(new ItemStack(this.func_180660_a(state, rand, fortune), 1, 0));
        if (Integer.valueOf((Integer)state.func_177229_b((IProperty)AGE)) == 3) {
            ret.add(new ItemStack(PlantMegaPack.objects.getFoodItem(DefCropHarvest.getFoodForPlant(this.defPlant)), 1, 0));
        }
        return ret;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch (((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b()) {
            case 0: {
                return AABB_S;
            }
            case 1: {
                return AABB_W;
            }
            case 2: {
                return AABB_N;
            }
            case 3: {
                return AABB_E;
            }
        }
        return field_185505_j;
    }
}

