/*
 * Decompiled with CFR 0.152.
 */
package pmp.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pmp.PlantMegaPack;
import pmp.core.ModHelpers;
import pmp.core.def.DefCropHarvest;
import pmp.core.def.DefPlant;

public class BlockPlantBerryBush
extends BlockCrops {
    protected DefPlant defPlant;
    protected static final AxisAlignedBB BERRYBUSH_AABB = new AxisAlignedBB(0.05, 0.0, 0.05, 0.95, 0.95, 0.95);

    public BlockPlantBerryBush(DefPlant defPlant) {
        this.defPlant = defPlant;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        int age;
        if (PlantMegaPack.settings.plantBerryFastHarvest && (age = ((Integer)state.func_177229_b((IProperty)field_176488_a)).intValue()) == 7) {
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.getRandomFoodDrop());
            world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)field_176488_a, (Comparable)Integer.valueOf(0)), 2);
            return true;
        }
        return false;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, 0);
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        int age = (Integer)state.func_177229_b((IProperty)field_176488_a);
        if (age == 7) {
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.getRandomFoodDrop());
        }
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this) {
            IBlockState soil = world.func_180495_p(pos.func_177977_b());
            return soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
        }
        return this.func_185514_i(world.func_180495_p(pos.func_177977_b()));
    }

    protected boolean func_185514_i(IBlockState state) {
        if (state.func_185904_a() == Material.field_151595_p) {
            return this.defPlant.canGrowOnSand;
        }
        Block block = state.func_177230_c();
        return block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150458_ak;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return ModHelpers.getPlantAABB(BERRYBUSH_AABB, pos);
    }

    protected Item func_149866_i() {
        return null;
    }

    protected Item func_149865_P() {
        return PlantMegaPack.objects.getFoodItem(DefCropHarvest.getFoodForPlant(this.defPlant));
    }

    private ItemStack getRandomFoodDrop() {
        Random rand = new Random();
        int dropAmount = 1 + rand.nextInt(3);
        return new ItemStack(this.func_149865_P(), dropAmount, 0);
    }
}

