/*
 * Decompiled with CFR 0.152.
 */
package pmp.block;

import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pmp.block.BlockBaseBlock;
import pmp.core.def.DefBlock;

public class BlockObjWallBracket
extends BlockBaseBlock {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    protected static final AxisAlignedBB AABB_N = new AxisAlignedBB(0.25, 0.0, 0.43, 0.75, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_E = new AxisAlignedBB(0.0, 0.0, 0.25, 0.57, 0.5, 0.75);
    protected static final AxisAlignedBB AABB_S = new AxisAlignedBB(0.25, 0.0, 0.0, 0.75, 0.5, 0.57);
    protected static final AxisAlignedBB AABB_W = new AxisAlignedBB(0.43, 0.0, 0.25, 1.0, 0.5, 0.75);

    public BlockObjWallBracket(DefBlock defBlock) {
        super(defBlock);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)((meta & 0xC) >> 2)));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        return meta |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() << 2;
    }

    @Override
    public boolean isSideSolid(IBlockState state, IBlockAccess source, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return side != EnumFacing.DOWN && side != EnumFacing.UP;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176203_a(meta).func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.func_175623_d(pos) && (this.canAttachToBlock(world, pos.func_177978_c(), EnumFacing.SOUTH) || this.canAttachToBlock(world, pos.func_177968_d(), EnumFacing.NORTH) || this.canAttachToBlock(world, pos.func_177974_f(), EnumFacing.WEST) || this.canAttachToBlock(world, pos.func_177976_e(), EnumFacing.EAST));
    }

    private boolean canBlockStay(World world, BlockPos pos) {
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
        return this.canAttachToBlock(world, pos.func_177972_a(facing.func_176734_d()), facing);
    }

    private boolean canAttachToBlock(World world, BlockPos pos, EnumFacing facing) {
        return world.func_180495_p(pos).isSideSolid((IBlockAccess)world, pos, facing);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!this.canBlockStay(world, pos)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (facing) {
            case SOUTH: {
                return AABB_S;
            }
            case NORTH: {
                return AABB_N;
            }
            case EAST: {
                return AABB_E;
            }
            case WEST: {
                return AABB_W;
            }
        }
        return field_185505_j;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean flag) {
        Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)state.func_185900_c((IBlockAccess)world, pos));
    }
}

