/*
 * Decompiled with CFR 0.152.
 */
package pmp.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pmp.PlantMegaPack;
import pmp.block.BlockBasePlant;
import pmp.block.BlockPlantBerryBush;
import pmp.core.ModHelpers;
import pmp.core.def.DefBlock;
import pmp.tileentity.TileEntityFlwrPot;

public class BlockObjFlwrPot
extends BlockContainer {
    public final DefBlock defBlock;
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);

    public BlockObjFlwrPot(DefBlock defBlock) {
        super(defBlock.getBlockType().material);
        this.defBlock = defBlock;
        this.func_149711_c(defBlock.getBlockType().hardness);
        this.func_149752_b(defBlock.getBlockType().resistance);
        this.func_149672_a(ModHelpers.getSoundFromMaterial(defBlock.getBlockType().material));
        this.func_149675_a(false);
        this.func_180632_j(this.field_176227_L.func_177621_b());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[0]);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)PlantMegaPack.objects.getBlock(this.defBlock));
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityFlwrPot();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack = playerIn.func_184586_b(hand);
        TileEntityFlwrPot tileentityflowerpot = this.getTileEntity(worldIn, pos);
        if (tileentityflowerpot == null) {
            return false;
        }
        ItemStack itemstack1 = tileentityflowerpot.getFlowerItemStack();
        if (itemstack1.func_190926_b()) {
            if (!this.canBePotted(itemstack)) {
                return false;
            }
            tileentityflowerpot.setItemStack(itemstack);
            if (!playerIn.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
        } else {
            if (itemstack.func_190926_b()) {
                playerIn.func_184611_a(hand, itemstack1);
            } else if (!playerIn.func_191521_c(itemstack1)) {
                playerIn.func_71019_a(itemstack1, false);
            }
            tileentityflowerpot.setItemStack(ItemStack.field_190927_a);
        }
        tileentityflowerpot.func_70296_d();
        worldIn.func_184138_a(pos, state, state, 3);
        return true;
    }

    @Nullable
    private TileEntityFlwrPot getTileEntity(World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity instanceof TileEntityFlwrPot ? (TileEntityFlwrPot)tileentity : null;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess source, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return true;
    }

    public boolean isFertile(World world, BlockPos pos) {
        return true;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess source, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean flag) {
        Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)state.func_185900_c((IBlockAccess)world, pos));
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntityFlwrPot te;
        super.getDrops(drops, world, pos, state, fortune);
        TileEntityFlwrPot tileEntityFlwrPot = te = world.func_175625_s(pos) instanceof TileEntityFlwrPot ? (TileEntityFlwrPot)world.func_175625_s(pos) : null;
        if (te != null && te.getFlowerPotItem() != null) {
            drops.add((Object)new ItemStack(te.getFlowerPotItem(), 1, te.getFlowerPotData()));
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    private boolean canBePotted(ItemStack stack) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        int meta = stack.func_77960_j();
        if (block instanceof BlockBasePlant) {
            return ((BlockBasePlant)block).defPlant.getPlantType().canBePotted();
        }
        if (block instanceof BlockPlantBerryBush) {
            return true;
        }
        if (block instanceof BlockSapling) {
            return true;
        }
        if (block == Blocks.field_150327_N || block == Blocks.field_150328_O || block == Blocks.field_150338_P || block == Blocks.field_150337_Q || block == Blocks.field_150330_I) {
            return true;
        }
        if (block == Blocks.field_150434_aF || block == Blocks.field_150329_H || block == Blocks.field_150392_bi) {
            return false;
        }
        if (block == Blocks.field_150398_cm) {
            return meta != BlockDoublePlant.EnumPlantType.FERN.func_176936_a() && meta != BlockDoublePlant.EnumPlantType.GRASS.func_176936_a() && meta != BlockDoublePlant.EnumPlantType.SUNFLOWER.func_176936_a();
        }
        return block instanceof BlockBush;
    }
}

