/*
 * Decompiled with CFR 0.152.
 */
package pmp.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pmp.PlantMegaPack;
import pmp.core.ModHelpers;
import pmp.core.def.DefCropHarvest;
import pmp.core.def.DefPlant;
import pmp.core.type.TypePlantCat;

public class BlockCropSingle
extends BlockCrops {
    private DefPlant defPlant;
    protected static final AxisAlignedBB[] AABB_AGE = new AxisAlignedBB[]{new AxisAlignedBB(0.15, 0.0, 0.15, 0.85, 0.125, 0.85), new AxisAlignedBB(0.15, 0.0, 0.15, 0.85, 0.25, 0.85), new AxisAlignedBB(0.15, 0.0, 0.15, 0.85, 0.375, 0.85), new AxisAlignedBB(0.15, 0.0, 0.15, 0.85, 0.5, 0.85), new AxisAlignedBB(0.15, 0.0, 0.15, 0.85, 0.625, 0.85), new AxisAlignedBB(0.15, 0.0, 0.15, 0.85, 0.75, 0.85), new AxisAlignedBB(0.15, 0.0, 0.15, 0.85, 0.875, 0.85), new AxisAlignedBB(0.15, 0.0, 0.15, 0.85, 1.0, 0.85)};

    public BlockCropSingle(DefPlant defPlant) {
        this.defPlant = defPlant;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (this.defPlant.plantCategory == TypePlantCat.CACTU) {
            return new ItemStack((Block)this, 1, 0);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState stateSoil = world.func_180495_p(pos.func_177977_b());
        if (this.defPlant.plantCategory == TypePlantCat.CACTU) {
            return stateSoil.func_185904_a() == Material.field_151595_p;
        }
        return super.func_176196_c(world, pos);
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        IBlockState stateSoil = world.func_180495_p(pos.func_177977_b());
        if (this.defPlant.plantCategory == TypePlantCat.CACTU) {
            return stateSoil.func_185904_a() == Material.field_151595_p;
        }
        return super.func_180671_f(world, pos, state);
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        if (this.defPlant.plantCategory == TypePlantCat.CACTU) {
            return new ItemStack(Item.func_150898_a((Block)this));
        }
        return new ItemStack(this.func_149866_i());
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return super.func_180660_a(state, rand, fortune);
    }

    protected Item func_149866_i() {
        if (this.defPlant.plantCategory == TypePlantCat.CACTU) {
            return Item.func_150898_a((Block)this);
        }
        return PlantMegaPack.objects.getSeedItem(DefCropHarvest.getSeedForPlant(this.defPlant));
    }

    protected Item func_149865_P() {
        return PlantMegaPack.objects.getFoodItem(DefCropHarvest.getFoodForPlant(this.defPlant));
    }

    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        return PlantMegaPack.settings.realismCropCentered ? Block.EnumOffsetType.NONE : Block.EnumOffsetType.XZ;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        AxisAlignedBB aabb = AABB_AGE[Integer.valueOf((Integer)state.func_177229_b((IProperty)this.func_185524_e()))];
        return PlantMegaPack.settings.realismCropCentered ? aabb : ModHelpers.getPlantAABB(aabb, pos);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean flag) {
        TypePlantCat category = this.defPlant.plantCategory;
        if (category == TypePlantCat.CACTU) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)state.func_185900_c((IBlockAccess)world, pos));
            return;
        }
        super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entity, flag);
    }
}

