/*
 * Decompiled with CFR 0.152.
 */
package pmp.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pmp.PlantMegaPack;
import pmp.core.ModHelpers;
import pmp.core.def.DefCropHarvest;
import pmp.core.def.DefPlant;
import pmp.core.variant.VariantBlockHalf;

public class BlockCropDouble
extends BlockCrops {
    private DefPlant defPlant;
    public static final PropertyEnum<VariantBlockHalf> HALF = PropertyEnum.func_177709_a((String)"half", VariantBlockHalf.class);
    protected static final AxisAlignedBB[] AABB_TOP = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new AxisAlignedBB(0.15, -1.0, 0.15, 0.85, 0.25, 0.85), new AxisAlignedBB(0.15, -1.0, 0.15, 0.85, 0.5, 0.85), new AxisAlignedBB(0.15, -1.0, 0.15, 0.85, 0.75, 0.85), new AxisAlignedBB(0.15, -1.0, 0.15, 0.85, 1.0, 0.85)};
    protected static final AxisAlignedBB[] AABB_BOTTOM = new AxisAlignedBB[]{new AxisAlignedBB(0.15, 0.0, 0.15, 0.85, 0.25, 0.85), new AxisAlignedBB(0.15, 0.0, 0.15, 0.85, 0.5, 0.85), new AxisAlignedBB(0.15, 0.0, 0.15, 0.85, 0.75, 0.85), new AxisAlignedBB(0.15, 0.0, 0.15, 0.85, 1.0, 0.85), new AxisAlignedBB(0.15, 0.0, 0.15, 0.85, 1.25, 0.85), new AxisAlignedBB(0.15, 0.0, 0.15, 0.85, 1.5, 0.85), new AxisAlignedBB(0.15, 0.0, 0.15, 0.85, 1.75, 0.85), new AxisAlignedBB(0.15, 0.0, 0.15, 0.85, 2.0, 0.85)};

    public BlockCropDouble(DefPlant defPlant) {
        this.defPlant = defPlant;
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)field_176488_a, (Comparable)Integer.valueOf(0)).func_177226_a(HALF, (Comparable)((Object)VariantBlockHalf.BOTTOM)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176488_a, HALF});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176488_a, (Comparable)Integer.valueOf(meta & 7)).func_177226_a(HALF, (Comparable)((Object)VariantBlockHalf.byMetadata((meta & 8) >> 3)));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        meta |= Integer.valueOf((Integer)state.func_177229_b((IProperty)field_176488_a)).intValue();
        return meta |= ((VariantBlockHalf)((Object)state.func_177229_b(HALF))).getMetadata() << 3;
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        IBlockState stateBelow = world.func_180495_p(pos.func_177977_b());
        if ((VariantBlockHalf)((Object)state.func_177229_b(HALF)) == VariantBlockHalf.TOP) {
            return stateBelow.func_177230_c() == this && (VariantBlockHalf)((Object)stateBelow.func_177229_b(HALF)) == VariantBlockHalf.BOTTOM;
        }
        return super.func_180671_f(world, pos, state);
    }

    protected void func_176475_e(World world, BlockPos pos, IBlockState state) {
        if (!this.func_180671_f(world, pos, state)) {
            if ((VariantBlockHalf)((Object)state.func_177229_b(HALF)) == VariantBlockHalf.BOTTOM) {
                this.func_176226_b(world, pos, state, 0);
            }
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        VariantBlockHalf position = (VariantBlockHalf)((Object)state.func_177229_b(HALF));
        if (position == VariantBlockHalf.BOTTOM) {
            if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
                world.func_175698_g(pos.func_177984_a());
            }
        } else if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
            world.func_175698_g(pos.func_177977_b());
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        float f;
        if ((VariantBlockHalf)((Object)state.func_177229_b(HALF)) == VariantBlockHalf.BOTTOM && world.func_175671_l(pos.func_177984_a()) >= 9 && Integer.valueOf((Integer)state.func_177229_b((IProperty)field_176488_a)) < 7 && rand.nextInt((int)(25.0f / (f = BlockCropDouble.func_180672_a((Block)this, (World)world, (BlockPos)pos))) + 1) == 0) {
            this.growPlant(world, pos, state, 1);
        }
        this.func_176475_e(world, pos, state);
    }

    private void growPlant(World world, BlockPos pos, IBlockState state, int growAmount) {
        if ((VariantBlockHalf)((Object)state.func_177229_b(HALF)) == VariantBlockHalf.BOTTOM) {
            int age = Integer.valueOf((Integer)state.func_177229_b((IProperty)field_176488_a)) + growAmount;
            if (age > 7) {
                age = 7;
            }
            if (age > 3 && world.func_175623_d(pos.func_177984_a()) || world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
                world.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)field_176488_a, (Comparable)Integer.valueOf(age)).func_177226_a(HALF, (Comparable)((Object)VariantBlockHalf.TOP)), 2);
            }
            world.func_180501_a(pos, state.func_177226_a((IProperty)field_176488_a, (Comparable)Integer.valueOf(age)).func_177226_a(HALF, (Comparable)((Object)VariantBlockHalf.BOTTOM)), 2);
        } else {
            this.growPlant(world, pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()), growAmount);
        }
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        this.growPlant(world, pos, state, MathHelper.func_76136_a((Random)rand, (int)2, (int)5));
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        int age = (Integer)state.func_177229_b((IProperty)field_176488_a);
        if ((VariantBlockHalf)((Object)state.func_177229_b(HALF)) == VariantBlockHalf.BOTTOM) {
            if (age < 7) {
                return true;
            }
            if (age == 3 && world.func_175623_d(pos.func_177984_a())) {
                return true;
            }
            if (world.func_180495_p(pos.func_177984_a()).func_177230_c() != this) {
                return false;
            }
        }
        return age < 7;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(this.func_149866_i(), 1, 0);
    }

    protected Item func_149866_i() {
        return PlantMegaPack.objects.getSeedItem(DefCropHarvest.getSeedForPlant(this.defPlant));
    }

    protected Item func_149865_P() {
        return PlantMegaPack.objects.getFoodItem(DefCropHarvest.getFoodForPlant(this.defPlant));
    }

    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        return PlantMegaPack.settings.realismCropCentered ? Block.EnumOffsetType.NONE : Block.EnumOffsetType.XZ;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int stage = (Integer)source.func_180495_p(pos).func_177229_b((IProperty)field_176488_a);
        AxisAlignedBB aabb = (VariantBlockHalf)((Object)state.func_177229_b(HALF)) == VariantBlockHalf.TOP ? AABB_TOP[stage] : AABB_BOTTOM[stage];
        return PlantMegaPack.settings.realismCropCentered ? aabb : ModHelpers.getPlantAABB(aabb, pos);
    }
}

