/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.event;

import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.Motive;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import subaraki.paintings.network.supplier.SyncpacketSupplier;
import subaraki.paintings.utils.CommonConfig;
import subaraki.paintings.utils.PaintingUtility;

public class ProcessInteractEvent {
    private static boolean equalSizes(Motive a, Motive b) {
        return a.m_31896_() == b.m_31896_() && a.m_31901_() == b.m_31901_();
    }

    private static boolean equalNames(Motive a, Motive b) {
        return Registry.f_122831_.m_7981_((Object)a).equals((Object)Registry.f_122831_.m_7981_((Object)b));
    }

    public static void processInteractPainting(Player player, Entity target, InteractionHand hand, SyncpacketSupplier syncpacketSupplier) {
        if (CommonConfig.cycle_paintings && target instanceof Painting) {
            ServerPlayer serverPlayer;
            Painting painting = (Painting)target;
            if (hand.equals((Object)InteractionHand.MAIN_HAND) && player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).m_21120_(hand).m_41720_().equals(Items.f_42487_)) {
                Motive original = painting.f_31902_;
                Motive firstMatch = null;
                Motive newArt = null;
                List<Motive> validArtsArray = Registry.f_122831_.m_123024_().sorted(PaintingUtility.ART_COMPARATOR).toList();
                boolean takeNext = false;
                for (Motive type : validArtsArray) {
                    if (ProcessInteractEvent.equalSizes(original, type)) {
                        if (firstMatch == null) {
                            firstMatch = type;
                        }
                        if (takeNext) {
                            newArt = type;
                            break;
                        }
                        if (!ProcessInteractEvent.equalNames(original, type)) continue;
                        takeNext = true;
                        continue;
                    }
                    if (!takeNext) continue;
                    newArt = firstMatch;
                    break;
                }
                if (newArt == null && takeNext) {
                    newArt = firstMatch;
                }
                painting.f_31902_ = newArt;
                syncpacketSupplier.send(painting, serverPlayer);
            }
        }
    }
}

