/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.optifine.Config;
import net.optifine.Log;
import net.optifine.entity.model.CustomEntityModelParser;
import net.optifine.entity.model.CustomEntityRenderer;
import net.optifine.entity.model.CustomModelRegistry;
import net.optifine.entity.model.CustomModelRenderer;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.entity.model.anim.IModelResolver;
import net.optifine.entity.model.anim.ModelResolver;
import net.optifine.entity.model.anim.ModelUpdater;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorField;
import net.optifine.util.Either;
import net.optifine.util.StrUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CustomEntityModels {
    private static boolean active = false;
    private static Map<axo, evj> originalEntityRenderMap = null;
    private static Map<cmt, esp> originalTileEntityRenderMap = null;
    private static Map<cjw.a, eld> originalSkullModelMap = null;
    private static List<cmt> customTileEntityTypes = new ArrayList();
    private static eiw customBookModel;
    private static boolean debugModels;

    public static void update() {
        Map entityRenderMap = CustomEntityModels.getEntityRenderMap();
        Map tileEntityRenderMap = CustomEntityModels.getTileEntityRenderMap();
        Map skullModelMap = CustomEntityModels.getSkullModelMap();
        if (entityRenderMap == null) {
            Config.warn((String)"Entity render map not found, custom entity models are DISABLED.");
            return;
        }
        if (tileEntityRenderMap == null) {
            Config.warn((String)"Tile entity render map not found, custom entity models are DISABLED.");
            return;
        }
        active = false;
        entityRenderMap.clear();
        tileEntityRenderMap.clear();
        skullModelMap.clear();
        customTileEntityTypes.clear();
        entityRenderMap.putAll(originalEntityRenderMap);
        tileEntityRenderMap.putAll(originalTileEntityRenderMap);
        skullModelMap.putAll(originalSkullModelMap);
        eqe blockEntityRenderer = dyr.D().ad().getBlockEntityRenderer();
        blockEntityRenderer.j = new elj(ModelAdapter.bakeModelLayer((elz)ema.bu));
        customBookModel = null;
        esp.CACHED_TYPES.clear();
        if (!Config.isCustomEntityModels()) {
            return;
        }
        yt[] locs = CustomEntityModels.getModelLocations();
        for (int i2 = 0; i2 < locs.length; ++i2) {
            yt loc = locs[i2];
            Config.dbg((String)("CustomEntityModel: " + loc.a()));
            IEntityRenderer rc = CustomEntityModels.parseEntityRender((yt)loc);
            if (rc == null) continue;
            Either type = rc.getType();
            if (rc instanceof evj) {
                ext tr;
                elj tm;
                entityRenderMap.put((axo)type.getLeft().get(), (evj)rc);
                if (rc instanceof ext && (tm = (elj)Reflector.getFieldValue((Object)(tr = (ext)rc), (ReflectorField)Reflector.RenderTrident_modelTrident)) != null) {
                    blockEntityRenderer.j = tm;
                }
            } else if (rc instanceof esp) {
                tileEntityRenderMap.put((cmt)type.getRight().get(), (esp)rc);
                if (rc instanceof esw) {
                    esw etr = (esw)rc;
                    eiw bm = (eiw)Reflector.getFieldValue((Object)etr, (ReflectorField)Reflector.TileEntityEnchantmentTableRenderer_modelBook);
                    CustomEntityModels.setEnchantmentScreenBookModel((eiw)bm);
                }
                customTileEntityTypes.add((cmt)type.getRight().get());
            } else {
                Config.warn((String)("Unknown renderer type: " + rc.getClass().getName()));
            }
            active = true;
        }
    }

    private static void setEnchantmentScreenBookModel(eiw bookModel) {
        customBookModel = bookModel;
    }

    private static Map<axo, evj> getEntityRenderMap() {
        evi rm = dyr.D().ab();
        Map entityRenderMap = rm.getEntityRenderMap();
        if (entityRenderMap == null) {
            return null;
        }
        if (originalEntityRenderMap == null) {
            originalEntityRenderMap = new HashMap(entityRenderMap);
        }
        return entityRenderMap;
    }

    private static Map<cmt, esp> getTileEntityRenderMap() {
        eso blockEntityRenderDispatcher = dyr.D().ac();
        Map tileEntityRenderMap = blockEntityRenderDispatcher.getBlockEntityRenderMap();
        if (originalTileEntityRenderMap == null) {
            originalTileEntityRenderMap = new HashMap(tileEntityRenderMap);
        }
        return tileEntityRenderMap;
    }

    private static Map<cjw.a, eld> getSkullModelMap() {
        HashMap skullModelMap = etb.models;
        if (skullModelMap == null) {
            Config.warn((String)"Field not found: SkullBlockRenderer.MODELS");
            skullModelMap = new HashMap();
        }
        if (originalSkullModelMap == null) {
            originalSkullModelMap = new HashMap(skullModelMap);
        }
        return skullModelMap;
    }

    private static yt[] getModelLocations() {
        String prefix = "optifine/cem/";
        String suffix = ".jem";
        ArrayList<yt> resourceLocations = new ArrayList<yt>();
        String[] names = CustomModelRegistry.getModelNames();
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            String path = prefix + name + suffix;
            yt loc = new yt(path);
            if (!Config.hasResource((yt)loc) && !debugModels) continue;
            resourceLocations.add(loc);
        }
        yt[] locs = resourceLocations.toArray(new yt[resourceLocations.size()]);
        return locs;
    }

    private static IEntityRenderer parseEntityRender(yt location) {
        try {
            if (debugModels) {
                return CustomEntityModels.makeDebugEntityRenderer((yt)location);
            }
            JsonObject jo = CustomEntityModelParser.loadJson((yt)location);
            IEntityRenderer render = CustomEntityModels.parseEntityRender((JsonObject)jo, (String)location.a());
            return render;
        }
        catch (IOException e) {
            Config.error((String)(e.getClass().getName() + ": " + e.getMessage()));
            return null;
        }
        catch (JsonParseException e) {
            Config.error((String)(((Object)((Object)e)).getClass().getName() + ": " + e.getMessage()));
            return null;
        }
        catch (Exception e) {
            Log.warn((String)("Error loading CEM: " + location), (Throwable)e);
            return null;
        }
    }

    private static IEntityRenderer makeDebugEntityRenderer(yt loc) {
        String path = loc.a();
        String nameJem = StrUtils.removePrefix((String)path, (String)"optifine/cem/");
        String name = StrUtils.removeSuffix((String)nameJem, (String)".jem");
        ModelAdapter ma = CustomModelRegistry.getModelAdapter((String)name);
        eke model = ma.makeModel();
        bts[] colors = bts.values();
        int offset = Math.abs(loc.hashCode()) % 256;
        String[] partNames = ma.getModelRendererNames();
        for (int i2 = 0; i2 < partNames.length; ++i2) {
            String partName = partNames[i2];
            emb part = ma.getModelRenderer(model, partName);
            if (part == null) continue;
            bts col = colors[(i2 + offset) % colors.length];
            yt locTexture = new yt("textures/block/" + col.c() + "_stained_glass.png");
            part.setTextureLocation(locTexture);
            Config.dbg((String)("  " + partName + ": " + col.c()));
        }
        IEntityRenderer er = ma.makeEntityRender(model, ma.getShadowSize());
        if (er == null) {
            return null;
        }
        er.setType(ma.getType());
        return er;
    }

    private static IEntityRenderer parseEntityRender(JsonObject obj, String path) {
        CustomEntityRenderer cer = CustomEntityModelParser.parseEntityRender((JsonObject)obj, (String)path);
        String name = cer.getName();
        ModelAdapter modelAdapter = CustomModelRegistry.getModelAdapter((String)name);
        CustomEntityModels.checkNull((Object)modelAdapter, (String)("Entity not found: " + name));
        Either type = modelAdapter.getType();
        CustomEntityModels.checkNull((Object)type, (String)("Entity type not found: " + name));
        IEntityRenderer render = CustomEntityModels.makeEntityRender((ModelAdapter)modelAdapter, (CustomEntityRenderer)cer);
        if (render == null) {
            return null;
        }
        render.setType(type);
        return render;
    }

    private static IEntityRenderer makeEntityRender(ModelAdapter modelAdapter, CustomEntityRenderer cer) {
        eke model;
        yt textureLocation = cer.getTextureLocation();
        CustomModelRenderer[] modelRenderers = cer.getCustomModelRenderers();
        float shadowSize = cer.getShadowSize();
        if (shadowSize < 0.0f) {
            shadowSize = modelAdapter.getShadowSize();
        }
        if ((model = modelAdapter.makeModel()) == null) {
            return null;
        }
        ModelResolver mr = new ModelResolver(modelAdapter, model, modelRenderers);
        if (!CustomEntityModels.modifyModel((ModelAdapter)modelAdapter, (eke)model, (CustomModelRenderer[])modelRenderers, (ModelResolver)mr)) {
            return null;
        }
        IEntityRenderer r = modelAdapter.makeEntityRender(model, shadowSize);
        if (r == null) {
            throw new JsonParseException("Entity renderer is null, model: " + modelAdapter.getName() + ", adapter: " + modelAdapter.getClass().getName());
        }
        if (textureLocation != null) {
            CustomEntityModels.setTextureLocation((ModelAdapter)modelAdapter, (eke)model, (IEntityRenderer)r, (yt)textureLocation);
        }
        return r;
    }

    private static void setTextureLocation(ModelAdapter modelAdapter, eke model, IEntityRenderer er, yt textureLocation) {
        if (modelAdapter.setTextureLocation(er, textureLocation)) {
            return;
        }
        if (er instanceof ewk) {
            er.setLocationTextureCustom(textureLocation);
            return;
        }
        CustomEntityModels.setTextureTopModelRenderers((ModelAdapter)modelAdapter, (eke)model, (yt)textureLocation);
    }

    public static void setTextureTopModelRenderers(ModelAdapter modelAdapter, eke model, yt textureLocation) {
        String[] parts = modelAdapter.getModelRendererNames();
        for (int i2 = 0; i2 < parts.length; ++i2) {
            String part = parts[i2];
            emb modelRenderer = modelAdapter.getModelRenderer(model, part);
            if (modelRenderer == null || modelRenderer.getTextureLocation() != null) continue;
            modelRenderer.setTextureLocation(textureLocation);
        }
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, eke model, CustomModelRenderer[] modelRenderers, ModelResolver mr) {
        for (int i2 = 0; i2 < modelRenderers.length; ++i2) {
            CustomModelRenderer cmr2 = modelRenderers[i2];
            if (CustomEntityModels.modifyModel((ModelAdapter)modelAdapter, (eke)model, (CustomModelRenderer)cmr2, (ModelResolver)mr)) continue;
            return false;
        }
        return true;
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, eke model, CustomModelRenderer customModelRenderer, ModelResolver modelResolver) {
        String modelPart = customModelRenderer.getModelPart();
        emb parent = modelAdapter.getModelRenderer(model, modelPart);
        if (parent == null) {
            Config.warn((String)("Model part not found: " + modelPart + ", model: " + model));
            return false;
        }
        if (!customModelRenderer.isAttach()) {
            if (parent.h != null) {
                parent.h.clear();
            }
            if (parent.spriteList != null) {
                parent.spriteList.clear();
            }
            if (parent.i != null) {
                emb[] mrs = modelAdapter.getModelRenderers(model);
                Set setMrs = Collections.newSetFromMap(new IdentityHashMap());
                setMrs.addAll(Arrays.asList(mrs));
                HashSet childModelKeys = new HashSet(parent.i.keySet());
                for (String key : childModelKeys) {
                    emb mr = (emb)parent.i.get(key);
                    if (setMrs.contains(mr)) continue;
                    parent.i.remove(key);
                }
            }
        }
        String childName = parent.getUniqueChildModelName("CEM-" + modelPart);
        parent.addChildModel(childName, customModelRenderer.getModelRenderer());
        ModelUpdater mu = customModelRenderer.getModelUpdater();
        if (mu != null) {
            modelResolver.setThisModelRenderer(customModelRenderer.getModelRenderer());
            modelResolver.setPartModelRenderer(parent);
            if (!mu.initialize((IModelResolver)modelResolver)) {
                return false;
            }
            customModelRenderer.getModelRenderer().setModelUpdater(mu);
        }
        return true;
    }

    private static void checkNull(Object obj, String msg) {
        if (obj == null) {
            throw new JsonParseException(msg);
        }
    }

    public static boolean isActive() {
        return active;
    }

    public static boolean isCustomModel(cov blockStateIn) {
        for (int i2 = 0; i2 < customTileEntityTypes.size(); ++i2) {
            cmt type = (cmt)customTileEntityTypes.get(i2);
            if (!type.a(blockStateIn)) continue;
            return true;
        }
        return false;
    }

    public static void onRenderScreen(edw screen) {
        if (customBookModel != null && screen instanceof efl) {
            efl es = (efl)screen;
            Reflector.GuiEnchantment_bookModel.setValue((Object)es, (Object)customBookModel);
        }
    }

    static {
        debugModels = Boolean.getBoolean("cem.debug.models");
    }
}

