/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.railcraft;

import com.google.common.collect.Maps;
import java.util.HashMap;
import mods.railcraft.api.fuel.FuelManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import openperipheral.api.helpers.ItemStackMetaProviderSimple;

public class BoilerFuelMetaProvider
extends ItemStackMetaProviderSimple<IFluidContainerItem> {
    @Override
    public String getKey() {
        return "boiler_fuel";
    }

    @Override
    public Object getMeta(IFluidContainerItem target, ItemStack stack) {
        int heatPerBucket;
        FluidStack fluidStack = target.getFluid(stack);
        if (fluidStack != null && fluidStack.amount > 0 && (heatPerBucket = FuelManager.getBoilerFuelValue((Fluid)fluidStack.getFluid())) > 0) {
            HashMap result = Maps.newHashMap();
            result.put("total", Float.valueOf((float)heatPerBucket / 1000.0f * (float)fluidStack.amount));
            result.put("per_bucket", heatPerBucket);
            return result;
        }
        return null;
    }
}

