/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import openmods.Log;
import openmods.config.ConfigChangeListener;
import openmods.config.properties.ConfigProcessing;
import openmods.integration.IIntegrationModule;
import openmods.integration.Integration;
import openperipheral.integration.Config;
import openperipheral.integration.OpcAccess;
import openperipheral.integration.appeng.ModuleAppEng;
import openperipheral.integration.buildcraft.ModuleBuildCraftFacades;
import openperipheral.integration.buildcraft.ModuleBuildCraftTile;
import openperipheral.integration.buildcraft.ModuleBuildCraftTransport;
import openperipheral.integration.cofh.energy.ModuleCofhEnergy;
import openperipheral.integration.cofh.inventory.ModuleCofhInventory;
import openperipheral.integration.cofh.item.ModuleCofhItem;
import openperipheral.integration.cofh.tileentity.ModuleCofhTileEntity;
import openperipheral.integration.cofh.transport.ModuleCofhTransport;
import openperipheral.integration.computercraft.ModuleComputerCraft;
import openperipheral.integration.enderstorage.ModuleEnderStorage;
import openperipheral.integration.forestry.ModuleForestry;
import openperipheral.integration.ic2.ModuleIC2;
import openperipheral.integration.ic2.ModuleIC2Api;
import openperipheral.integration.minefactoryreloaded.ModuleMinefactoryReloaded;
import openperipheral.integration.minefactoryreloaded.ModuleMinefactoryReloadedStorage;
import openperipheral.integration.mystcraft.v1.ModuleMystcraftV1;
import openperipheral.integration.mystcraft.v2.ModuleMystcraftV2;
import openperipheral.integration.railcraft.ModuleRailcraft;
import openperipheral.integration.railcraft.ModuleRailcraftCarts;
import openperipheral.integration.railcraft.ModuleRailcraftFuel;
import openperipheral.integration.thaumcraft.ModuleThaumcraft;
import openperipheral.integration.thaumcraft.ModuleThaumcraftApi;
import openperipheral.integration.thermalexpansion.ModuleThermalExpansion;
import openperipheral.integration.tmechworks.ModuleTMechworks;
import openperipheral.integration.vanilla.ModuleVanilla;
import openperipheral.integration.vanilla.ModuleVanillaInventory;
import openperipheral.integration.vanilla.ModuleVanillaInventoryManipulation;

@Mod(modid="OpenPeripheralIntegration", name="OpenPeripheralIntegration", version="0.6", guiFactory="openperipheral.integration.ConfigGuiFactory", acceptableRemoteVersions="*", dependencies="required-after:OpenMods@[0.10,0.11);required-after:OpenPeripheralApi@3.4.2;after:ComputerCraft@[1.70,];after:appliedEnergistics-2;after:IC2;after:EnderStorage;after:BuildCraft|Core;after:Forestry;after:Mystcraft;after:Railcraft;after:Thaumcraft;after:ThermalExpansion;")
public class OpenPeripheralIntegration {
    public static final String MOD_ID = "OpenPeripheralIntegration";
    public static final String CATEGORY_MODULES = "modules";
    @Mod.Instance(value="OpenPeripheralIntegration")
    public static OpenPeripheralIntegration instance;
    private Configuration config;

    private static boolean checkConfig(Configuration config, String value) {
        Property property = config.get(CATEGORY_MODULES, value, true);
        property.setRequiresMcRestart(true);
        return property.getBoolean();
    }

    private static boolean sameOrNewerVersion(String modid, String version) {
        ModContainer modContainer = (ModContainer)Loader.instance().getIndexedModList().get(modid);
        if (modContainer == null) {
            return true;
        }
        DefaultArtifactVersion targetVersion = new DefaultArtifactVersion(version);
        ArtifactVersion actualVersion = modContainer.getProcessedVersion();
        return actualVersion.compareTo((Object)targetVersion) >= 0;
    }

    Configuration config() {
        return this.config;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        this.config = new Configuration(evt.getSuggestedConfigurationFile());
        if (this.config.hasCategory("integration")) {
            ConfigCategory integration = this.config.getCategory("integration");
            this.config.removeCategory(integration);
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "vanilla")) {
            Integration.addModule((IIntegrationModule)new ModuleVanilla());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "vanilla-inventory")) {
            Integration.addModule((IIntegrationModule)new ModuleVanillaInventory());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "vanilla-inventory-manipulation")) {
            Integration.addModule((IIntegrationModule)new ModuleVanillaInventoryManipulation());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "cofh-api-energy")) {
            Integration.addModule((IIntegrationModule)new ModuleCofhEnergy());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "cofh-api-inventory")) {
            Integration.addModule((IIntegrationModule)new ModuleCofhInventory());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "cofh-api-item")) {
            Integration.addModule((IIntegrationModule)new ModuleCofhItem());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "cofh-api-tileentity")) {
            Integration.addModule((IIntegrationModule)new ModuleCofhTileEntity());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "cofh-api-transport")) {
            Integration.addModule((IIntegrationModule)new ModuleCofhTransport());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "buildcraft-api-transport")) {
            Integration.addModule((IIntegrationModule)new ModuleBuildCraftTransport());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "buildcraft-api-tilenentity")) {
            Integration.addModule((IIntegrationModule)new ModuleBuildCraftTile());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "buildcraft-api-facades")) {
            Integration.addModule((IIntegrationModule)new ModuleBuildCraftFacades());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "ic2-mod")) {
            Integration.addModule((IIntegrationModule)new ModuleIC2());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "ic2-api")) {
            Integration.addModule((IIntegrationModule)new ModuleIC2Api());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "railcraft-mod")) {
            Integration.addModule((IIntegrationModule)new ModuleRailcraft());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "railcraft-api-carts")) {
            Integration.addModule((IIntegrationModule)new ModuleRailcraftCarts());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "railcraft-api-fuel")) {
            Integration.addModule((IIntegrationModule)new ModuleRailcraftFuel());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "thaumcraft-mod")) {
            Integration.addModule((IIntegrationModule)new ModuleThaumcraft());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "thaumcraft-api")) {
            Integration.addModule((IIntegrationModule)new ModuleThaumcraftApi());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "mfr-mod")) {
            Integration.addModule((IIntegrationModule)new ModuleMinefactoryReloaded());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "mfr-mod-storage")) {
            Integration.addModule((IIntegrationModule)new ModuleMinefactoryReloadedStorage());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "computercraft-mod")) {
            Integration.addModule((IIntegrationModule)new ModuleComputerCraft());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "enderstorage-mod")) {
            Integration.addModule((IIntegrationModule)new ModuleEnderStorage());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "forestry-mod")) {
            Integration.addModule((IIntegrationModule)new ModuleForestry());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "mystcraft-mod")) {
            if (OpenPeripheralIntegration.sameOrNewerVersion("Mystcraft", "0.11.1.00")) {
                if (OpenPeripheralIntegration.sameOrNewerVersion("Mystcraft", "0.11.6.02")) {
                    FMLInterModComms.sendMessage((String)"Mystcraft", (String)"API", (String)"openperipheral.integration.mystcraft.v2.MystcraftAccess.init");
                    Integration.addModule((IIntegrationModule)new ModuleMystcraftV2());
                } else {
                    Log.warn((String)"Unsupported Mystcraft version!", (Object[])new Object[0]);
                }
            } else {
                Log.warn((String)"Using old Mystcraft integration, things may explode", (Object[])new Object[0]);
                Integration.addModule((IIntegrationModule)new ModuleMystcraftV1());
            }
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "thaumcraft-mod")) {
            Integration.addModule((IIntegrationModule)new ModuleThaumcraft());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "tmechworks-mod")) {
            Integration.addModule((IIntegrationModule)new ModuleTMechworks());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "thermalexpansion-mod")) {
            Integration.addModule((IIntegrationModule)new ModuleThermalExpansion());
        }
        if (OpenPeripheralIntegration.checkConfig(this.config, "ae2-mod")) {
            Integration.addModule((IIntegrationModule)new ModuleAppEng());
        }
        ConfigProcessing.processAnnotations((String)MOD_ID, (Configuration)this.config, Config.class);
        FMLCommonHandler.instance().bus().register((Object)new ConfigChangeListener(MOD_ID, this.config));
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        OpcAccess.checkApiPresent();
    }
}

