/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses.server;

import com.google.common.base.Optional;
import com.google.common.collect.MapMaker;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.ServerChatEvent;
import openperipheral.addons.Config;
import openperipheral.addons.api.TerminalRegisterEvent;
import openperipheral.addons.glasses.GlassesEvent;
import openperipheral.addons.glasses.TerminalEvent;
import openperipheral.addons.glasses.TerminalIdAccess;
import openperipheral.addons.glasses.TileEntityGlassesBridge;

public class TerminalManagerServer {
    public static final TerminalManagerServer instance = new TerminalManagerServer();
    private final Map<Long, TileEntityGlassesBridge> listeners = new MapMaker().weakValues().makeMap();
    private static final String EVENT_CHAT_COMMAND = "glasses_chat_command";
    private static final String EVENT_CHAT_MESSAGE = "glasses_chat_message";

    private TerminalManagerServer() {
    }

    public Object createForgeListener() {
        return new ForgeListener();
    }

    public Object createFmlListener() {
        return new FmlListener();
    }

    public void registerBridge(long terminalId, TileEntityGlassesBridge bridge) {
        this.listeners.put(terminalId, bridge);
    }

    public class FmlListener {
        @SubscribeEvent
        public void onPlayerTick(TickEvent.PlayerTickEvent evt) {
            TileEntityGlassesBridge listener;
            Optional<Long> guid;
            if (evt.phase == TickEvent.Phase.START && evt.player instanceof EntityPlayerMP && (guid = TerminalIdAccess.instance.getIdFrom(evt.player)).isPresent() && (listener = (TileEntityGlassesBridge)TerminalManagerServer.this.listeners.get(guid.get())) != null) {
                listener.registerTerminal((EntityPlayerMP)evt.player);
            }
        }
    }

    public class ForgeListener {
        @SubscribeEvent(priority=EventPriority.HIGH)
        public void onServerChatEvent(ServerChatEvent event) {
            EntityPlayerMP player = event.player;
            Optional<Long> guid = TerminalIdAccess.instance.getIdFrom((EntityPlayer)player);
            if (guid.isPresent()) {
                if (event.message.startsWith("$$")) {
                    this.sendChatEvent(TerminalManagerServer.EVENT_CHAT_COMMAND, player, (Long)guid.get(), event.message.substring(2).trim());
                    event.setCanceled(true);
                } else if (Config.listenToAllChat) {
                    this.sendChatEvent(TerminalManagerServer.EVENT_CHAT_MESSAGE, player, (Long)guid.get(), event.message);
                }
            }
        }

        private void sendChatEvent(String event, EntityPlayerMP player, Long guid, String message) {
            TileEntityGlassesBridge listener = (TileEntityGlassesBridge)TerminalManagerServer.this.listeners.get(guid);
            if (listener != null) {
                listener.onChatCommand(event, message, (EntityPlayer)player);
            }
        }

        @SubscribeEvent
        public void onResetRequest(TerminalEvent.PrivateDrawableReset evt) {
            TileEntityGlassesBridge listener = (TileEntityGlassesBridge)TerminalManagerServer.this.listeners.get(evt.terminalId);
            if (listener != null) {
                listener.handlePrivateDrawableResetRequest(evt);
            }
        }

        @SubscribeEvent
        public void onResetRequest(TerminalEvent.PublicDrawableReset evt) {
            TileEntityGlassesBridge listener = (TileEntityGlassesBridge)TerminalManagerServer.this.listeners.get(evt.terminalId);
            if (listener != null) {
                listener.handlePublicDrawableResetRequest(evt);
            }
        }

        @SubscribeEvent
        public void onTerminalRegister(TerminalRegisterEvent evt) {
            TileEntityGlassesBridge listener = (TileEntityGlassesBridge)TerminalManagerServer.this.listeners.get(evt.terminalId);
            if (listener != null) {
                listener.registerTerminal(evt.player);
            }
        }

        @SubscribeEvent
        public void onGlassesEvent(GlassesEvent.GlassesClientEvent evt) {
            TileEntityGlassesBridge listener = (TileEntityGlassesBridge)TerminalManagerServer.this.listeners.get(evt.guid);
            if (listener != null) {
                listener.handleUserEvent(evt);
            }
        }
    }
}

