/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.OpenBlocks;
import openblocks.common.Stencil;
import openblocks.common.item.ItemPaintBrush;
import openblocks.common.item.ItemSqueegee;
import openblocks.common.item.ItemStencil;
import openblocks.common.sync.SyncableBlockLayers;
import openmods.api.IActivateAwareTile;
import openmods.api.ICustomBreakDrops;
import openmods.api.ICustomHarvestDrops;
import openmods.sync.SyncableBlock;
import openmods.sync.SyncableInt;
import openmods.sync.SyncableIntArray;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.BlockUtils;

public class TileEntityCanvas
extends SyncedTileEntity
implements IActivateAwareTile,
ICustomBreakDrops,
ICustomHarvestDrops {
    public static final int[] ALL_SIDES = new int[]{0, 1, 2, 3, 4, 5};
    private SyncableBlock paintedBlock;
    private SyncableInt paintedBlockMeta;
    private SyncableIntArray baseColors;
    private SyncableBlockLayers stencilsUp;
    private SyncableBlockLayers stencilsDown;
    private SyncableBlockLayers stencilsEast;
    private SyncableBlockLayers stencilsWest;
    private SyncableBlockLayers stencilsNorth;
    private SyncableBlockLayers stencilsSouth;
    private SyncableBlockLayers[] allSides;

    public TileEntityCanvas() {
        this.syncMap.addUpdateListener(this.createRenderUpdateListener());
    }

    public SyncableIntArray getBaseColors() {
        return this.baseColors;
    }

    protected void createSyncedFields() {
        this.stencilsUp = new SyncableBlockLayers();
        this.stencilsDown = new SyncableBlockLayers();
        this.stencilsEast = new SyncableBlockLayers();
        this.stencilsWest = new SyncableBlockLayers();
        this.stencilsNorth = new SyncableBlockLayers();
        this.stencilsSouth = new SyncableBlockLayers();
        this.allSides = new SyncableBlockLayers[]{this.stencilsDown, this.stencilsUp, this.stencilsNorth, this.stencilsSouth, this.stencilsWest, this.stencilsEast};
        this.baseColors = new SyncableIntArray(new int[]{0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF});
        this.paintedBlock = new SyncableBlock();
        this.paintedBlockMeta = new SyncableInt(0);
    }

    public SyncableBlockLayers getLayersForSide(int side) {
        return this.allSides[side];
    }

    public SyncableBlockLayers.Layer getLayerForSide(int renderSide, int layerId) {
        SyncableBlockLayers layers = this.getLayersForSide(renderSide);
        return layers != null ? layers.getLayer(layerId) : null;
    }

    public int getColorForRender(int renderSide, int layerId) {
        if (layerId == -1) {
            return this.baseColors.getValue(renderSide);
        }
        SyncableBlockLayers.Layer layer = this.getLayerForSide(renderSide, layerId);
        return layer != null ? layer.getColorForRender() : 0xCCCCCC;
    }

    public IIcon getTextureForRender(int renderSide, int layerId) {
        Stencil stencil;
        SyncableBlockLayers.Layer layer;
        if (layerId > -1 && (layer = this.getLayerForSide(renderSide, layerId)) != null && (stencil = layer.getStencil()) != null) {
            return layer.hasStencilCover() ? stencil.getCoverBlockIcon() : stencil.getBlockIcon();
        }
        return this.getBaseTexture(renderSide);
    }

    private IIcon getBaseTexture(int side) {
        Block block = this.paintedBlock.getValue();
        if (block == Blocks.field_150350_a) {
            return OpenBlocks.Blocks.canvas.baseIcon;
        }
        return block.func_149691_a(side, this.paintedBlockMeta.get());
    }

    public boolean canUpdate() {
        return false;
    }

    private boolean isBlockUnpainted() {
        for (int i = 0; i < this.allSides.length; ++i) {
            if (this.allSides[i].isEmpty() && this.baseColors.getValue(i) == 0xFFFFFF) continue;
            return false;
        }
        return true;
    }

    public boolean applyPaint(int color, ForgeDirection ... sides) {
        boolean hasChanged = false;
        for (ForgeDirection side : sides) {
            int sideId = side.ordinal();
            SyncableBlockLayers layers = this.getLayersForSide(sideId);
            if (layers.isLastLayerStencil()) {
                layers.setLastLayerColor(color);
                layers.moveStencilToNextLayer();
            } else {
                layers.clear();
                this.baseColors.setValue(sideId, color);
            }
            hasChanged |= layers.isDirty();
        }
        hasChanged |= this.baseColors.isDirty();
        if (!this.field_145850_b.field_72995_K) {
            this.sync();
        }
        return hasChanged;
    }

    private void dropStackFromSide(ItemStack stack, int side) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ForgeDirection dropSide = ForgeDirection.getOrientation((int)side);
        double dropX = this.field_145851_c + dropSide.offsetX;
        double dropY = this.field_145848_d + dropSide.offsetY;
        double dropZ = this.field_145849_e + dropSide.offsetZ;
        BlockUtils.dropItemStackInWorld((World)this.field_145850_b, (double)dropX, (double)dropY, (double)dropZ, (ItemStack)stack);
    }

    public void removePaint(int ... sides) {
        for (int side : sides) {
            SyncableBlockLayers layer = this.getLayersForSide(side);
            if (layer.isLastLayerStencil()) {
                Stencil stencil = layer.getTopStencil();
                ItemStack dropStack = new ItemStack((Item)OpenBlocks.Items.stencil, 1, stencil.ordinal());
                this.dropStackFromSide(dropStack, side);
            }
            layer.clear();
            this.baseColors.setValue(side, 0xFFFFFF);
        }
        if (this.isBlockUnpainted() && this.paintedBlock.containsValidBlock()) {
            Block block = this.paintedBlock.getValue();
            this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, block, this.paintedBlockMeta.get(), 2);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.sync();
        }
    }

    public boolean useStencil(int side, Stencil stencil) {
        SyncableBlockLayers layer = this.getLayersForSide(side);
        if (layer.isLastLayerStencil()) {
            Stencil topStencil = layer.getTopStencil();
            if (topStencil == stencil) {
                return false;
            }
            ItemStack dropStack = new ItemStack((Item)OpenBlocks.Items.stencil, 1, topStencil.ordinal());
            this.dropStackFromSide(dropStack, side);
            layer.setLastLayerStencil(stencil);
        } else {
            layer.pushNewStencil(stencil);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.sync();
        }
        return true;
    }

    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        Item heldItem;
        ItemStack held = player.func_70694_bm();
        if (held != null && ((heldItem = held.func_77973_b()) instanceof ItemSqueegee || heldItem instanceof ItemPaintBrush || heldItem instanceof ItemStencil)) {
            return false;
        }
        SyncableBlockLayers layer = this.getLayersForSide(side);
        if (layer.isLastLayerStencil()) {
            if (player.func_70093_af()) {
                if (!this.field_145850_b.field_72995_K) {
                    ItemStack dropStack = new ItemStack((Item)OpenBlocks.Items.stencil, 1, layer.getTopStencil().ordinal());
                    this.dropStackFromSide(dropStack, side);
                }
                layer.removeCover();
            } else {
                this.getLayersForSide(side).rotateCover();
            }
            if (!this.field_145850_b.field_72995_K) {
                this.sync();
            }
            return true;
        }
        return false;
    }

    public void addDrops(List<ItemStack> drops) {
        for (SyncableBlockLayers sideLayers : this.allSides) {
            Stencil stencil;
            if (!sideLayers.isLastLayerStencil() || (stencil = sideLayers.getTopStencil()) == null) continue;
            drops.add(new ItemStack((Item)OpenBlocks.Items.stencil, 1, stencil.ordinal()));
        }
    }

    public boolean suppressNormalHarvestDrops() {
        return this.paintedBlock.containsValidBlock();
    }

    public void addHarvestDrops(EntityPlayer player, List<ItemStack> drops) {
        if (this.paintedBlock.containsValidBlock()) {
            Block paintedBlock = this.paintedBlock.getValue();
            int paintedBlockMeta = this.paintedBlockMeta.get();
            Random rand = this.field_145850_b.field_73012_v;
            int fortune = player != null ? EnchantmentHelper.func_77517_e((EntityLivingBase)player) : 0;
            int count = paintedBlock.quantityDropped(paintedBlockMeta, fortune, rand);
            int damageDropped = paintedBlock.func_149692_a(paintedBlockMeta);
            for (int i = 0; i < count; ++i) {
                Item item = paintedBlock.func_149650_a(paintedBlockMeta, rand, fortune);
                if (item == null) continue;
                drops.add(new ItemStack(item, 1, damageDropped));
            }
        }
    }

    public void setPaintedBlockBlock(Block block, int meta) {
        this.paintedBlock.setValue(block);
        this.paintedBlockMeta.set(meta);
    }
}

