/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.newshader;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.coderbot.iris.block_rendering.BlockMaterialMapping;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.coderbot.iris.gbuffer_overrides.matching.InputAvailability;
import net.coderbot.iris.gbuffer_overrides.matching.SpecialCondition;
import net.coderbot.iris.gbuffer_overrides.state.RenderTargetStateListener;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.program.ProgramImages;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.texture.DepthBufferFormat;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.mixin.LevelRendererAccessor;
import net.coderbot.iris.pipeline.ClearPass;
import net.coderbot.iris.pipeline.ClearPassCreator;
import net.coderbot.iris.pipeline.CustomTextureManager;
import net.coderbot.iris.pipeline.HorizonRenderer;
import net.coderbot.iris.pipeline.ShadowRenderer;
import net.coderbot.iris.pipeline.SodiumTerrainPipeline;
import net.coderbot.iris.pipeline.WorldRenderingPhase;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.CoreWorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.ExtendedShader;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.pipeline.newshader.NewShaderTests;
import net.coderbot.iris.pipeline.newshader.ShaderKey;
import net.coderbot.iris.pipeline.newshader.ShaderMap;
import net.coderbot.iris.pipeline.newshader.fallback.FallbackShader;
import net.coderbot.iris.postprocess.BufferFlipper;
import net.coderbot.iris.postprocess.CenterDepthSampler;
import net.coderbot.iris.postprocess.CompositeRenderer;
import net.coderbot.iris.postprocess.FinalPassRenderer;
import net.coderbot.iris.rendertarget.Blaze3dRenderTargetExt;
import net.coderbot.iris.rendertarget.NativeImageBackedSingleColorTexture;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.samplers.IrisImages;
import net.coderbot.iris.samplers.IrisSamplers;
import net.coderbot.iris.shaderpack.PackShadowDirectives;
import net.coderbot.iris.shaderpack.ProgramFallbackResolver;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.coderbot.iris.shadows.ShadowRenderTargets;
import net.coderbot.iris.texture.TextureInfoCache;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.vendored.joml.Vector3d;
import net.coderbot.iris.vendored.joml.Vector4f;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.Nullable;

public class NewWorldRenderingPipeline
implements WorldRenderingPipeline,
CoreWorldRenderingPipeline,
RenderTargetStateListener {
    private final RenderTargets renderTargets;
    private final ShaderMap shaderMap;
    private ShadowRenderTargets shadowRenderTargets;
    private final Supplier<ShadowRenderTargets> shadowTargetsSupplier;
    private WorldRenderingPhase overridePhase = null;
    private WorldRenderingPhase phase = WorldRenderingPhase.NONE;
    private final Set<ShaderInstance> loadedShaders;
    private final ImmutableList<ClearPass> clearPassesFull;
    private final ImmutableList<ClearPass> clearPasses;
    private final GlFramebuffer baseline;
    private final CompositeRenderer prepareRenderer;
    private final CompositeRenderer deferredRenderer;
    private final CompositeRenderer compositeRenderer;
    private final FinalPassRenderer finalPassRenderer;
    private final CustomTextureManager customTextureManager;
    private final AbstractTexture whitePixel;
    private final FrameUpdateNotifier updateNotifier;
    private final CenterDepthSampler centerDepthSampler;
    private final SodiumTerrainPipeline sodiumTerrainPipeline;
    private final ImmutableSet<Integer> flippedBeforeShadow;
    private final ImmutableSet<Integer> flippedAfterPrepare;
    private final ImmutableSet<Integer> flippedAfterTranslucent;
    public boolean isBeforeTranslucent;
    private final HorizonRenderer horizonRenderer = new HorizonRenderer();
    private final float sunPathRotation;
    private final boolean shouldRenderClouds;
    private final boolean shouldRenderUnderwaterOverlay;
    private final boolean shouldRenderVignette;
    private final boolean shouldWriteRainAndSnowToDepthBuffer;
    private final boolean shouldRenderParticlesBeforeDeferred;
    private final boolean oldLighting;
    private final OptionalInt forcedShadowRenderDistanceChunks;
    private boolean destroyed = false;
    private boolean isRenderingWorld;
    private boolean isMainBound;
    @Nullable
    private final ShadowRenderer shadowRenderer;
    private final int shadowMapResolution;

    public NewWorldRenderingPipeline(ProgramSet programSet) throws IOException {
        if (!FMLLoader.isProduction()) {
            Path debugOutDir = FMLPaths.GAMEDIR.get().resolve("patched_shaders");
            if (Files.exists(debugOutDir, new LinkOption[0])) {
                Files.list(debugOutDir).forEach(path -> {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            Files.createDirectories(debugOutDir, new FileAttribute[0]);
        }
        this.shouldRenderClouds = programSet.getPackDirectives().areCloudsEnabled();
        this.shouldRenderUnderwaterOverlay = programSet.getPackDirectives().underwaterOverlay();
        this.shouldRenderVignette = programSet.getPackDirectives().vignette();
        this.shouldWriteRainAndSnowToDepthBuffer = programSet.getPackDirectives().rainDepth();
        this.shouldRenderParticlesBeforeDeferred = programSet.getPackDirectives().areParticlesBeforeDeferred();
        this.oldLighting = programSet.getPackDirectives().isOldLighting();
        this.updateNotifier = new FrameUpdateNotifier();
        RenderTarget main = Minecraft.m_91087_().m_91385_();
        int depthTextureId = main.m_83980_();
        int internalFormat = TextureInfoCache.INSTANCE.getInfo(depthTextureId).getInternalFormat();
        DepthBufferFormat depthBufferFormat = DepthBufferFormat.fromGlEnumOrDefault(internalFormat);
        this.renderTargets = new RenderTargets(main.f_83915_, main.f_83916_, depthTextureId, ((Blaze3dRenderTargetExt)main).iris$getDepthBufferVersion(), depthBufferFormat, programSet.getPackDirectives().getRenderTargetDirectives().getRenderTargetSettings());
        this.sunPathRotation = programSet.getPackDirectives().getSunPathRotation();
        PackShadowDirectives shadowDirectives = programSet.getPackDirectives().getShadowDirectives();
        this.forcedShadowRenderDistanceChunks = shadowDirectives.isDistanceRenderMulExplicit() ? ((double)shadowDirectives.getDistanceRenderMul() >= 0.0 ? OptionalInt.of(((int)(shadowDirectives.getDistance() * shadowDirectives.getDistanceRenderMul()) + 15) / 16) : OptionalInt.of(-1)) : OptionalInt.empty();
        GlStateManager.m_84538_((int)33986);
        this.customTextureManager = new CustomTextureManager(programSet.getPackDirectives(), programSet.getPack().getCustomTextureDataMap(), programSet.getPack().getCustomNoiseTexture());
        this.whitePixel = new NativeImageBackedSingleColorTexture(255, 255, 255, 255);
        GlStateManager.m_84538_((int)33984);
        this.flippedBeforeShadow = ImmutableSet.of();
        BufferFlipper flipper = new BufferFlipper();
        this.centerDepthSampler = new CenterDepthSampler(programSet.getPackDirectives().getCenterDepthHalfLife());
        this.shadowMapResolution = programSet.getPackDirectives().getShadowDirectives().getResolution();
        this.shadowTargetsSupplier = () -> {
            if (this.shadowRenderTargets == null) {
                this.shadowRenderTargets = new ShadowRenderTargets(this.shadowMapResolution, new InternalTextureFormat[]{InternalTextureFormat.RGBA, InternalTextureFormat.RGBA});
            }
            return this.shadowRenderTargets;
        };
        this.prepareRenderer = new CompositeRenderer(programSet.getPackDirectives(), programSet.getPrepare(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, flipper, this.shadowTargetsSupplier, this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.PREPARE, (Object2ObjectMap<String, IntSupplier>)Object2ObjectMaps.emptyMap()), programSet.getPackDirectives().getExplicitFlips("prepare_pre"));
        this.flippedAfterPrepare = flipper.snapshot();
        this.deferredRenderer = new CompositeRenderer(programSet.getPackDirectives(), programSet.getDeferred(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, flipper, this.shadowTargetsSupplier, this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.DEFERRED, (Object2ObjectMap<String, IntSupplier>)Object2ObjectMaps.emptyMap()), programSet.getPackDirectives().getExplicitFlips("deferred_pre"));
        this.flippedAfterTranslucent = flipper.snapshot();
        this.compositeRenderer = new CompositeRenderer(programSet.getPackDirectives(), programSet.getComposite(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, flipper, this.shadowTargetsSupplier, this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.COMPOSITE_AND_FINAL, (Object2ObjectMap<String, IntSupplier>)Object2ObjectMaps.emptyMap()), programSet.getPackDirectives().getExplicitFlips("composite_pre"));
        this.finalPassRenderer = new FinalPassRenderer(programSet, this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, flipper.snapshot(), this.centerDepthSampler, this.shadowTargetsSupplier, this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.COMPOSITE_AND_FINAL, (Object2ObjectMap<String, IntSupplier>)Object2ObjectMaps.emptyMap()), this.compositeRenderer.getFlippedAtLeastOnceFinal());
        Supplier<ImmutableSet> flipped = () -> this.isBeforeTranslucent ? this.flippedAfterPrepare : this.flippedAfterTranslucent;
        IntFunction<ProgramSamplers> createTerrainSamplers = programId -> {
            ProgramSamplers.Builder builder = ProgramSamplers.builder(programId, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.GBUFFERS_AND_SHADOW, (Object2ObjectMap<String, IntSupplier>)Object2ObjectMaps.emptyMap()));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, flipped, this.renderTargets, false);
            IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, (AbstractTexture)this.customTextureManager.getNormals(), (AbstractTexture)this.customTextureManager.getSpecular(), this.whitePixel, new InputAvailability(true, true, false));
            IrisSamplers.addWorldDepthSamplers(customTextureSamplerInterceptor, this.renderTargets);
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, Objects.requireNonNull(this.shadowRenderTargets));
            }
            return builder.build();
        };
        IntFunction<ProgramImages> createTerrainImages = programId -> {
            ProgramImages.Builder builder = ProgramImages.builder(programId);
            IrisImages.addRenderTargetImages(builder, flipped, this.renderTargets);
            if (IrisImages.hasShadowImages(builder)) {
                IrisImages.addShadowColorImages(builder, Objects.requireNonNull(this.shadowRenderTargets));
            }
            return builder.build();
        };
        IntFunction<ProgramSamplers> createShadowTerrainSamplers = programId -> {
            ProgramSamplers.Builder builder = ProgramSamplers.builder(programId, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.GBUFFERS_AND_SHADOW, (Object2ObjectMap<String, IntSupplier>)Object2ObjectMaps.emptyMap()));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, () -> this.flippedBeforeShadow, this.renderTargets, false);
            IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, (AbstractTexture)this.customTextureManager.getNormals(), (AbstractTexture)this.customTextureManager.getSpecular(), this.whitePixel, new InputAvailability(true, true, false));
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, Objects.requireNonNull(this.shadowRenderTargets));
            }
            return builder.build();
        };
        IntFunction<ProgramImages> createShadowTerrainImages = programId -> {
            ProgramImages.Builder builder = ProgramImages.builder(programId);
            IrisImages.addRenderTargetImages(builder, () -> this.flippedBeforeShadow, this.renderTargets);
            if (IrisImages.hasShadowImages(builder)) {
                IrisImages.addShadowColorImages(builder, Objects.requireNonNull(this.shadowRenderTargets));
            }
            return builder.build();
        };
        this.baseline = this.renderTargets.createFramebufferWritingToMain(new int[]{0});
        this.loadedShaders = new HashSet<ShaderInstance>();
        ProgramFallbackResolver resolver = new ProgramFallbackResolver(programSet);
        this.shaderMap = new ShaderMap(key -> {
            try {
                if (key.isShadow()) {
                    if (this.shadowRenderTargets != null) {
                        return this.createShadowShader(key.getName(), resolver.resolve(key.getProgram()), (ShaderKey)((Object)key));
                    }
                    return null;
                }
                return this.createShader(key.getName(), resolver.resolve(key.getProgram()), (ShaderKey)((Object)key));
            }
            catch (IOException e) {
                this.destroyShaders();
                throw new RuntimeException(e);
            }
            catch (RuntimeException e) {
                this.destroyShaders();
                throw e;
            }
        });
        BlockRenderingSettings.INSTANCE.setBlockStateIds(BlockMaterialMapping.createBlockStateIdMap(programSet.getPack().getIdMap().getBlockProperties()));
        BlockRenderingSettings.INSTANCE.setBlockTypeIds(BlockMaterialMapping.createBlockTypeMap(programSet.getPack().getIdMap().getBlockRenderTypeMap()));
        BlockRenderingSettings.INSTANCE.setEntityIds(programSet.getPack().getIdMap().getEntityIdMap());
        BlockRenderingSettings.INSTANCE.setAmbientOcclusionLevel(programSet.getPackDirectives().getAmbientOcclusionLevel());
        BlockRenderingSettings.INSTANCE.setDisableDirectionalShading(this.shouldDisableDirectionalShading());
        BlockRenderingSettings.INSTANCE.setUseSeparateAo(programSet.getPackDirectives().shouldUseSeparateAo());
        BlockRenderingSettings.INSTANCE.setUseExtendedVertexFormat(true);
        this.clearPassesFull = ClearPassCreator.createClearPasses(this.renderTargets, true, programSet.getPackDirectives().getRenderTargetDirectives());
        this.clearPasses = ClearPassCreator.createClearPasses(this.renderTargets, false, programSet.getPackDirectives().getRenderTargetDirectives());
        if (this.shadowRenderTargets != null) {
            ShaderInstance shader = this.shaderMap.getShader(ShaderKey.SHADOW_TERRAIN_CUTOUT);
            boolean shadowUsesImages = false;
            if (shader instanceof ExtendedShader) {
                ExtendedShader holder = (ExtendedShader)shader;
                shadowUsesImages = IrisImages.hasShadowImages(holder) || IrisImages.hasRenderTargetImages(holder, this.renderTargets);
            }
            this.shadowRenderer = new ShadowRenderer(programSet.getShadow().orElse(null), programSet.getPackDirectives(), this.shadowRenderTargets, shadowUsesImages);
        } else {
            this.shadowRenderer = null;
        }
        this.sodiumTerrainPipeline = new SodiumTerrainPipeline(this, programSet, createTerrainSamplers, this.shadowRenderTargets == null ? null : createShadowTerrainSamplers, createTerrainImages, createShadowTerrainImages, this.renderTargets, this.flippedAfterPrepare, this.flippedAfterTranslucent, this.shadowRenderTargets != null ? this.shadowRenderTargets.getFramebuffer() : null);
    }

    @SafeVarargs
    private static <T> Optional<T> first(Optional<T> ... candidates) {
        for (Optional<T> candidate : candidates) {
            if (!candidate.isPresent()) continue;
            return candidate;
        }
        return Optional.empty();
    }

    private ShaderInstance createShader(String name, Optional<ProgramSource> source, ShaderKey key) throws IOException {
        if (!source.isPresent()) {
            return this.createFallbackShader(name, key);
        }
        return this.createShader(name, source.get(), key.getAlphaTest(), key.getVertexFormat(), key.getFogMode(), key.shouldIgnoreLightmap());
    }

    private ShaderInstance createShader(String name, ProgramSource source, AlphaTest fallbackAlpha, VertexFormat vertexFormat, FogMode fogMode, boolean isFullbright) throws IOException {
        GlFramebuffer beforeTranslucent = this.renderTargets.createGbufferFramebuffer(this.flippedAfterPrepare, source.getDirectives().getDrawBuffers());
        GlFramebuffer afterTranslucent = this.renderTargets.createGbufferFramebuffer(this.flippedAfterTranslucent, source.getDirectives().getDrawBuffers());
        ExtendedShader extendedShader = NewShaderTests.create(name, source, beforeTranslucent, afterTranslucent, this.baseline, fallbackAlpha, vertexFormat, this.updateNotifier, this, fogMode, isFullbright);
        this.loadedShaders.add(extendedShader);
        Supplier<ImmutableSet<Integer>> flipped = () -> this.isBeforeTranslucent ? this.flippedAfterPrepare : this.flippedAfterTranslucent;
        this.addGbufferOrShadowSamplers(extendedShader, flipped, false);
        return extendedShader;
    }

    private ShaderInstance createFallbackShader(String name, ShaderKey key) throws IOException {
        GlFramebuffer beforeTranslucent = this.renderTargets.createGbufferFramebuffer(this.flippedAfterPrepare, new int[]{0});
        GlFramebuffer afterTranslucent = this.renderTargets.createGbufferFramebuffer(this.flippedAfterTranslucent, new int[]{0});
        FallbackShader shader = NewShaderTests.createFallback(name, beforeTranslucent, afterTranslucent, key.getAlphaTest(), key.getVertexFormat(), null, this, key.getFogMode(), key.hasDiffuseLighting(), key.isIntensity(), key.shouldIgnoreLightmap());
        this.loadedShaders.add(shader);
        return shader;
    }

    private ShaderInstance createShadowShader(String name, Optional<ProgramSource> source, ShaderKey key) throws IOException {
        if (!source.isPresent()) {
            return this.createFallbackShadowShader(name, key);
        }
        return this.createShadowShader(name, source.get(), key.getAlphaTest(), key.getVertexFormat(), key.shouldIgnoreLightmap());
    }

    private ShaderInstance createFallbackShadowShader(String name, ShaderKey key) throws IOException {
        GlFramebuffer framebuffer = this.shadowRenderTargets.getFramebuffer();
        FallbackShader shader = NewShaderTests.createFallback(name, framebuffer, framebuffer, key.getAlphaTest(), key.getVertexFormat(), BlendModeOverride.OFF, this, key.getFogMode(), key.hasDiffuseLighting(), key.isIntensity(), key.shouldIgnoreLightmap());
        this.loadedShaders.add(shader);
        return shader;
    }

    private ShaderInstance createShadowShader(String name, ProgramSource source, AlphaTest fallbackAlpha, VertexFormat vertexFormat, boolean isFullbright) throws IOException {
        GlFramebuffer framebuffer = this.shadowRenderTargets.getFramebuffer();
        ExtendedShader extendedShader = NewShaderTests.create(name, source, framebuffer, framebuffer, this.baseline, fallbackAlpha, vertexFormat, this.updateNotifier, this, FogMode.PER_VERTEX, isFullbright);
        this.loadedShaders.add(extendedShader);
        Supplier<ImmutableSet<Integer>> flipped = () -> this.flippedBeforeShadow;
        this.addGbufferOrShadowSamplers(extendedShader, flipped, true);
        return extendedShader;
    }

    private void addGbufferOrShadowSamplers(ExtendedShader extendedShader, Supplier<ImmutableSet<Integer>> flipped, boolean isShadowPass) {
        TextureStage textureStage = TextureStage.GBUFFERS_AND_SHADOW;
        ProgramSamplers.CustomTextureSamplerInterceptor samplerHolder = ProgramSamplers.customTextureSamplerInterceptor(extendedShader, this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)textureStage, (Object2ObjectMap<String, IntSupplier>)Object2ObjectMaps.emptyMap()));
        IrisSamplers.addRenderTargetSamplers(samplerHolder, flipped, this.renderTargets, false);
        IrisImages.addRenderTargetImages(extendedShader, flipped, this.renderTargets);
        samplerHolder.addDynamicSampler(() -> ((NativeImageBackedSingleColorTexture)this.customTextureManager.getNormals()).m_117963_(), "normals");
        samplerHolder.addDynamicSampler(() -> ((NativeImageBackedSingleColorTexture)this.customTextureManager.getSpecular()).m_117963_(), "specular");
        IrisSamplers.addWorldDepthSamplers(samplerHolder, this.renderTargets);
        IrisSamplers.addNoiseSampler(samplerHolder, this.customTextureManager.getNoiseTexture());
        if (isShadowPass || IrisSamplers.hasShadowSamplers(samplerHolder)) {
            if (!isShadowPass) {
                this.shadowTargetsSupplier.get();
            }
            IrisSamplers.addShadowSamplers(samplerHolder, Objects.requireNonNull(this.shadowRenderTargets));
        }
        if (isShadowPass || IrisImages.hasShadowImages(extendedShader)) {
            IrisImages.addShadowColorImages(extendedShader, Objects.requireNonNull(this.shadowRenderTargets));
        }
    }

    @Override
    public WorldRenderingPhase getPhase() {
        if (this.overridePhase != null) {
            return this.overridePhase;
        }
        return this.phase;
    }

    @Override
    public void beginSodiumTerrainRendering() {
    }

    @Override
    public void endSodiumTerrainRendering() {
    }

    @Override
    public void setOverridePhase(WorldRenderingPhase phase) {
        this.overridePhase = phase;
    }

    @Override
    public void setPhase(WorldRenderingPhase phase) {
        this.phase = phase;
    }

    @Override
    public void setSpecialCondition(SpecialCondition special) {
    }

    @Override
    public RenderTargetStateListener getRenderTargetStateListener() {
        return this;
    }

    @Override
    public void beginLevelRendering() {
        ImmutableList<ClearPass> passes;
        this.isRenderingWorld = true;
        RenderSystem.m_69388_((int)33984);
        if (this.shadowRenderTargets != null) {
            this.shadowRenderTargets.getFramebuffer().bind();
            RenderSystem.m_69424_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69430_((double)1.0);
            RenderSystem.m_69421_((int)16640, (boolean)false);
        }
        this.updateNotifier.onNewFrame();
        RenderTarget main = Minecraft.m_91087_().m_91385_();
        int depthTextureId = main.m_83980_();
        int internalFormat = TextureInfoCache.INSTANCE.getInfo(depthTextureId).getInternalFormat();
        DepthBufferFormat depthBufferFormat = DepthBufferFormat.fromGlEnumOrDefault(internalFormat);
        this.renderTargets.resizeIfNeeded(((Blaze3dRenderTargetExt)main).iris$getDepthBufferVersion(), depthTextureId, main.f_83915_, main.f_83916_, depthBufferFormat);
        if (this.renderTargets.isFullClearRequired()) {
            this.renderTargets.onFullClear();
            passes = this.clearPassesFull;
        } else {
            passes = this.clearPasses;
        }
        Vector3d fogColor3 = CapturedRenderingState.INSTANCE.getFogColor();
        Vector4f fogColor = new Vector4f((float)fogColor3.x, (float)fogColor3.y, (float)fogColor3.z, 1.0f);
        for (ClearPass clearPass : passes) {
            clearPass.execute(fogColor);
        }
        main.m_83947_(true);
        this.isMainBound = true;
        this.isBeforeTranslucent = true;
        this.setPhase(WorldRenderingPhase.SKY);
        DimensionSpecialEffects.SkyType skyType = Minecraft.m_91087_().f_91073_.m_104583_().m_108883_();
        if (skyType == DimensionSpecialEffects.SkyType.NORMAL) {
            RenderSystem.m_69472_();
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_157429_((float)fogColor.x, (float)fogColor.y, (float)fogColor.z, (float)fogColor.w);
            this.horizonRenderer.renderHorizon(CapturedRenderingState.INSTANCE.getGbufferModelView(), CapturedRenderingState.INSTANCE.getGbufferProjection(), GameRenderer.m_172808_());
            RenderSystem.m_69458_((boolean)true);
            RenderSystem.m_69493_();
        }
    }

    @Override
    public void renderShadows(LevelRendererAccessor worldRenderer, Camera playerCamera) {
        if (this.shadowRenderer != null) {
            this.shadowRenderer.renderShadows(worldRenderer, playerCamera);
        }
        this.prepareRenderer.renderAll();
    }

    @Override
    public void addDebugText(List<String> messages) {
        if (this.shadowRenderer != null) {
            messages.add("");
            this.shadowRenderer.addDebugText(messages);
        } else {
            messages.add("");
            messages.add("[Iris] Shadow Maps: not used by shader pack");
        }
    }

    @Override
    public OptionalInt getForcedShadowRenderDistanceChunksForDisplay() {
        return this.forcedShadowRenderDistanceChunks;
    }

    @Override
    public void beginHand() {
        this.renderTargets.copyPreHandDepth();
    }

    @Override
    public void beginTranslucents() {
        if (this.destroyed) {
            throw new IllegalStateException("Tried to use a destroyed world rendering pipeline");
        }
        this.isBeforeTranslucent = false;
        this.renderTargets.copyPreTranslucentDepth();
        this.deferredRenderer.renderAll();
        RenderSystem.m_69478_();
        RenderSystem.m_157427_(GameRenderer::m_172808_);
    }

    @Override
    public void finalizeLevelRendering() {
        this.isRenderingWorld = false;
        this.centerDepthSampler.sampleCenterDepth();
        this.compositeRenderer.renderAll();
        this.finalPassRenderer.renderFinalPass();
    }

    @Override
    public boolean shouldDisableVanillaEntityShadows() {
        return this.shadowRenderer != null;
    }

    @Override
    public boolean shouldRenderClouds() {
        return this.shouldRenderClouds;
    }

    @Override
    public boolean shouldRenderUnderwaterOverlay() {
        return this.shouldRenderUnderwaterOverlay;
    }

    @Override
    public boolean shouldRenderVignette() {
        return this.shouldRenderVignette;
    }

    @Override
    public boolean shouldWriteRainAndSnowToDepthBuffer() {
        return this.shouldWriteRainAndSnowToDepthBuffer;
    }

    @Override
    public boolean shouldRenderParticlesBeforeDeferred() {
        return this.shouldRenderParticlesBeforeDeferred;
    }

    @Override
    public boolean shouldDisableDirectionalShading() {
        return !this.oldLighting;
    }

    @Override
    public ShaderMap getShaderMap() {
        return this.shaderMap;
    }

    private void destroyShaders() {
        this.loadedShaders.forEach(shader -> {
            shader.m_173362_();
            shader.close();
        });
    }

    @Override
    public void destroy() {
        int i;
        this.destroyed = true;
        this.destroyShaders();
        for (i = 0; i < 16; ++i) {
            GlStateManager.m_84514_((int)(33984 + i));
            GlStateManager.m_84544_((int)0);
        }
        GlStateManager.m_84514_((int)33984);
        for (i = 0; i < 12; ++i) {
            RenderSystem.m_157453_((int)i, (int)0);
        }
        this.compositeRenderer.destroy();
        this.customTextureManager.destroy();
        this.whitePixel.m_117964_();
        GlStateManager.m_84486_((int)36008, (int)0);
        GlStateManager.m_84486_((int)36009, (int)0);
        GlStateManager.m_84486_((int)36160, (int)0);
        Minecraft.m_91087_().m_91385_().m_83947_(false);
        this.renderTargets.destroy();
    }

    @Override
    public boolean shouldOverrideShaders() {
        return this.isRenderingWorld && this.isMainBound;
    }

    @Override
    public SodiumTerrainPipeline getSodiumTerrainPipeline() {
        return this.sodiumTerrainPipeline;
    }

    @Override
    public FrameUpdateNotifier getFrameUpdateNotifier() {
        return this.updateNotifier;
    }

    @Override
    public float getSunPathRotation() {
        return this.sunPathRotation;
    }

    protected AbstractTexture getWhitePixel() {
        return this.whitePixel;
    }

    @Override
    public void beginPostChain() {
    }

    @Override
    public void endPostChain() {
    }

    @Override
    public void setIsMainBound(boolean bound) {
        this.isMainBound = bound;
    }
}

