/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.render;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.numina.item.IModeChangingItem;
import net.machinemuse.numina.render.MuseIconUtils;
import net.machinemuse.numina.render.MuseTextureUtils;
import net.machinemuse.numina.render.RenderState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.ForgeHooks;

public class RenderGameOverlayEventHandler {
    public static int SWAPTIME = 200;
    public static long lastSwapTime = 0L;
    private static int lastSwapDirection = 0;

    @SubscribeEvent
    public void onPreRenderGameOverlayEvent(RenderGameOverlayEvent.Pre e) {
    }

    @SubscribeEvent
    public void onPostRenderGameOverlayEvent(RenderGameOverlayEvent.Post e) {
        switch (e.type) {
            case HOTBAR: {
                this.drawModeChangeIcons();
                break;
            }
        }
    }

    public void drawModeChangeIcons() {
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        int i = player.field_71071_by.field_70461_c;
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (stack != null && stack.func_77973_b() instanceof IModeChangingItem) {
            IModeChangingItem item = (IModeChangingItem)stack.func_77973_b();
            ScaledResolution screen = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
            MuseTextureUtils.pushTexture("textures/atlas/items.png");
            RenderState.blendingOn();
            long swapTime = Math.min(System.currentTimeMillis() - lastSwapTime, (long)SWAPTIME);
            IIcon currentMode = item.getModeIcon(item.getActiveMode(stack, (EntityPlayer)player), stack, (EntityPlayer)player);
            IIcon nextMode = item.getModeIcon(item.nextMode(stack, (EntityPlayer)player), stack, (EntityPlayer)player);
            IIcon prevMode = item.getModeIcon(item.prevMode(stack, (EntityPlayer)player), stack, (EntityPlayer)player);
            double prevX = 0.0;
            double prevY = 0.0;
            double currX = 0.0;
            double currY = 0.0;
            double nextX = 0.0;
            double nextY = 0.0;
            int sw = screen.func_78326_a();
            int sh = screen.func_78328_b();
            int baroffset = 22;
            if (!player.field_71075_bZ.field_75098_d) {
                baroffset += 16;
                if (ForgeHooks.getTotalArmorValue((EntityPlayer)player) > 0) {
                    baroffset += 8;
                }
            }
            RenderState.scissorsOn(0.0, 0.0, sw, sh - baroffset);
            baroffset = screen.func_78328_b() - baroffset;
            prevX = (double)sw / 2.0 - 105.0 + 20.0 * (double)i;
            prevY = baroffset - 8;
            currX = (double)sw / 2.0 - 89.0 + 20.0 * (double)i;
            currY = baroffset - 18;
            nextX = (double)sw / 2.0 - 73.0 + 20.0 * (double)i;
            nextY = baroffset - 8;
            if (swapTime == (long)SWAPTIME || lastSwapDirection == 0) {
                this.drawIcon(prevX, prevY, prevMode, 0.4);
                this.drawIcon(currX, currY, currentMode, 0.8);
                this.drawIcon(nextX, nextY, nextMode, 0.4);
            } else {
                double r1 = 1L - swapTime / (long)SWAPTIME;
                double r2 = swapTime / (long)SWAPTIME;
                if (lastSwapDirection == -1) {
                    nextX = currX * r1 + nextX * r2;
                    nextY = currY * r1 + nextY * r2;
                    currX = prevX * r1 + currX * r2;
                    currY = prevY * r1 + currY * r2;
                    this.drawIcon(currX, currY, currentMode, 0.8);
                    this.drawIcon(nextX, nextY, nextMode, 0.8);
                } else {
                    prevX = currX * r1 + prevX * r2;
                    prevY = currY * r1 + prevY * r2;
                    currX = nextX * r1 + currX * r2;
                    currY = nextY * r1 + currY * r2;
                    this.drawIcon(prevX, prevY, prevMode, 0.8);
                    this.drawIcon(currX, currY, currentMode, 0.8);
                }
            }
            RenderState.scissorsOff();
            RenderState.blendingOff();
            MuseTextureUtils.popTexture();
            Colour.WHITE.doGL();
        }
    }

    public void drawIcon(double x, double y, IIcon icon, double alpha) {
        if (icon != null) {
            MuseIconUtils.drawIconAt(x, y, icon, Colour.WHITE.withAlpha(alpha));
        }
    }

    public static void updateSwap(int dModeSig) {
        lastSwapTime = System.currentTimeMillis();
        lastSwapDirection = dModeSig;
    }

    static {
        new RenderGameOverlayEventHandler();
    }
}

