/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.NEIServerConfig;
import codechicken.nei.network.NEIServerPacketHandler;
import codechicken.nei.util.NEIServerUtils;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ServerHandler {
    public static final ServerHandler INSTANCE = new ServerHandler();

    @SubscribeEvent
    public void tickEvent(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.world.field_72995_K && NEIServerConfig.dimTags.containsKey(event.world.field_73011_w.getDimension())) {
            this.processDisabledProperties(event.world);
        }
    }

    @SubscribeEvent
    public void loadEvent(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            NEIServerConfig.load(event.getWorld());
        }
    }

    private void processDisabledProperties(World world) {
        NEIServerUtils.advanceDisabledTimes(world);
        if (NEIServerUtils.isRaining(world) && NEIServerConfig.isActionDisabled(world.field_73011_w.getDimension(), "rain")) {
            NEIServerUtils.toggleRaining(world, false);
        }
    }

    @SubscribeEvent
    public void loginEvent(PlayerEvent.PlayerLoggedInEvent event) {
        NEIServerConfig.loadPlayer(event.player);
        NEIServerPacketHandler.sendServerSideCheck((EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public void logoutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        NEIServerConfig.unloadPlayer(event.player);
    }

    @SubscribeEvent
    public void dimChangeEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        NEIServerConfig.getSaveForPlayer(event.player.func_70005_c_()).onWorldReload();
    }

    @SubscribeEvent
    public void loginEvent(PlayerEvent.PlayerRespawnEvent event) {
        NEIServerConfig.getSaveForPlayer(event.player.func_70005_c_()).onWorldReload();
    }
}

