/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.stacktrace;

import fudge.notenoughcrashes.ModConfig;
import fudge.notenoughcrashes.NotEnoughCrashes;
import fudge.notenoughcrashes.platform.CommonModMetadata;
import fudge.notenoughcrashes.platform.NecPlatform;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ModIdentifier {
    private static final Logger LOGGER = LogManager.getLogger();

    public static Set<CommonModMetadata> identifyFromStacktrace(Throwable e) {
        HashSet<CommonModMetadata> mods = new HashSet<CommonModMetadata>();
        ModIdentifier.visitChildrenThrowables(e, throwable -> mods.addAll(ModIdentifier.identifyFromThrowable(throwable)));
        return mods;
    }

    private static void visitChildrenThrowables(Throwable e, Consumer<Throwable> visitor) {
        visitor.accept(e);
        for (Throwable child : e.getSuppressed()) {
            ModIdentifier.visitChildrenThrowables(child, visitor);
        }
    }

    private static Set<CommonModMetadata> identifyFromThrowable(Throwable e) {
        Map<URI, Set<CommonModMetadata>> modMap = NecPlatform.instance().getModsAtLocationsInDisk();
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        while (e != null) {
            for (StackTraceElement element : e.getStackTrace()) {
                classes.add(element.getClassName());
            }
            e = e.getCause();
        }
        LinkedHashSet<CommonModMetadata> mods = new LinkedHashSet<CommonModMetadata>();
        for (String className : classes) {
            Set<CommonModMetadata> classMods = ModIdentifier.identifyFromClass(className, modMap);
            if (classMods == null) continue;
            mods.addAll(classMods);
        }
        return mods;
    }

    private static void debug(String message) {
        if (ModConfig.instance().debugModIdentification) {
            NotEnoughCrashes.LOGGER.info(message);
        }
    }

    private static Set<CommonModMetadata> identifyFromClass(String className, Map<URI, Set<CommonModMetadata>> modMap) {
        ModIdentifier.debug("Analyzing " + className);
        if (className.startsWith("org.spongepowered.asm.mixin.")) {
            ModIdentifier.debug("Ignoring class " + className + " for identification because it is a mixin class");
            return Collections.emptySet();
        }
        try {
            String oldPath;
            Class<?> clazz = Class.forName(className);
            CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
            if (codeSource == null) {
                ModIdentifier.debug("Ignoring class " + className + " for identification because the code source could not be found");
                return Collections.emptySet();
            }
            URL url = codeSource.getLocation();
            if (url == null) {
                LOGGER.warn("Failed to identify mod for " + className);
                return Collections.emptySet();
            }
            URI jar = ModIdentifier.jarFromUrl(url);
            Set<CommonModMetadata> metadata = modMap.get(jar);
            if (metadata == null && jar.toString().startsWith("modjar://")) {
                metadata = new HashSet<CommonModMetadata>(NecPlatform.instance().getModMetadatas(jar.toString().substring("modjar://".length())));
            }
            if (metadata == null && (oldPath = jar.getPath()).length() > "classes/kotlin/main/".length()) {
                String fixedPath = oldPath.substring(0, oldPath.length() - "classes/kotlin/main/".length()) + "resources/main/";
                metadata = modMap.get(new File(fixedPath).toURI());
            }
            return metadata;
        }
        catch (IOException | ClassNotFoundException | NoClassDefFoundError | URISyntaxException e) {
            ModIdentifier.debug("Ignoring class " + className + " for identification because an error occurred");
            if (ModConfig.instance().debugModIdentification) {
                e.printStackTrace();
            }
            return Collections.emptySet();
        }
    }

    public static URI jarFromUrl(URL url) throws URISyntaxException, IOException {
        if (url.getProtocol().equals("jar")) {
            url = new URL(url.getFile().substring(0, url.getFile().indexOf(33)));
        }
        return url.toURI().normalize();
    }
}

