/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.mixins;

import fudge.notenoughcrashes.patches.PatchedCrashReport;
import fudge.notenoughcrashes.platform.CommonModMetadata;
import fudge.notenoughcrashes.stacktrace.ModIdentifier;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CrashReport.class}, priority=500)
public abstract class MixinCrashReport
implements PatchedCrashReport {
    private static final boolean ANNOYING_EASTER_EGG_DISABLED = true;
    @Shadow
    @Final
    private CrashReportCategory field_85061_c;
    @Shadow
    @Final
    private List<CrashReportCategory> field_71512_c;
    @Shadow
    @Final
    private Throwable field_71511_b;
    @Shadow
    @Final
    private String field_71513_a;
    private Set<CommonModMetadata> suspectedMods = null;

    @Shadow
    private static String func_71503_h() {
        return null;
    }

    private static String stacktraceToString(Throwable cause) {
        StringWriter writer = new StringWriter();
        cause.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    @Override
    public Set<CommonModMetadata> getSuspectedMods() {
        return this.suspectedMods;
    }

    @Inject(method={"fillSystemDetails"}, at={@At(value="TAIL")})
    private void afterFillSystemDetails(CallbackInfo ci) {
        this.field_85061_c.func_189529_a("Suspected Mods", () -> {
            try {
                this.suspectedMods = ModIdentifier.identifyFromStacktrace(this.field_71511_b);
                ArrayList<String> modNames = new ArrayList<String>();
                for (CommonModMetadata mod : this.suspectedMods) {
                    modNames.add(mod.getName() + " (" + mod.getId() + ")");
                }
                if (!modNames.isEmpty()) {
                    return StringUtils.join(modNames, (String)", ");
                }
                return "Unknown";
            }
            catch (Throwable e) {
                return ExceptionUtils.getStackTrace((Throwable)e).replace("\t", "    ");
            }
        });
    }

    @Overwrite
    public void func_71506_a(StringBuilder builder) {
        for (CrashReportCategory section : this.field_71512_c) {
            section.func_85072_a(builder);
            builder.append("\n");
        }
        this.field_85061_c.func_85072_a(builder);
    }

    private String generateEasterEggComment() {
        try {
            CommonModMetadata mod;
            String comment = MixinCrashReport.func_71503_h();
            if (comment.contains("Dinnerbone") && !(mod = this.suspectedMods.iterator().next()).getAuthors().isEmpty()) {
                String author = mod.getAuthors().iterator().next();
                comment = comment.replace("Dinnerbone", author);
            }
            return comment;
        }
        catch (Throwable throwable) {
            return MixinCrashReport.func_71503_h();
        }
    }
}

