/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.gui.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import fudge.notenoughcrashes.gui.util.Widget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextWidget
implements Widget {
    private final ITextComponent text;
    private final String translated;
    private final int color;
    private final FontRenderer font;
    private final int x;
    private final int y;
    private final int width;
    private final int height = 8;
    final int startX;
    public static final int DEFAULT_TEXT_COLOR = 0x404040;
    public static final int CLICKABLE_TEXT_COLOR = 0xE0E000;

    private Screen getScreen() {
        return Minecraft.func_71410_x().field_71462_r;
    }

    public TextWidget(ITextComponent text, int color, FontRenderer font, int x, int y) {
        this.text = text;
        this.color = color;
        this.font = font;
        this.x = x;
        this.y = y;
        this.translated = text.getString();
        this.width = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.translated);
        this.startX = x - this.width / 2;
    }

    @Override
    public void draw(MatrixStack stack) {
        this.getScreen();
        Screen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.font, (String)this.translated, (int)this.x, (int)this.y, (int)this.color);
    }

    @Override
    public void onClick(double x, double y) {
        Screen screen;
        ITextComponent hoveredText = this.getTextAt(x, y);
        if (hoveredText != null && (screen = Minecraft.func_71410_x().field_71462_r) != null) {
            screen.func_230455_a_(hoveredText.func_150256_b());
        }
    }

    private boolean isWithinBounds(double mouseX, double mouseY) {
        int endX = this.x + this.width / 2;
        int startY = this.y - 4;
        int endY = this.y + 4;
        return mouseX >= (double)this.startX && mouseX <= (double)endX && mouseY <= (double)endY && mouseY >= (double)startY;
    }

    private ITextComponent getTextAt(double x, double y) {
        if (this.isWithinBounds(x, y)) {
            int i = this.startX;
            FontRenderer renderer = Minecraft.func_71410_x().field_71466_p;
            for (ITextComponent component : this.getTextParts(this.text)) {
                if (!((double)(i += renderer.func_78256_a(component.func_150261_e())) > x)) continue;
                return component;
            }
        }
        return null;
    }

    private List<ITextComponent> getTextParts(ITextComponent text) {
        ArrayList<ITextComponent> parts = new ArrayList<ITextComponent>();
        parts.add(text);
        parts.addAll(text.func_150253_a());
        return parts;
    }
}

