/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import fudge.notenoughcrashes.gui.util.TextWidget;
import fudge.notenoughcrashes.gui.util.Widget;
import fudge.notenoughcrashes.patches.PatchedCrashReport;
import fudge.notenoughcrashes.platform.CommonModMetadata;
import fudge.notenoughcrashes.utils.CrashLogUpload;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.ConfirmOpenLinkScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public abstract class ProblemScreen
extends Screen {
    private List<Widget> widgets = new ArrayList<Widget>();
    private static final Logger LOGGER = LogManager.getLogger();
    protected final CrashReport report;
    private String hasteLink = null;
    protected int xLeft = Integer.MAX_VALUE;
    protected int xRight = Integer.MIN_VALUE;
    protected int yTop = Integer.MAX_VALUE;
    protected int yBottom = Integer.MIN_VALUE;
    protected int x;
    protected int y;
    private static final Set<String> IGNORED_MODS = new HashSet<String>(Arrays.asList("minecraft", "fabricloader", "loadcatcher", "jumploader"));

    protected void addWidget(Widget widget) {
        this.widgets.add(widget);
    }

    public abstract ProblemScreen construct(CrashReport var1);

    protected ProblemScreen(CrashReport report) {
        super((ITextComponent)new StringTextComponent(""));
        this.report = report;
    }

    private ITextComponent getSuspectedModsText() {
        Set<CommonModMetadata> suspectedMods = ((PatchedCrashReport)this.report).getSuspectedMods();
        if (suspectedMods == null) {
            return new TranslationTextComponent("notenoughcrashes.crashscreen.identificationErrored");
        }
        suspectedMods.removeIf(mod -> IGNORED_MODS.contains(mod.getId()));
        if (suspectedMods.isEmpty()) {
            return new TranslationTextComponent("notenoughcrashes.crashscreen.noModsErrored");
        }
        ITextComponent text = (ITextComponent)suspectedMods.stream().sorted(Comparator.comparing(CommonModMetadata::getName)).map(mod -> {
            String issuesPage = mod.getIssuesPage();
            StringTextComponent modText = new StringTextComponent(mod.getName());
            if (issuesPage != null) {
                modText.func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, issuesPage)));
            }
            return modText;
        }).reduce((existing, next) -> existing.func_230529_a_((ITextComponent)new StringTextComponent(", ")).func_230529_a_((ITextComponent)next)).get();
        return text;
    }

    private void addSuspectedModsWidget() {
        this.addWidget(new TextWidget(this.getSuspectedModsText(), 0xE0E000, this.field_230712_o_, this.field_230708_k_ / 2, this.y + 29));
    }

    public void func_231160_c_() {
        this.widgets = new ArrayList<Widget>();
        this.func_230480_a_((net.minecraft.client.gui.widget.Widget)new Button(this.field_230708_k_ / 2 - 155 + 160, this.field_230709_l_ / 4 + 120 + 12, 150, 20, (ITextComponent)new TranslationTextComponent("notenoughcrashes.gui.getLink"), buttonWidget -> {
            try {
                if (this.hasteLink == null) {
                    this.hasteLink = CrashLogUpload.upload(this.report.func_71502_e());
                }
                Minecraft.func_71410_x().func_147108_a((Screen)new ConfirmOpenLinkScreen(b -> {
                    if (b) {
                        Util.func_110647_a().func_195640_a(this.hasteLink);
                    }
                    Minecraft.func_71410_x().func_147108_a((Screen)this.construct(this.report));
                }, this.hasteLink, true));
            }
            catch (Throwable e) {
                LOGGER.error("Exception when crash menu button clicked:", e);
                buttonWidget.func_238482_a_((ITextComponent)new TranslationTextComponent("notenoughcrashes.gui.failed"));
                buttonWidget.field_230693_o_ = false;
            }
        }));
        this.x = this.field_230708_k_ / 2 - 155;
        this.y = this.field_230709_l_ / 4;
        this.addSuspectedModsWidget();
    }

    public boolean func_231044_a_(double x, double y, int int_1) {
        File file;
        for (Widget widget : this.widgets) {
            widget.onClick(x, y);
        }
        if (x >= (double)this.xLeft && x <= (double)this.xRight && y >= (double)this.yTop && y <= (double)this.yBottom && (file = this.report.func_71497_f()) != null) {
            Util.func_110647_a().func_195641_a(file);
        }
        return super.func_231044_a_(x, y, int_1);
    }

    public boolean func_231178_ax__() {
        return false;
    }

    protected void drawFileNameString(MatrixStack matrixStack, int y) {
        String fileNameString = this.report.func_71497_f() != null ? "\u00a7n" + this.report.func_71497_f().getName() : I18n.func_135052_a((String)"notenoughcrashes.crashscreen.reportSaveFailed", (Object[])new Object[0]);
        int stLen = this.field_230712_o_.func_78256_a(fileNameString);
        this.xLeft = this.field_230708_k_ / 2 - stLen / 2;
        this.xRight = this.field_230708_k_ / 2 + stLen / 2;
        ProblemScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)fileNameString, (int)this.xLeft, (int)(y += 11), (int)65280);
        this.yTop = y;
        this.yBottom = y + 10;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseY, int i, float f) {
        for (Widget widget : this.widgets) {
            widget.draw(matrixStack);
        }
        super.func_230430_a_(matrixStack, mouseY, i, f);
    }
}

