/*
 * Decompiled with CFR 0.152.
 */
package lellson.moreShearable.misc;

import java.lang.reflect.InvocationTargetException;
import lellson.moreShearable.ShearableMobs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ShearEntry {
    private Class<? extends EntityLivingBase> clazz;
    private Class<? extends EntityLivingBase> clazzSheared;
    private String name;
    private float pitch;
    private String defaultDropString;
    private boolean dropsItem = true;
    private boolean disable;
    private String dropString;
    private ItemStack dropStack = null;
    private boolean variantMeta = false;

    public ShearEntry(Class<? extends EntityLivingBase> clazz, Class<? extends EntityLivingBase> clazzSheared, String name, float pitch, String defaultDropString) {
        this.clazz = clazz;
        this.clazzSheared = clazzSheared;
        this.name = name;
        this.pitch = pitch;
        this.defaultDropString = defaultDropString;
    }

    public ShearEntry(Class<? extends EntityLivingBase> clazz, Class<? extends EntityLivingBase> clazzSheared, String name, float pitch) {
        this(clazz, clazzSheared, name, pitch, "");
        this.dropsItem = false;
    }

    public Class<? extends EntityLivingBase> getEntityClass() {
        return this.clazz;
    }

    public Class<? extends EntityLivingBase> getShearedEntityClass() {
        return this.clazz;
    }

    public String getName() {
        return this.name;
    }

    public ItemStack getDrop() {
        return this.dropStack;
    }

    public void initConfig() {
        this.disable = ShearableMobs.config.getBoolean(this.name.replace(" ", "") + "Disable", "DISABLE", false, "Set to true, to disable " + this.name + " shearing");
        if (this.dropsItem) {
            this.dropString = ShearableMobs.config.getString(this.name.replace(" ", "") + "Drop", "DROPS", this.defaultDropString, "A " + this.name + " drops this when sheared");
        }
    }

    public boolean initDropStack(boolean useDefault) {
        int maxStacksize;
        String[] split;
        if (!this.dropsItem) {
            return false;
        }
        String[] stringArray = split = useDefault ? this.defaultDropString.split(";") : this.dropString.split(";");
        if (split.length < 2) {
            return this.DropError("Invalid amount of args. At least 2 args are required!");
        }
        Item drop = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(split[0]));
        if (drop == null) {
            return this.DropError(split[0] + " is not a valid item!");
        }
        try {
            maxStacksize = Integer.parseInt(split[1]);
            if (maxStacksize < 1) {
                return this.DropError("Stacksize must be at least 1!");
            }
        }
        catch (NumberFormatException e) {
            return this.DropError(split[1] + " is not a valid number!");
        }
        int meta = 0;
        if (split.length > 2) {
            try {
                if (split[2].toUpperCase().equals("VARIANT")) {
                    this.variantMeta = true;
                } else {
                    meta = Integer.parseInt(split[2]);
                }
            }
            catch (NumberFormatException e) {
                return this.DropError(split[2] + " is not a valid number!");
            }
        }
        this.dropStack = new ItemStack(drop, maxStacksize, meta);
        return true;
    }

    public boolean DropError(String msg) {
        FMLLog.bigWarning((String)("Error on initialising " + this.name + " shear drop: " + msg + " (Line: " + this.dropString + ")"), (Object[])new Object[0]);
        this.initDropStack(true);
        return false;
    }

    public EntityLivingBase createEntity(World world, EntityLivingBase oldEntity, EntityPlayer player) {
        EntityLivingBase newEntity = null;
        try {
            newEntity = (EntityLivingBase)ReflectionHelper.findConstructor(this.clazzSheared, (Class[])new Class[]{World.class}).newInstance(world);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            FMLLog.bigWarning((String)e.getMessage(), (Object[])new Object[0]);
        }
        newEntity.func_70080_a(oldEntity.field_70165_t, oldEntity.field_70163_u, oldEntity.field_70161_v, oldEntity.field_70177_z, oldEntity.field_70125_A);
        newEntity.func_70606_j(oldEntity.func_110143_aJ());
        oldEntity.func_70106_y();
        return newEntity;
    }

    public void shear(World world, ItemStack item, EntityPlayer player, EntityLivingBase oldEntity) {
        EntityLivingBase newEntity = this.createEntity(world, oldEntity, player);
        world.func_72838_d((Entity)newEntity);
        if (this.dropStack != null) {
            int stacksize = 1 + (this.dropStack.func_190916_E() - 1 > 0 ? world.field_73012_v.nextInt(this.dropStack.func_190916_E()) : 0);
            int meta = this.dropStack.func_77960_j();
            if (this.variantMeta && oldEntity instanceof EntityLlama) {
                int variant = ((EntityLlama)oldEntity).func_190719_dM();
                meta = variant == 2 ? 12 : (variant == 3 ? 8 : 0);
            }
            newEntity.func_70099_a(new ItemStack(this.dropStack.func_77973_b(), stacksize, meta), 0.0f);
        }
        item.func_77972_a(1, (EntityLivingBase)player);
        newEntity.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, this.pitch);
    }

    public boolean canShear(EntityLivingBase entity) {
        return !this.disable && !entity.func_70631_g_() && (this.clazzSheared == null || !this.clazzSheared.isInstance(entity));
    }
}

