/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.utils.render;

import java.util.List;
import net.machinemuse.general.gui.clickable.IClickable;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.numina.geometry.MusePoint2D;
import net.machinemuse.numina.geometry.SwirlyMuseCircle;
import net.machinemuse.numina.render.BillboardHelper;
import net.machinemuse.numina.render.MuseTextureUtils;
import net.machinemuse.numina.render.RenderState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.model.TexturedQuad;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

public abstract class MuseRenderer {
    protected static RenderItem renderItem;
    protected static SwirlyMuseCircle selectionCircle;
    public static final String ICON_PREFIX = "powersuits:";
    static boolean messagedAboutSlick;

    public static void drawCircleAround(double xoffset, double yoffset, double radius) {
        if (selectionCircle == null) {
            selectionCircle = new SwirlyMuseCircle(new Colour(0.0, 1.0, 0.0, 0.0), new Colour((double)0.8f, 1.0, (double)0.8f, 1.0));
        }
        selectionCircle.draw(radius, xoffset, yoffset);
    }

    public static void drawItemAt(double x, double y, ItemStack item) {
        RenderState.on2D();
        MuseRenderer.getRenderItem().func_82406_b(MuseRenderer.getFontRenderer(), MuseRenderer.getRenderEngine(), item, (int)x, (int)y);
        MuseRenderer.getRenderItem().func_77021_b(MuseRenderer.getFontRenderer(), MuseRenderer.getRenderEngine(), item, (int)x, (int)y);
        RenderState.off2D();
    }

    public static void drawString(String s, double x, double y) {
        MuseRenderer.drawString(s, x, y, Colour.WHITE);
    }

    public static void drawString(String s, double x, double y, Colour c) {
        RenderHelper.func_74518_a();
        RenderState.blendingOn();
        RenderState.on2D();
        MuseRenderer.getFontRenderer().func_78261_a(s, (int)x, (int)y, c.getInt());
        RenderState.off2D();
        RenderState.blendingOff();
    }

    public static void drawCenteredString(String s, double x, double y) {
        MuseRenderer.drawString(s, x - MuseRenderer.getStringWidth(s) / 2.0, y);
    }

    public static void drawRightAlignedString(String s, double x, double y) {
        MuseRenderer.drawString(s, x - MuseRenderer.getStringWidth(s), y);
    }

    public static double getStringWidth(String s) {
        GL11.glPushAttrib((int)262144);
        double val = MuseRenderer.getFontRenderer().func_78256_a(s);
        GL11.glPopAttrib();
        return val;
    }

    public static void drawStringsJustified(List<String> words, double x1, double x2, double y) {
        int totalwidth = 0;
        for (String word : words) {
            totalwidth = (int)((double)totalwidth + MuseRenderer.getStringWidth(word));
        }
        double spacing = (x2 - x1 - (double)totalwidth) / (double)(words.size() - 1);
        double currentwidth = 0.0;
        for (String word : words) {
            MuseRenderer.drawString(word, x1 + currentwidth, y);
            currentwidth += MuseRenderer.getStringWidth(word) + spacing;
        }
    }

    public static void drawRectPrism(double x, double d, double e, double f, double z, double g, float texturex, float texturey, float texturex2, float texturey2) {
        RenderState.arraysOnT();
        RenderState.texturelessOff();
        Vec3[] points = new Vec3[]{Vec3.func_72443_a((double)x, (double)e, (double)z), Vec3.func_72443_a((double)d, (double)e, (double)z), Vec3.func_72443_a((double)x, (double)f, (double)z), Vec3.func_72443_a((double)d, (double)f, (double)z), Vec3.func_72443_a((double)x, (double)e, (double)g), Vec3.func_72443_a((double)d, (double)e, (double)g), Vec3.func_72443_a((double)x, (double)f, (double)g), Vec3.func_72443_a((double)d, (double)f, (double)g)};
        PositionTextureVertex[] va1 = new PositionTextureVertex[]{new PositionTextureVertex(points[0], texturex, texturey2), new PositionTextureVertex(points[2], texturex2, texturey2), new PositionTextureVertex(points[3], texturex2, texturey), new PositionTextureVertex(points[1], texturex, texturey)};
        new TexturedQuad(va1).func_78236_a(Tessellator.field_78398_a, 1.0f);
        PositionTextureVertex[] va2 = new PositionTextureVertex[]{new PositionTextureVertex(points[2], texturex, texturey2), new PositionTextureVertex(points[6], texturex2, texturey2), new PositionTextureVertex(points[7], texturex2, texturey), new PositionTextureVertex(points[3], texturex, texturey)};
        new TexturedQuad(va2).func_78236_a(Tessellator.field_78398_a, 1.0f);
        PositionTextureVertex[] va3 = new PositionTextureVertex[]{new PositionTextureVertex(points[6], texturex, texturey2), new PositionTextureVertex(points[4], texturex2, texturey2), new PositionTextureVertex(points[5], texturex2, texturey), new PositionTextureVertex(points[7], texturex, texturey)};
        new TexturedQuad(va3).func_78236_a(Tessellator.field_78398_a, 1.0f);
        PositionTextureVertex[] va4 = new PositionTextureVertex[]{new PositionTextureVertex(points[4], texturex, texturey2), new PositionTextureVertex(points[0], texturex2, texturey2), new PositionTextureVertex(points[1], texturex2, texturey), new PositionTextureVertex(points[5], texturex, texturey)};
        new TexturedQuad(va4).func_78236_a(Tessellator.field_78398_a, 1.0f);
        PositionTextureVertex[] va5 = new PositionTextureVertex[]{new PositionTextureVertex(points[1], texturex, texturey2), new PositionTextureVertex(points[3], texturex2, texturey2), new PositionTextureVertex(points[7], texturex2, texturey), new PositionTextureVertex(points[5], texturex, texturey)};
        new TexturedQuad(va5).func_78236_a(Tessellator.field_78398_a, 1.0f);
        PositionTextureVertex[] va6 = new PositionTextureVertex[]{new PositionTextureVertex(points[0], texturex, texturey2), new PositionTextureVertex(points[4], texturex2, texturey2), new PositionTextureVertex(points[6], texturex2, texturey), new PositionTextureVertex(points[2], texturex, texturey)};
        new TexturedQuad(va6).func_78236_a(Tessellator.field_78398_a, 1.0f);
        RenderState.texturelessOff();
        RenderState.arraysOff();
    }

    public static FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    public static TextureManager getRenderEngine() {
        return Minecraft.func_71410_x().field_71446_o;
    }

    public static RenderItem getRenderItem() {
        if (renderItem == null) {
            renderItem = new RenderItem();
        }
        return renderItem;
    }

    public static void drawLineBetween(IClickable firstClickable, IClickable secondClickable, Colour gradientColour) {
        MusePoint2D secondpoint;
        MusePoint2D firstpoint;
        long varia = System.currentTimeMillis() % 2000L - 1000L;
        double gradientRatio = 1.0 - (double)((varia + 1000L) % 1000L) / 1000.0;
        MusePoint2D midpoint = firstClickable.getPosition().minus(secondClickable.getPosition()).times(Math.abs((double)varia / 1000.0)).plus(secondClickable.getPosition());
        if (varia < 0L) {
            firstpoint = secondClickable.getPosition();
            secondpoint = firstClickable.getPosition();
        } else {
            firstpoint = firstClickable.getPosition();
            secondpoint = secondClickable.getPosition();
        }
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)3553);
        GL11.glBegin((int)1);
        gradientColour.withAlpha(gradientRatio).doGL();
        GL11.glVertex3d((double)midpoint.x(), (double)midpoint.y(), (double)1.0);
        gradientColour.withAlpha(0.0).doGL();
        GL11.glVertex3d((double)firstpoint.x(), (double)firstpoint.y(), (double)1.0);
        gradientColour.withAlpha(gradientRatio).doGL();
        GL11.glVertex3d((double)secondpoint.x(), (double)secondpoint.y(), (double)1.0);
        Colour.WHITE.withAlpha(1.0).doGL();
        GL11.glVertex3d((double)midpoint.x(), (double)midpoint.y(), (double)1.0);
        GL11.glEnd();
        GL11.glPopAttrib();
    }

    public static void drawLightning(double x1, double y1, double z1, double x2, double y2, double z2, Colour colour) {
        MuseRenderer.drawLightningTextured(x1, y1, z1, x2, y2, z2, colour);
    }

    public static void drawMPDLightning(double x1, double y1, double z1, double x2, double y2, double z2, Colour colour, double displacement, double detail) {
        if (displacement < detail) {
            colour.doGL();
            GL11.glBegin((int)1);
            GL11.glVertex3d((double)x1, (double)y1, (double)z1);
            GL11.glVertex3d((double)x2, (double)y2, (double)z2);
            GL11.glEnd();
        } else {
            double mid_x = (x1 + x2) / 2.0;
            double mid_y = (y1 + y2) / 2.0;
            double mid_z = (z1 + z2) / 2.0;
            MuseRenderer.drawMPDLightning(x1, y1, z1, mid_x += (Math.random() - 0.5) * displacement, mid_y += (Math.random() - 0.5) * displacement, mid_z += (Math.random() - 0.5) * displacement, colour, displacement / 2.0, detail);
            MuseRenderer.drawMPDLightning(mid_x, mid_y, mid_z, x2, y2, z2, colour, displacement / 2.0, detail);
        }
    }

    public static void drawLightningTextured(double x1, double y1, double z1, double x2, double y2, double z2, Colour colour) {
        double tx = x2 - x1;
        double ty = y2 - y1;
        double tz = z2 - z1;
        double ax = 0.0;
        double ay = 0.0;
        double az = 0.0;
        double bx = 0.0;
        double by = 0.0;
        double bz = 0.0;
        double cx = 0.0;
        double cy = 0.0;
        double cz = 0.0;
        double jagfactor = 0.3;
        RenderState.on2D();
        GL11.glEnable((int)2929);
        MuseTextureUtils.pushTexture((String)"powersuits:textures/gui/lightning-medium.png");
        RenderState.blendingOn();
        colour.doGL();
        GL11.glBegin((int)7);
        while (Math.abs(cx) < Math.abs(tx) && Math.abs(cy) < Math.abs(ty) && Math.abs(cz) < Math.abs(tz)) {
            ax = x1 + cx;
            ay = y1 + cy;
            az = z1 + cz;
            bx = x1 + (cx += Math.random() * tx * jagfactor - 0.1 * tx);
            by = y1 + (cy += Math.random() * ty * jagfactor - 0.1 * ty);
            bz = z1 + (cz += Math.random() * tz * jagfactor - 0.1 * tz);
            int index = (int)(Math.random() * 50.0);
            MuseRenderer.drawLightningBetweenPointsFast(ax, ay, az, bx, by, bz, index);
        }
        GL11.glEnd();
        RenderState.blendingOff();
        RenderState.off2D();
    }

    public static void drawLightningBetweenPoints(double x1, double y1, double z1, double x2, double y2, double z2, int index) {
        MuseTextureUtils.pushTexture((String)"powersuits:textures/gui/lightning-medium.png");
        double u1 = (double)index / 50.0;
        double u2 = u1 + 0.02;
        double px = (y1 - y2) * 0.125;
        double py = (x2 - x1) * 0.125;
        GL11.glTexCoord2d((double)u1, (double)0.0);
        GL11.glVertex3d((double)(x1 - px), (double)(y1 - py), (double)z1);
        GL11.glTexCoord2d((double)u2, (double)0.0);
        GL11.glVertex3d((double)(x1 + px), (double)(y1 + py), (double)z1);
        GL11.glTexCoord2d((double)u1, (double)1.0);
        GL11.glVertex3d((double)(x2 - px), (double)(y2 - py), (double)z2);
        GL11.glTexCoord2d((double)u2, (double)1.0);
        GL11.glVertex3d((double)(x2 + px), (double)(y2 + py), (double)z2);
        MuseTextureUtils.popTexture();
    }

    public static void drawLightningBetweenPointsFast(double x1, double y1, double z1, double x2, double y2, double z2, int index) {
        double u1 = (double)index / 50.0;
        double u2 = u1 + 0.02;
        double px = (y1 - y2) * 0.125;
        double py = (x2 - x1) * 0.125;
        GL11.glTexCoord2d((double)u1, (double)0.0);
        GL11.glVertex3d((double)(x1 - px), (double)(y1 - py), (double)z1);
        GL11.glTexCoord2d((double)u2, (double)0.0);
        GL11.glVertex3d((double)(x1 + px), (double)(y1 + py), (double)z1);
        GL11.glTexCoord2d((double)u1, (double)1.0);
        GL11.glVertex3d((double)(x2 - px), (double)(y2 - py), (double)z2);
        GL11.glTexCoord2d((double)u2, (double)1.0);
        GL11.glVertex3d((double)(x2 + px), (double)(y2 + py), (double)z2);
    }

    public static void drawLightningLines(double x1, double y1, double z1, double x2, double y2, double z2, Colour colour) {
        double tx = x2 - x1;
        double ty = y2 - y1;
        double tz = z2 - z1;
        double cx = 0.0;
        double cy = 0.0;
        double cz = 0.0;
        double jagfactor = 0.3;
        RenderState.texturelessOn();
        RenderState.blendingOn();
        RenderState.on2D();
        GL11.glBegin((int)3);
        while (Math.abs(cx) < Math.abs(tx) && Math.abs(cy) < Math.abs(ty) && Math.abs(cz) < Math.abs(tz)) {
            colour.doGL();
            GL11.glVertex3d((double)(x1 + (cx += Math.random() * tx * jagfactor - 0.1 * tx)), (double)(y1 + (cy += Math.random() * ty * jagfactor - 0.1 * ty)), (double)(z1 + (cz += Math.random() * tz * jagfactor - 0.1 * tz)));
        }
        GL11.glEnd();
        RenderState.off2D();
        RenderState.blendingOff();
        RenderState.texturelessOff();
    }

    public static void unRotate() {
        BillboardHelper.unRotate();
    }

    static {
        messagedAboutSlick = false;
    }
}

