/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.utils;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.machinemuse.utils.render.MuseRenderer;
import net.minecraft.util.ResourceLocation;

public abstract class MuseStringUtils {
    public static final char[] smallSuffixes = new char[]{'m', 'u', 'n', 'p', 'f', 'a', 'z', 'y'};
    public static final char[] bigSuffixes = new char[]{'k', 'M', 'G', 'T', 'P', 'E', 'Z', 'Y'};

    public static String formatNumberShort(double number) {
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
        format.setMinimumIntegerDigits(1);
        format.setMaximumFractionDigits(2);
        format.applyPattern("##0.##E0");
        String[] exploded = format.format(number).split("E");
        String retval = exploded[0];
        if (retval.length() > 3) {
            retval = retval.charAt(3) == '.' ? retval.substring(0, 3) : retval.substring(0, 4);
        }
        if (exploded.length > 1) {
            int exponent = Integer.parseInt(exploded[1]);
            if (exponent > 0) {
                retval = retval + bigSuffixes[exponent / 3 - 1];
            } else if (exponent < 0) {
                retval = retval + smallSuffixes[exponent / -3 - 1];
            }
        }
        return retval;
    }

    public static String formatNumberPercent(double number) {
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
        format.setMinimumIntegerDigits(1);
        format.setMaximumFractionDigits(2);
        format.applyPattern("##0.##");
        return format.format(number * 100.0);
    }

    public static String formatNumberFromUnits(double number, String units) {
        if (units.equals("%")) {
            return MuseStringUtils.formatNumberPercent(number) + '%';
        }
        return MuseStringUtils.formatNumberShort(number) + units;
    }

    public static String prependFormatTag(String str, char format) {
        return "\u00a7" + format + str;
    }

    public static String appendResetTag(String str) {
        return str + "\u00a7r";
    }

    public static String wrapFormatTags(String str, char format) {
        return MuseStringUtils.appendResetTag(MuseStringUtils.prependFormatTag(str, format));
    }

    public static String wrapFormatTags(String str, FormatCodes code) {
        return MuseStringUtils.wrapFormatTags(str, code.character);
    }

    public static String wrapMultipleFormatTags(String str, Object ... tags) {
        for (Object tag : tags) {
            if (tag instanceof Character) {
                str = MuseStringUtils.prependFormatTag(str, ((Character)tag).charValue());
                continue;
            }
            if (!(tag instanceof FormatCodes)) continue;
            str = MuseStringUtils.prependFormatTag(str, ((FormatCodes)((Object)tag)).character);
        }
        return MuseStringUtils.appendResetTag(str);
    }

    public static List<String> wrapStringToLength(String str, int length) {
        ArrayList<String> strlist = new ArrayList<String>();
        int i = 0;
        while (i + length < str.length()) {
            int j = str.lastIndexOf(32, i + length);
            if (j == -1) {
                j = str.indexOf(32, i + length);
            }
            if (j == -1) break;
            strlist.add(str.substring(i, j));
            i = j + 1;
        }
        strlist.add(str.substring(i));
        return strlist;
    }

    public static List<String> wrapStringToVisualLength(String str, double length) {
        ArrayList<String> strlist = new ArrayList<String>();
        String[] words = str.split(" ");
        if (words.length == 0) {
            return null;
        }
        boolean line = false;
        String currLine = words[0];
        for (int i = 1; i < words.length; ++i) {
            String approxLine = currLine + " " + words[i];
            if (MuseRenderer.getStringWidth(approxLine) > length) {
                strlist.add(currLine);
                currLine = " " + words[i];
                continue;
            }
            currLine = approxLine;
        }
        strlist.add(currLine);
        return strlist;
    }

    public static String extractName(ResourceLocation resource) {
        String filename = resource.toString();
        int ix = Math.max(filename.lastIndexOf(47), Math.max(filename.lastIndexOf(92), filename.lastIndexOf(58))) + 1;
        return filename.substring(ix, filename.lastIndexOf(46));
    }

    public static String extractName(String filename) {
        int ix = Math.max(filename.lastIndexOf(47), Math.max(filename.lastIndexOf(92), filename.lastIndexOf(58))) + 1;
        return filename.substring(ix, filename.lastIndexOf(46));
    }

    public static enum FormatCodes {
        Black('0'),
        DarkBlue('1'),
        DarkGreen('2'),
        DarkAqua('3'),
        DarkRed('4'),
        Purple('5'),
        Gold('6'),
        Grey('7'),
        DarkGrey('8'),
        Indigo('9'),
        BrightGreen('a'),
        Aqua('b'),
        Red('c'),
        Pink('d'),
        Yellow('e'),
        White('f'),
        RandomChar('k'),
        Bold('l'),
        Strike('m'),
        Underlined('n'),
        Italic('o'),
        Reset('r');

        public char character;

        private FormatCodes(char character) {
            this.character = character;
        }
    }
}

