/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.event;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.general.gui.clickable.ClickableKeybinding;
import net.machinemuse.general.gui.clickable.ClickableModule;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.numina.geometry.DrawableMuseRect;
import net.machinemuse.numina.render.MuseIconUtils;
import net.machinemuse.numina.render.MuseTextureUtils;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.control.KeybindManager;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.render.MuseRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;

public class RenderEventHandler {
    private static boolean ownFly;
    private final DrawableMuseRect frame = new DrawableMuseRect(Config.keybindHUDx(), Config.keybindHUDy(), Config.keybindHUDx() + 16.0, Config.keybindHUDy() + 16.0, true, Colour.DARKGREEN.withAlpha(0.2), Colour.GREEN.withAlpha(0.2));

    public RenderEventHandler() {
        ownFly = false;
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Post event) {
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution screen = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
    }

    @SubscribeEvent
    public void onPreRenderPlayer(RenderPlayerEvent.Pre event) {
        if (!event.entityPlayer.field_71075_bZ.field_75100_b && !event.entityPlayer.field_70122_E && this.playerHasFlightOn(event.entityPlayer)) {
            event.entityPlayer.field_71075_bZ.field_75100_b = true;
            ownFly = true;
        }
    }

    private boolean playerHasFlightOn(EntityPlayer player) {
        return ModuleManager.itemHasActiveModule(player.func_82169_q(2), "Jetpack") || ModuleManager.itemHasActiveModule(player.func_82169_q(2), "Glider") || ModuleManager.itemHasActiveModule(player.func_82169_q(0), "Jet Boots") || ModuleManager.itemHasActiveModule(player.func_82169_q(3), "Flight Control");
    }

    @SubscribeEvent
    public void onPostRenderPlayer(RenderPlayerEvent.Post event) {
        if (ownFly) {
            ownFly = false;
            event.entityPlayer.field_71075_bZ.field_75100_b = false;
        }
    }

    @SubscribeEvent
    public void onFOVUpdate(FOVUpdateEvent e) {
        ItemStack helmet = e.entity.func_82169_q(3);
        if (ModuleManager.itemHasActiveModule(helmet, "Binoculars")) {
            e.newfov /= (float)ModuleManager.computeModularProperty(helmet, "Field of View");
        }
    }

    @SubscribeEvent
    public void onPostRenderGameOverlayEvent(RenderGameOverlayEvent.Post e) {
        RenderGameOverlayEvent.ElementType elementType = e.type;
        if (RenderGameOverlayEvent.ElementType.HOTBAR.equals((Object)elementType)) {
            this.drawKeybindToggles();
        }
    }

    public void drawKeybindToggles() {
        if (Config.keybindHUDon()) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityClientPlayerMP player = mc.field_71439_g;
            ScaledResolution screen = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
            this.frame.setLeft(Config.keybindHUDx());
            this.frame.setTop(Config.keybindHUDy());
            this.frame.setBottom(this.frame.top() + 16.0);
            for (ClickableKeybinding kb : KeybindManager.getKeybindings()) {
                if (!kb.displayOnHUD) continue;
                double stringwidth = MuseRenderer.getStringWidth(kb.getLabel());
                this.frame.setWidth(stringwidth + (double)(kb.getBoundModules().size() * 16));
                this.frame.draw();
                MuseRenderer.drawString(kb.getLabel(), this.frame.left() + 1.0, this.frame.top() + 3.0, kb.toggleval ? Colour.RED : Colour.GREEN);
                double x = this.frame.left() + stringwidth;
                for (ClickableModule module : kb.getBoundModules()) {
                    MuseTextureUtils.pushTexture((String)module.getModule().getStitchedTexture(null));
                    boolean active = false;
                    for (ItemStack stack : MuseItemUtils.modularItemsEquipped((EntityPlayer)player)) {
                        if (!ModuleManager.itemHasActiveModule(stack, module.getModule().getDataName())) continue;
                        active = true;
                    }
                    MuseIconUtils.drawIconAt((double)x, (double)this.frame.top(), (IIcon)module.getModule().getIcon(null), (Colour)(active ? Colour.WHITE : Colour.DARKGREY.withAlpha(0.5)));
                    MuseTextureUtils.popTexture();
                    x += 16.0;
                }
                this.frame.setTop(this.frame.top() + 16.0);
                this.frame.setBottom(this.frame.top() + 16.0);
            }
        }
    }
}

