/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.render.block;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.numina.render.MuseTESR;
import net.machinemuse.numina.render.RenderState;
import net.machinemuse.powersuits.block.TileEntityLuxCapacitor;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.obj.WavefrontObject;
import org.lwjgl.opengl.GL11;

public class RenderLuxCapacitorTESR
extends MuseTESR
implements ISimpleBlockRenderingHandler {
    protected static WavefrontObject lightmodel;
    protected static WavefrontObject framemodel;
    protected int renderId;

    public RenderLuxCapacitorTESR(int renderId) {
        this.renderId = renderId;
    }

    public static WavefrontObject getLightModel() {
        if (lightmodel == null) {
            lightmodel = (WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("powersuits:models/lightCore.obj"));
        }
        return lightmodel;
    }

    public static WavefrontObject getFrameModel() {
        if (framemodel == null) {
            framemodel = (WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("powersuits:models/lightBase.obj"));
        }
        return framemodel;
    }

    public void renderAt(TileEntity undifferentiatedtileentity, double x, double y, double z, float partialTickTime) {
        TileEntityLuxCapacitor tileentity = (TileEntityLuxCapacitor)undifferentiatedtileentity;
        this.bindTextureByName("powersuits:textures/models/thusters_uvw_2.png");
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        double scale = 0.0625;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        switch (tileentity.side) {
            case DOWN: {
                GL11.glTranslated((double)0.0, (double)-8.0, (double)0.0);
                break;
            }
            case EAST: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslated((double)0.0, (double)-8.0, (double)0.0);
                break;
            }
            case NORTH: {
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslated((double)0.0, (double)-8.0, (double)0.0);
                break;
            }
            case SOUTH: {
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslated((double)0.0, (double)-8.0, (double)0.0);
                break;
            }
            case UP: {
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslated((double)0.0, (double)-8.0, (double)0.0);
                break;
            }
            case WEST: {
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslated((double)0.0, (double)-8.0, (double)0.0);
                break;
            }
        }
        RenderLuxCapacitorTESR.getFrameModel().renderAll();
        RenderState.glowOn();
        new Colour(tileentity.red, tileentity.green, tileentity.blue, 1.0).doGL();
        RenderLuxCapacitorTESR.getLightModel().renderAll();
        RenderState.glowOff();
        GL11.glPopMatrix();
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        this.bindTextureByName("powersuits:textures/models/thusters_uvw_2.png");
        GL11.glPushMatrix();
        GL11.glTranslated((double)-0.5, (double)-0.5625, (double)-0.5);
        GL11.glPushMatrix();
        double scale = 0.0625;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        RenderLuxCapacitorTESR.getFrameModel().renderAll();
        RenderState.glowOn();
        RenderLuxCapacitorTESR.getLightModel().renderAll();
        RenderState.glowOff();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return this.renderId;
    }
}

