/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.gui.frame;

import java.util.ArrayList;
import java.util.List;
import net.machinemuse.general.gui.clickable.ClickableItem;
import net.machinemuse.general.gui.frame.ColourPickerFrame;
import net.machinemuse.general.gui.frame.ItemSelectionFrame;
import net.machinemuse.numina.general.MuseLogger;
import net.machinemuse.numina.general.MuseMathUtils;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.numina.geometry.MuseRect;
import net.machinemuse.numina.geometry.MuseRelativeRect;
import net.machinemuse.numina.network.MusePacket;
import net.machinemuse.numina.network.PacketSender;
import net.machinemuse.numina.render.RenderState;
import net.machinemuse.powersuits.client.render.modelspec.ModelPartSpec;
import net.machinemuse.powersuits.client.render.modelspec.ModelRegistry;
import net.machinemuse.powersuits.client.render.modelspec.ModelSpec;
import net.machinemuse.powersuits.network.packets.MusePacketCosmeticInfo;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.render.GuiIcons;
import net.machinemuse.utils.render.MuseRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.opengl.GL11;

public class PartManipSubFrame {
    public ModelSpec model;
    public ColourPickerFrame colourframe;
    public ItemSelectionFrame itemSelector;
    public final MuseRelativeRect border;
    public List<ModelPartSpec> specs;
    public boolean open;

    public PartManipSubFrame(ModelSpec model, ColourPickerFrame colourframe, ItemSelectionFrame itemSelector, MuseRelativeRect border) {
        this.model = model;
        this.colourframe = colourframe;
        this.itemSelector = itemSelector;
        this.border = border;
        this.specs = this.getSpecs();
        this.open = true;
    }

    private List<ModelPartSpec> getSpecs() {
        ArrayList<ModelPartSpec> specsArray = new ArrayList<ModelPartSpec>();
        for (ModelPartSpec spec : this.model.apply().values()) {
            if (!this.isValidArmor(this.getSelectedItem(), spec.slot)) continue;
            specsArray.add(spec);
        }
        return specsArray;
    }

    public int getArmorSlot() {
        return ((ItemArmor)this.getSelectedItem().getItem().func_77973_b()).field_77881_a;
    }

    public ClickableItem getSelectedItem() {
        return this.itemSelector.getSelectedItem();
    }

    public NBTTagCompound getRenderTag() {
        return MuseItemUtils.getMuseRenderTag(this.getSelectedItem().getItem(), this.getArmorSlot());
    }

    public NBTTagCompound getItemTag() {
        return MuseItemUtils.getMuseItemTag(this.getSelectedItem().getItem());
    }

    public boolean isValidArmor(ClickableItem clickie, int slot) {
        return clickie != null && clickie.getItem().func_77973_b().isValidArmor(clickie.getItem(), slot, (Entity)Minecraft.func_71410_x().field_71439_g);
    }

    public NBTTagCompound getSpecTag(ModelPartSpec spec) {
        return this.getRenderTag().func_74775_l(ModelRegistry.getInstance().makeName(spec));
    }

    public NBTTagCompound getOrDontGetSpecTag(ModelPartSpec spec) {
        String name = ModelRegistry.getInstance().makeName(spec);
        return this.getRenderTag().func_74764_b(name) ? this.getRenderTag().func_74775_l(name) : null;
    }

    public NBTTagCompound getOrMakeSpecTag(ModelPartSpec spec) {
        NBTTagCompound compoundTag;
        String name = ModelRegistry.getInstance().makeName(spec);
        if (this.getRenderTag().func_74764_b(name)) {
            compoundTag = this.getRenderTag().func_74775_l(name);
        } else {
            NBTTagCompound k = new NBTTagCompound();
            spec.multiSet(k, null, null, null);
            this.getRenderTag().func_74782_a(name, (NBTBase)k);
            compoundTag = k;
        }
        return compoundTag;
    }

    public void updateItems() {
        this.specs = this.getSpecs();
        this.border.setHeight(this.specs.size() > 0 ? (double)(this.specs.size() * 8 + 10) : 0.0);
    }

    public void drawPartial(double min, double max) {
        if (this.specs.size() > 0) {
            MuseRenderer.drawString((String)ModelRegistry.getInstance().getName((Object)this.model), this.border.left() + 8.0, this.border.top());
            this.drawOpenArrow(min, max);
            if (this.open) {
                int y = (int)(this.border.top() + 8.0);
                for (ModelPartSpec spec : this.specs) {
                    this.drawSpecPartial(this.border.left(), y, spec, min, max);
                    y += 8;
                }
            }
        }
    }

    public void decrAbove(int index) {
        for (ModelPartSpec spec : this.specs) {
            int oldindex;
            String tagname = ModelRegistry.getInstance().makeName(spec);
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            NBTTagCompound tagdata = this.getOrDontGetSpecTag(spec);
            if (tagdata == null || (oldindex = spec.getColourIndex(tagdata)) < index || oldindex <= 0) continue;
            spec.setColourIndex(tagdata, oldindex - 1);
            if (!player.field_70170_p.field_72995_K) continue;
            PacketSender.sendToServer((MusePacket)new MusePacketCosmeticInfo((EntityPlayer)player, this.getSelectedItem().inventorySlot, tagname, tagdata).getPacket131());
        }
    }

    public void drawSpecPartial(double x, double y, ModelPartSpec spec, double ymino, double ymaxo) {
        NBTTagCompound tag = this.getSpecTag(spec);
        int selcomp = tag.func_82582_d() ? 0 : (spec.getGlow(tag) ? 2 : 1);
        int selcolour = spec.getColourIndex(tag);
        new GuiIcons.TransparentArmor(x, y, null, null, ymino, null, ymaxo);
        new GuiIcons.NormalArmor(x + 8.0, y, null, null, ymino, null, ymaxo);
        new GuiIcons.GlowArmor(x + 16.0, y, null, null, ymino, null, ymaxo);
        new GuiIcons.SelectedArmorOverlay(x + (double)(selcomp * 8), y, null, null, ymino, null, ymaxo);
        double acc = x + 28.0;
        for (int colour : this.colourframe.colours()) {
            new GuiIcons.ArmourColourPatch(acc, y, new Colour(colour), null, ymino, null, ymaxo);
            acc += 8.0;
        }
        double textstartx = acc;
        if (selcomp > 0) {
            new GuiIcons.SelectedArmorOverlay(x + 28.0 + (double)(selcolour * 8), y, null, null, ymino, null, ymaxo);
        }
        MuseRenderer.drawString(spec.displayName, textstartx + 4.0, y);
    }

    public void drawOpenArrow(double min, double max) {
        RenderState.texturelessOn();
        Colour.LIGHTBLUE.doGL();
        GL11.glBegin((int)4);
        if (this.open) {
            GL11.glVertex2d((double)(this.border.left() + 3.0), (double)MuseMathUtils.clampDouble((double)(this.border.top() + 3.0), (double)min, (double)max));
            GL11.glVertex2d((double)(this.border.left() + 5.0), (double)MuseMathUtils.clampDouble((double)(this.border.top() + 7.0), (double)min, (double)max));
            GL11.glVertex2d((double)(this.border.left() + 7.0), (double)MuseMathUtils.clampDouble((double)(this.border.top() + 3.0), (double)min, (double)max));
        } else {
            GL11.glVertex2d((double)(this.border.left() + 3.0), (double)MuseMathUtils.clampDouble((double)(this.border.top() + 3.0), (double)min, (double)max));
            GL11.glVertex2d((double)(this.border.left() + 3.0), (double)MuseMathUtils.clampDouble((double)(this.border.top() + 7.0), (double)min, (double)max));
            GL11.glVertex2d((double)(this.border.left() + 7.0), (double)MuseMathUtils.clampDouble((double)(this.border.top() + 5.0), (double)min, (double)max));
        }
        GL11.glEnd();
        Colour.WHITE.doGL();
        RenderState.texturelessOff();
    }

    public MuseRect getBorder() {
        if (this.open) {
            this.border.setHeight((double)(9 + 9 * this.specs.size()));
        } else {
            this.border.setHeight(9.0);
        }
        return this.border;
    }

    public boolean tryMouseClick(double x, double y) {
        if (x < this.border.left() || x > this.border.right() || y < this.border.top() || y > this.border.bottom()) {
            return false;
        }
        if (x > this.border.left() + 2.0 && x < this.border.left() + 8.0 && y > this.border.top() + 2.0 && y < this.border.top() + 8.0) {
            this.open = !this.open;
            this.getBorder();
            return true;
        }
        if (x < this.border.left() + 24.0 && y > this.border.top() + 8.0) {
            int lineNumber = (int)((y - this.border.top() - 8.0) / 8.0);
            int columnNumber = (int)((x - this.border.left()) / 8.0);
            ModelPartSpec spec = this.specs.get(Math.max(Math.min(lineNumber, this.specs.size() - 1), 0));
            MuseLogger.logDebug((String)("Line " + lineNumber + " Column " + columnNumber));
            switch (columnNumber) {
                case 0: {
                    NBTTagCompound renderTag = this.getRenderTag();
                    String tagname3 = ModelRegistry.getInstance().makeName(spec);
                    EntityClientPlayerMP player3 = Minecraft.func_71410_x().field_71439_g;
                    renderTag.func_82580_o(ModelRegistry.getInstance().makeName(spec));
                    if (player3.field_70170_p.field_72995_K) {
                        PacketSender.sendToServer((MusePacket)new MusePacketCosmeticInfo((EntityPlayer)player3, this.getSelectedItem().inventorySlot, tagname3, new NBTTagCompound()).getPacket131());
                    }
                    this.updateItems();
                    return true;
                }
                case 1: {
                    String tagname2 = ModelRegistry.getInstance().makeName(spec);
                    EntityClientPlayerMP player2 = Minecraft.func_71410_x().field_71439_g;
                    NBTTagCompound tagdata2 = this.getOrMakeSpecTag(spec);
                    spec.setGlow(tagdata2, false);
                    if (player2.field_70170_p.field_72995_K) {
                        PacketSender.sendToServer((MusePacket)new MusePacketCosmeticInfo((EntityPlayer)player2, this.getSelectedItem().inventorySlot, tagname2, tagdata2).getPacket131());
                    }
                    this.updateItems();
                    return true;
                }
                case 2: {
                    String tagname = ModelRegistry.getInstance().makeName(spec);
                    EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
                    NBTTagCompound tagdata = this.getOrMakeSpecTag(spec);
                    spec.setGlow(tagdata, true);
                    if (player.field_70170_p.field_72995_K) {
                        PacketSender.sendToServer((MusePacket)new MusePacketCosmeticInfo((EntityPlayer)player, this.getSelectedItem().inventorySlot, tagname, tagdata).getPacket131());
                    }
                    this.updateItems();
                    return true;
                }
            }
            return false;
        }
        if (x > this.border.left() + 28.0 && x < this.border.left() + 28.0 + (double)(this.colourframe.colours().length * 8)) {
            int lineNumber2 = (int)((y - this.border.top() - 8.0) / 8.0);
            int columnNumber2 = (int)((x - this.border.left() - 28.0) / 8.0);
            ModelPartSpec spec2 = this.specs.get(Math.max(Math.min(lineNumber2, this.specs.size() - 1), 0));
            String tagname4 = ModelRegistry.getInstance().makeName(spec2);
            EntityClientPlayerMP player4 = Minecraft.func_71410_x().field_71439_g;
            NBTTagCompound tagdata3 = this.getOrMakeSpecTag(spec2);
            spec2.setColourIndex(tagdata3, columnNumber2);
            if (player4.field_70170_p.field_72995_K) {
                PacketSender.sendToServer((MusePacket)new MusePacketCosmeticInfo((EntityPlayer)player4, this.getSelectedItem().inventorySlot, tagname4, tagdata3).getPacket131());
            }
            return true;
        }
        return false;
    }
}

