/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mffs.prefab.tile;

import com.builtbroken.mc.imp.transform.vector.Point;
import com.builtbroken.mffs.api.IFieldInteraction;
import com.builtbroken.mffs.api.event.EventTimedTask;
import com.builtbroken.mffs.api.modules.IFieldModule;
import com.builtbroken.mffs.api.modules.IProjectorMode;
import com.builtbroken.mffs.api.vector.Vector3D;
import com.builtbroken.mffs.common.items.modules.projector.ItemModuleInvert;
import com.builtbroken.mffs.common.items.modules.upgrades.ItemModuleRotate;
import com.builtbroken.mffs.common.items.modules.upgrades.ItemModuleScale;
import com.builtbroken.mffs.common.items.modules.upgrades.ItemModuleTranslate;
import com.builtbroken.mffs.common.net.packet.EntityToggle;
import com.builtbroken.mffs.prefab.tile.TileModuleAcceptor;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileFieldMatrix
extends TileModuleAcceptor
implements IFieldInteraction {
    public static final int[][] RELATIVE_MATRIX = new int[][]{{3, 2, 1, 0, 5, 4}, {4, 5, 0, 1, 2, 3}, {0, 1, 3, 2, 4, 5}, {0, 1, 2, 3, 5, 4}, {0, 1, 5, 4, 3, 2}, {0, 1, 4, 5, 2, 3}};
    public static final Point MATRIX_CENTER = new Point(110.0, 55.0);
    protected static final int MODULE_SLOT_ID = 1;
    private static final int[][] SLOT_DIRECTIONS = new int[][]{{12, 13}, {10, 11}, {4, 5}, {2, 3}, {6, 7}, {8, 9}};
    public static int[] MODULE_SLOTS = new int[]{14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24};
    protected final Set<Vector3D> calculatedFields = Collections.synchronizedSet(new HashSet());
    private final List<EventTimedTask> eventsQueued = new LinkedList<EventTimedTask>();
    public boolean isAbs = true;
    protected boolean isCalc;
    protected boolean isFinished;

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        Iterator<EventTimedTask> it$ = this.eventsQueued.iterator();
        while (it$.hasNext()) {
            EventTimedTask task = it$.next();
            task.tick();
            if (task.isActive()) continue;
            it$.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculatedForceField() {
        if (!this.isCalc && !this.func_145831_w().field_72995_K) {
            Set<Vector3D> set = this.calculatedFields;
            synchronized (set) {
                if (this.getMode() != null) {
                    this.calculatedFields.clear();
                    new Thread(() -> {
                        TileFieldMatrix entity = this;
                        entity.setCalculating(true);
                        try {
                            IProjectorMode mode = entity.getMode();
                            if (mode != null) {
                                Set<Vector3D> blocks = entity.getModuleCount(ItemModuleInvert.class, new int[0]) > 0 ? mode.getInteriorPoints(entity) : mode.getExteriorPoints(entity);
                                Vector3D translation = entity.getTranslation();
                                int rotationYaw = entity.getRotationYaw();
                                int rotationPitch = entity.getRotationPitch();
                                for (IFieldModule module : entity.getModules(new int[0])) {
                                    blocks = module.onPreCalculate(entity, blocks);
                                }
                                for (Vector3D position : blocks) {
                                    if (rotationYaw != 0 || rotationPitch != 0) {
                                        position.rotate((double)rotationYaw, rotationPitch);
                                    }
                                    position.translate(new Vector3D(entity));
                                    position.translate(translation);
                                    if (position.intY() > entity.func_145831_w().func_72800_K()) continue;
                                    entity.getCalculatedField().add(position.round());
                                }
                                for (IFieldModule module : entity.getModules(new int[0])) {
                                    module.onCalculate(entity, entity.getCalculatedField());
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        entity.getCalculatedField().remove(new Vector3D(entity));
                        entity.setCalculating(false);
                        entity.setCalculated(true);
                        entity.onCalculationCompletion();
                    }).start();
                }
            }
        }
    }

    public void onCalculationCompletion() {
    }

    @Override
    public IProjectorMode getMode() {
        ItemStack modeStack = this.getModeStack();
        if (modeStack != null) {
            return (IProjectorMode)modeStack.func_77973_b();
        }
        return null;
    }

    @Override
    public ItemStack getModeStack() {
        ItemStack stack = this.func_70301_a(1);
        if (stack != null && stack.func_77973_b() instanceof IProjectorMode) {
            return stack;
        }
        return null;
    }

    @Override
    public int[] getSlotsBasedOnDirection(ForgeDirection paramForgeDirection) {
        if (paramForgeDirection.ordinal() > SLOT_DIRECTIONS.length) {
            return new int[0];
        }
        return SLOT_DIRECTIONS[paramForgeDirection.ordinal()];
    }

    @Override
    public int[] getModuleSlots() {
        return MODULE_SLOTS;
    }

    @Override
    public int getSidedModuleCount(Class<? extends IFieldModule> module, ForgeDirection ... paramVarArgs) {
        ForgeDirection[] dirs;
        int count = 0;
        for (ForgeDirection dir : dirs = paramVarArgs != null && paramVarArgs.length > 0 ? paramVarArgs : ForgeDirection.VALID_DIRECTIONS) {
            count += this.getModuleCount(module, this.getSlotsBasedOnDirection(dir));
        }
        return count;
    }

    @Override
    public Vector3D getTranslation() {
        ForgeDirection dir = this.getDirection();
        if (dir == ForgeDirection.UP || dir == ForgeDirection.DOWN) {
            dir = ForgeDirection.NORTH;
        }
        int zNeg = this.getModuleCount(ItemModuleTranslate.class, this.getSlotsBasedOnDirection(this.isAbs ? ForgeDirection.NORTH : this.getOrient(dir, ForgeDirection.NORTH)));
        int zPos = this.getModuleCount(ItemModuleTranslate.class, this.getSlotsBasedOnDirection(this.isAbs ? ForgeDirection.SOUTH : this.getOrient(dir, ForgeDirection.SOUTH)));
        int xNeg = this.getModuleCount(ItemModuleTranslate.class, this.getSlotsBasedOnDirection(this.isAbs ? ForgeDirection.WEST : this.getOrient(dir, ForgeDirection.WEST)));
        int xPos = this.getModuleCount(ItemModuleTranslate.class, this.getSlotsBasedOnDirection(this.isAbs ? ForgeDirection.EAST : this.getOrient(dir, ForgeDirection.EAST)));
        int yNeg = this.getModuleCount(ItemModuleTranslate.class, this.getSlotsBasedOnDirection(ForgeDirection.DOWN));
        int yPos = this.getModuleCount(ItemModuleTranslate.class, this.getSlotsBasedOnDirection(ForgeDirection.UP));
        return new Vector3D(xPos - xNeg, yPos - yNeg, zPos - zNeg);
    }

    protected ForgeDirection getOrient(ForgeDirection d1, ForgeDirection d2) {
        return ForgeDirection.getOrientation((int)RELATIVE_MATRIX[d1.ordinal()][d2.ordinal()]);
    }

    @Override
    public Vector3D getPositiveScale() {
        ForgeDirection direction = this.getDirection();
        if (!(this.isAbs || direction != ForgeDirection.UP && direction != ForgeDirection.DOWN)) {
            direction = ForgeDirection.NORTH;
        }
        int zScalePos = this.getModuleCount(ItemModuleScale.class, this.getSlotsBasedOnDirection(this.isAbs ? ForgeDirection.SOUTH : this.getOrient(direction, ForgeDirection.SOUTH)));
        int xScalePos = this.getModuleCount(ItemModuleScale.class, this.getSlotsBasedOnDirection(this.isAbs ? ForgeDirection.EAST : this.getOrient(direction, ForgeDirection.EAST)));
        int yScalePos = this.getModuleCount(ItemModuleScale.class, this.getSlotsBasedOnDirection(ForgeDirection.UP));
        int omnidirectionalScale = this.getModuleCount(ItemModuleScale.class, this.getModuleSlots());
        Vector3D positiveScale = new Vector3D(xScalePos + omnidirectionalScale, yScalePos + omnidirectionalScale, zScalePos + omnidirectionalScale);
        return positiveScale;
    }

    @Override
    public Vector3D getNegativeScale() {
        ForgeDirection direction = this.getDirection();
        if (direction == ForgeDirection.UP || direction == ForgeDirection.DOWN) {
            direction = ForgeDirection.NORTH;
        }
        int zNeg = this.getModuleCount(ItemModuleScale.class, this.getSlotsBasedOnDirection(this.isAbs ? ForgeDirection.NORTH : this.getOrient(direction, ForgeDirection.NORTH)));
        int xNeg = this.getModuleCount(ItemModuleScale.class, this.getSlotsBasedOnDirection(this.isAbs ? ForgeDirection.WEST : this.getOrient(direction, ForgeDirection.WEST)));
        int yNeg = this.getModuleCount(ItemModuleScale.class, this.getSlotsBasedOnDirection(ForgeDirection.DOWN));
        int omnidirectionalScale = this.getModuleCount(ItemModuleScale.class, this.getModuleSlots());
        Vector3D negScale = new Vector3D(xNeg + omnidirectionalScale, yNeg + omnidirectionalScale, zNeg + omnidirectionalScale);
        return negScale;
    }

    @Override
    public int getRotationYaw() {
        ForgeDirection dir = this.getDirection();
        int yawValue = this.getModuleCount(ItemModuleRotate.class, this.getSlotsBasedOnDirection(this.isAbs ? ForgeDirection.EAST : this.getOrient(dir, ForgeDirection.EAST)));
        yawValue -= this.getModuleCount(ItemModuleRotate.class, this.getSlotsBasedOnDirection(this.isAbs ? ForgeDirection.WEST : this.getOrient(dir, ForgeDirection.WEST)));
        yawValue += this.getModuleCount(ItemModuleRotate.class, this.getSlotsBasedOnDirection(this.isAbs ? ForgeDirection.SOUTH : this.getOrient(dir, ForgeDirection.SOUTH)));
        return (yawValue -= this.getModuleCount(ItemModuleRotate.class, this.getSlotsBasedOnDirection(this.isAbs ? ForgeDirection.NORTH : this.getOrient(dir, ForgeDirection.NORTH)))) * 2;
    }

    @Override
    public int getRotationPitch() {
        return (this.getModuleCount(ItemModuleRotate.class, this.getSlotsBasedOnDirection(ForgeDirection.UP)) - this.getModuleCount(ItemModuleRotate.class, this.getSlotsBasedOnDirection(ForgeDirection.DOWN))) * 2;
    }

    @Override
    public Set<Vector3D> getCalculatedField() {
        return this.calculatedFields;
    }

    @Override
    public Set<Vector3D> getInteriorPoints() {
        Set<Vector3D> newField = this.getMode().getInteriorPoints(this);
        HashSet<Vector3D> returnField = new HashSet<Vector3D>();
        Vector3D translation = this.getTranslation();
        int rotationYaw = this.getRotationYaw();
        int rotationPitch = this.getRotationPitch();
        Vector3D thisField = new Vector3D(this);
        for (Vector3D position : newField) {
            Vector3D newPosition = position.clone();
            if (rotationYaw != 0 || rotationPitch != 0) {
                newPosition.rotate((double)rotationYaw, rotationPitch);
            }
            newPosition.translate(thisField);
            newPosition.translate(translation);
            returnField.add(newPosition);
        }
        return returnField;
    }

    @Override
    public void setCalculating(boolean paramBoolean) {
        this.isCalc = paramBoolean;
    }

    @Override
    public void setCalculated(boolean paramBoolean) {
        this.isFinished = paramBoolean;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("isAbs", this.isAbs);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isAbs = nbt.func_74767_n("isAbs");
    }

    @Override
    public IMessage handleMessage(IMessage imessage) {
        if (imessage instanceof EntityToggle) {
            EntityToggle pkt = (EntityToggle)imessage;
            if (pkt.toggle_opcode == 2) {
                this.isAbs = !this.isAbs;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return null;
            }
        }
        return super.handleMessage(imessage);
    }

    public List<EventTimedTask> getEventsQueued() {
        return this.eventsQueued;
    }
}

