/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mffs.content.field;

import com.builtbroken.mffs.api.IForceFieldBlock;
import com.builtbroken.mffs.api.IProjector;
import com.builtbroken.mffs.api.fortron.IFortronStorage;
import com.builtbroken.mffs.api.modules.IFieldModule;
import com.builtbroken.mffs.api.security.IBiometricIdentifier;
import com.builtbroken.mffs.api.security.Permission;
import com.builtbroken.mffs.api.vector.Vector3D;
import com.builtbroken.mffs.client.render.RenderForceFieldHandler;
import com.builtbroken.mffs.common.items.modules.projector.ItemModuleGlow;
import com.builtbroken.mffs.common.items.modules.projector.ItemModuleShock;
import com.builtbroken.mffs.content.field.TileForceField;
import com.builtbroken.mffs.content.projector.TileForceFieldProjector;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockForceField
extends Block
implements ITileEntityProvider,
IForceFieldBlock {
    public static BlockForceField BLOCK_FORCE_FIELD;

    public BlockForceField() {
        super(Material.field_151592_s);
        this.func_149752_b(999.0f);
        this.func_149722_s();
        this.func_149647_a(null);
    }

    @Override
    public IProjector getProjector(IBlockAccess access, int x, int y, int z) {
        TileEntity tile = access.func_147438_o(x, y, z);
        if (tile instanceof TileForceField) {
            return ((TileForceField)tile).getProj();
        }
        return null;
    }

    @Override
    public void weakenForceField(World world, int x, int y, int z, int joules) {
        IProjector proj = this.getProjector((IBlockAccess)world, x, y, z);
        if (proj != null) {
            ((IFortronStorage)((Object)proj)).provideFortron(joules, true);
        }
        if (!world.field_72995_K) {
            world.func_147468_f(x, y, z);
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    protected boolean func_149700_E() {
        return false;
    }

    public int func_149745_a(Random p_149745_1_) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess access, int x, int y, int z, int side) {
        ItemStack camo;
        TileEntity tile = access.func_147438_o(x, y, z);
        if (tile instanceof TileForceField && (camo = ((TileForceField)tile).camo) != null && camo.func_77973_b() instanceof ItemBlock) {
            ItemBlock block = (ItemBlock)camo.func_77973_b();
            return block.field_150939_a.func_149691_a(side, camo.func_77960_j());
        }
        return this.func_149691_a(side, access.func_72805_g(x, y, z));
    }

    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        ItemStack stack;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileForceField && (stack = ((TileForceField)tile).camo) != null && stack.func_77973_b() instanceof ItemBlock) {
            return ((ItemBlock)stack.func_77973_b()).field_150939_a.func_149720_d(world, x, y, z);
        }
        return super.func_149720_d(world, x, y, z);
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer entity) {
        IProjector proj = this.getProjector((IBlockAccess)world, x, y, z);
        if (proj != null) {
            for (ItemStack stack : proj.getModuleStacks(proj.getModuleSlots())) {
                if (!((IFieldModule)stack.func_77973_b()).onCollideWithForcefield(world, x, y, z, (Entity)entity, stack)) continue;
                return;
            }
        }
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileForceField) {
            IProjector proj = this.getProjector((IBlockAccess)world, x, y, z);
            if (proj == null) {
                return;
            }
            for (ItemStack module : proj.getModuleStacks(proj.getModuleSlots())) {
                if (!((IFieldModule)module.func_77973_b()).onCollideWithForcefield(world, x, y, z, entity, module)) continue;
                return;
            }
            if (Vector3D.distance(tile, entity.field_70165_t + 0.4, entity.field_70163_u + 0.4, entity.field_70161_v + 0.4) >= 0.5) {
                return;
            }
            IBiometricIdentifier bio = proj.getBiometricIdentifier();
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).func_70690_d(new PotionEffect(Potion.field_76431_k.func_76396_c(), 80, 3));
                ((EntityLiving)entity).func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 20, 1));
                if (entity instanceof EntityPlayer) {
                    EntityPlayer pl = (EntityPlayer)entity;
                    if (pl.func_70093_af()) {
                        if (pl.field_71075_bZ.field_75098_d) {
                            return;
                        }
                        if (bio != null && bio.isAccessGranted(pl.func_146103_bH().getName(), Permission.WARP)) {
                            return;
                        }
                    }
                    entity.func_70097_a(ItemModuleShock.SHOCK_SOURCE, 100.0f);
                }
            }
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        IProjector proj = this.getProjector((IBlockAccess)world, x, y, z);
        if (proj != null) {
            IBiometricIdentifier bio = proj.getBiometricIdentifier();
            List entities = world.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)((double)y + 0.9), (double)(z + 1)));
            for (EntityPlayer pl : entities) {
                if (pl == null || !pl.func_70093_af() || !pl.field_71075_bZ.field_75098_d && (bio == null || !bio.isAccessGranted(pl.func_146103_bH().getName(), Permission.WARP))) continue;
                return null;
            }
        }
        return AxisAlignedBB.func_72330_a((double)((double)x + 0.0625), (double)((double)y + 0.0625), (double)((double)z + 0.0625), (double)((double)x + 0.9375), (double)((double)y + 0.9375), (double)((double)z + 0.9375));
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileForceFieldProjector proj;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileForceField && (proj = ((TileForceField)tile).findProj()) != null) {
            return Math.min(proj.getModuleCount(ItemModuleGlow.class, new int[0]), 64) / 64 * 15;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int p_149646_5_) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileForceField) {
            ItemStack stack = ((TileForceField)tile).camo;
            try {
                return stack != null && ((ItemBlock)stack.func_77973_b()).field_150939_a.func_149646_a(world, x, y, z, p_149646_5_);
            }
            catch (Exception e) {
                System.out.println("Side Render Error: ForceFieldBlock");
                e.printStackTrace();
                return true;
            }
        }
        return super.func_149646_a(world, x, y, z, p_149646_5_);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return RenderForceFieldHandler.RENDER_ID;
    }

    public void func_149651_a(IIconRegister reg) {
        this.field_149761_L = reg.func_94245_a("mffs:forceField");
    }

    public int func_149701_w() {
        return 1;
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileForceField();
    }
}

