/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mffs.common.items.modules.projector;

import com.builtbroken.mc.core.registry.implement.IRecipeContainer;
import com.builtbroken.mffs.api.IFieldInteraction;
import com.builtbroken.mffs.api.vector.Vector3D;
import com.builtbroken.mffs.common.items.modules.BaseModule;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemModuleArray
extends BaseModule
implements IRecipeContainer {
    public void genRecipes(List<IRecipe> list) {
        list.add(this.newShapedRecipe(this, new Object[]{" F ", "DFD", " F ", Character.valueOf('F'), Item.field_150901_e.func_82594_a("mffs:focusMatrix"), Character.valueOf('D'), Items.field_151045_i}));
    }

    public ItemModuleArray() {
        this.setCost(3.0f);
    }

    @Override
    public Set<Vector3D> onPreCalculate(IFieldInteraction projector, Set<Vector3D> fieldBlocks) {
        HashSet<Vector3D> newField = new HashSet<Vector3D>(fieldBlocks);
        HashSet<Vector3D> originalField = new HashSet<Vector3D>(fieldBlocks);
        HashMap<ForgeDirection, Integer> longestDirectional = this.getDirectionWidthMap(originalField);
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            int copyAmount = projector.getSidedModuleCount(this.getClass(), direction);
            int directionalDisplacement = Math.abs(longestDirectional.get(direction)) + Math.abs(longestDirectional.get(direction.getOpposite())) + 1;
            for (int i = 0; i < copyAmount; ++i) {
                int directionalDisplacementScale = directionalDisplacement * (i + 1);
                for (Vector3D originalFieldBlock : originalField) {
                    Vector3D newFieldBlock = originalFieldBlock.clone().translate(direction.offsetX, direction.offsetY, direction.offsetZ).scale(directionalDisplacementScale);
                    newField.add(newFieldBlock);
                }
            }
        }
        return newField;
    }

    public HashMap<ForgeDirection, Integer> getDirectionWidthMap(Set<Vector3D> field) {
        HashMap<ForgeDirection, Integer> longestDirectional = new HashMap<ForgeDirection, Integer>();
        longestDirectional.put(ForgeDirection.DOWN, 0);
        longestDirectional.put(ForgeDirection.UP, 0);
        longestDirectional.put(ForgeDirection.NORTH, 0);
        longestDirectional.put(ForgeDirection.SOUTH, 0);
        longestDirectional.put(ForgeDirection.WEST, 0);
        longestDirectional.put(ForgeDirection.EAST, 0);
        for (Vector3D fieldPosition : field) {
            if (fieldPosition.x > 0.0 && fieldPosition.x > (double)longestDirectional.get(ForgeDirection.EAST).intValue()) {
                longestDirectional.put(ForgeDirection.EAST, (int)Math.floor(fieldPosition.x));
            } else if (fieldPosition.x < 0.0 && fieldPosition.x < (double)longestDirectional.get(ForgeDirection.WEST).intValue()) {
                longestDirectional.put(ForgeDirection.WEST, (int)Math.floor(fieldPosition.x));
            }
            if (fieldPosition.y > 0.0 && fieldPosition.y > (double)longestDirectional.get(ForgeDirection.UP).intValue()) {
                longestDirectional.put(ForgeDirection.UP, (int)Math.floor(fieldPosition.y));
            } else if (fieldPosition.y < 0.0 && fieldPosition.y < (double)longestDirectional.get(ForgeDirection.DOWN).intValue()) {
                longestDirectional.put(ForgeDirection.DOWN, (int)Math.floor(fieldPosition.y));
            }
            if (fieldPosition.z > 0.0 && fieldPosition.z > (double)longestDirectional.get(ForgeDirection.SOUTH).intValue()) {
                longestDirectional.put(ForgeDirection.SOUTH, (int)Math.floor(fieldPosition.z));
                continue;
            }
            if (!(fieldPosition.z < 0.0) || !(fieldPosition.z < (double)longestDirectional.get(ForgeDirection.NORTH).intValue())) continue;
            longestDirectional.put(ForgeDirection.NORTH, (int)Math.floor(fieldPosition.z));
        }
        return longestDirectional;
    }

    @Override
    public float getFortronCost(float amplifier) {
        return super.getFortronCost(amplifier) + super.getFortronCost(amplifier) * amplifier / 100.0f;
    }
}

