/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mffs.common.items.card.id;

import com.builtbroken.mc.api.data.IPacket;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.core.network.packet.PacketPlayerItem;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mffs.MFFS;
import com.builtbroken.mffs.api.card.ICardIdentification;
import com.builtbroken.mffs.api.security.Permission;
import com.builtbroken.mffs.api.utils.Util;
import com.builtbroken.mffs.common.items.card.ItemCardBlank;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.LanguageRegistry;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemCardID
extends ItemCardBlank
implements ICardIdentification,
IPacketIDReceiver {
    public boolean func_77644_a(ItemStack stack, EntityLivingBase entity, EntityLivingBase hit) {
        if (entity instanceof EntityPlayer) {
            this.setUsername(stack, ((EntityPlayer)entity).func_146103_bH().getName());
        }
        return false;
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer usr, List list, boolean dummy) {
        String user = this.getUsername(stack);
        list.add(user != null && !user.isEmpty() ? LanguageRegistry.instance().getStringLocalization("info.cardIdentification.text") + " " + user : LanguageRegistry.instance().getStringLocalization("info.cardIdentification.empty"));
        String tooltip = "";
        for (Permission perm : Permission.values()) {
            if (!this.hasPermission(stack, perm)) continue;
            tooltip = tooltip + (tooltip.isEmpty() ? "" : ", ") + LanguageRegistry.instance().getStringLocalization("gui." + perm.name() + ".name");
        }
        if (tooltip != null && tooltip.length() > 0) {
            list.addAll(Util.sepString(tooltip, 25));
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                this.setUsername(stack, player.func_146103_bH().getName());
            } else {
                player.openGui((Object)MFFS.INSTANCE, 1, world, player.field_71071_by.field_70461_c, 0, 0);
            }
        }
        return stack;
    }

    @Override
    public boolean hasPermission(ItemStack paramItemStack, Permission paramPermission) {
        return Util.getTag(paramItemStack).func_74767_n("mffs_permission_" + paramPermission.ordinal());
    }

    @Override
    public boolean addPermission(ItemStack paramItemStack, Permission paramPermission) {
        Util.getTag(paramItemStack).func_74757_a("mffs_permission_" + paramPermission.ordinal(), true);
        return false;
    }

    @Override
    public boolean removePermission(ItemStack paramItemStack, Permission paramPermission) {
        Util.getTag(paramItemStack).func_74757_a("mffs_permission_" + paramPermission.ordinal(), false);
        return false;
    }

    @Override
    public String getUsername(ItemStack paramItemStack) {
        return Util.getTag(paramItemStack).func_74779_i("mffs_name");
    }

    @Override
    public void setUsername(ItemStack paramItemStack, String paramString) {
        Util.getTag(paramItemStack).func_74778_a("mffs_name", paramString);
    }

    public void sendUserNamePacket(EntityPlayer player, String paramString) {
        PacketPlayerItem packet = new PacketPlayerItem(player.field_71071_by.field_70461_c, new Object[]{0});
        ByteBufUtils.writeUTF8String((ByteBuf)packet.data(), (String)paramString);
        Engine.packetHandler.sendToServer((IPacket)packet);
    }

    public void sendPermPacket(EntityPlayer player, int permID, boolean state) {
        Permission perm = Permission.getPerm(permID);
        if (perm != null) {
            PacketPlayerItem packet = new PacketPlayerItem(player.field_71071_by.field_70461_c, new Object[]{1});
            packet.data().writeInt(permID);
            packet.data().writeBoolean(state);
            Engine.packetHandler.sendToServer((IPacket)packet);
        }
    }

    @Override
    public void genRecipes(List<IRecipe> list) {
        list.add(this.newShapedRecipe(this, new Object[]{" W ", "WCW", " W ", Character.valueOf('W'), Items.field_151137_ax, Character.valueOf('C'), Item.field_150901_e.func_82594_a("mffs:cardBlank")}));
    }

    public boolean read(ByteBuf buf, int id, EntityPlayer player, PacketType type) {
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == this) {
            if (id == 0) {
                String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
                ItemStack stack = player.func_70694_bm();
                this.setUsername(stack, name);
                player.field_71069_bz.func_75142_b();
                return true;
            }
            if (id == 1) {
                int permID = buf.readInt();
                Permission perm = Permission.getPerm(permID);
                if (perm != null) {
                    NBTTagCompound tag = Util.getTag(player.func_70694_bm());
                    tag.func_74757_a("mffs_permission_" + permID, buf.readBoolean());
                }
                player.field_71069_bz.func_75142_b();
                return true;
            }
        }
        return false;
    }
}

