/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mffs.common.items;

import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.lib.helper.recipe.UniversalRecipe;
import com.builtbroken.mffs.MFFS;
import com.builtbroken.mffs.api.IBlockFrequency;
import com.builtbroken.mffs.api.card.ICoordLink;
import com.builtbroken.mffs.api.fortron.FrequencyGrid;
import com.builtbroken.mffs.api.fortron.IFortronFrequency;
import com.builtbroken.mffs.api.security.IInterdictionMatrix;
import com.builtbroken.mffs.api.security.Permission;
import com.builtbroken.mffs.api.utils.MatrixHelper;
import com.builtbroken.mffs.api.utils.UnitDisplay;
import com.builtbroken.mffs.api.utils.Util;
import com.builtbroken.mffs.api.vector.Vector3D;
import com.builtbroken.mffs.common.items.card.ItemCardFrequency;
import com.builtbroken.mffs.prefab.blocks.MFFSMachine;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class RemoteController
extends ItemCardFrequency
implements ICoordLink {
    private Location link;

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer usr, List list, boolean dummy) {
        super.func_77624_a(stack, usr, list, dummy);
        Location link = this.getLink(stack);
        if (link != null) {
            World world = link.world;
            Block block = link.getBlock((IBlockAccess)world);
            if (block != null) {
                list.add(LanguageRegistry.instance().getStringLocalization("info.item.linkedWith") + " " + block.func_149732_F());
            }
            list.add(link.xi() + ", " + link.yi() + ", " + link.zi());
            list.add(LanguageRegistry.instance().getStringLocalization("info.item.dimension") + " " + world.func_72912_H().func_76065_j());
        } else {
            super.func_77624_a(stack, usr, list, dummy);
            list.add(EnumChatFormatting.RED + LanguageRegistry.instance().getStringLocalization("info.item.notLinked"));
        }
    }

    @Override
    public void genRecipes(List<IRecipe> list) {
        list.add(this.newShapedRecipe(this, new Object[]{"WWW", "SBS", "SBS", Character.valueOf('W'), UniversalRecipe.WIRE.get(), Character.valueOf('S'), UniversalRecipe.PRIMARY_METAL.get(), Character.valueOf('B'), UniversalRecipe.BATTERY.get()}));
    }

    @Override
    public void setLink(ItemStack paramItemStack, Location paramVectorWorld) {
        NBTTagCompound tag = Util.getTag(paramItemStack);
        this.link = paramVectorWorld;
        tag.func_74782_a("mffs_link", (NBTBase)paramVectorWorld.toNBT());
    }

    @Override
    public Location getLink(ItemStack paramItemStack) {
        NBTTagCompound tag = Util.getTag(paramItemStack);
        if (!tag.func_74764_b("mffs_link")) {
            return null;
        }
        if (this.link == null) {
            if (tag.func_74764_b("id")) {
                tag.func_74768_a("dimension", tag.func_74762_e("id"));
                tag.func_82580_o("id");
            }
            this.link = new Location(tag.func_74775_l("mffs_link"));
            return this.link;
        }
        return this.link;
    }

    @Override
    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Location coord;
        Block block;
        if (!world.field_72995_K && player.func_70093_af() && (block = (coord = new Location(world, (double)x, (double)y, (double)z)).getBlock()) != null && block instanceof MFFSMachine) {
            this.setLink(stack, coord);
            player.func_145747_a((IChatComponent)new ChatComponentText(String.format(LanguageRegistry.instance().getStringLocalization("message.remoteController.linked").replace("%p", x + ", " + y + ", " + z).replace("%q", block.func_149732_F()), new Object[0])));
        }
        return true;
    }

    @Override
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer usr) {
        Block block;
        Location position;
        if (!usr.func_70093_af() && !world.field_72995_K && (position = this.getLink(stack)) != null && (block = position.getBlock((IBlockAccess)world)) != null) {
            Chunk chunk = world.func_72938_d(position.xi(), position.zi());
            Set<IBlockFrequency> freq = FrequencyGrid.instance().get();
            Vector3D usrLoc = new Vector3D((Entity)usr);
            IInterdictionMatrix matrix = MatrixHelper.findMatrix(world, usrLoc, freq);
            if (chunk != null && chunk.field_76636_d && (matrix == null || MatrixHelper.hasPermission(matrix, PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, usr) || MatrixHelper.hasPermission(matrix, usr.func_146103_bH().getName(), Permission.REMOTE_CONTROL))) {
                float requiredEnergy = (float)usrLoc.distance(position.xi(), position.yi(), position.zi()) * 10.0f;
                int receivedEnergy = 0;
                int freq_ = this.getFrequency(stack);
                Iterator<IBlockFrequency> it$ = freq.iterator();
                while (it$.hasNext()) {
                    IBlockFrequency b_freq = it$.next();
                    if (!(b_freq instanceof IFortronFrequency) || usrLoc.distance(((TileEntity)b_freq).field_145851_c, ((TileEntity)b_freq).field_145848_d, ((TileEntity)b_freq).field_145849_e) > 50.0) {
                        it$.remove();
                        continue;
                    }
                    if (b_freq.getFrequency() == freq_) continue;
                    it$.remove();
                }
                Vector3D center = usrLoc.clone().add(new Vector3D(0.0, (double)usr.func_70047_e() - 0.2, 0.0));
                for (IBlockFrequency bl : freq) {
                    IFortronFrequency fortronTile = (IFortronFrequency)bl;
                    int consumedEnergy = fortronTile.requestFortron((int)Math.ceil(requiredEnergy / (float)freq.size()), true);
                    if (consumedEnergy > 0) {
                        MFFS.proxy.registerBeamEffect(world, center, new Vector3D((TileEntity)fortronTile).add(0.5), 0.6f, 0.6f, 1.0f, 20);
                        receivedEnergy += consumedEnergy;
                    }
                    if (!((float)receivedEnergy >= requiredEnergy)) continue;
                    try {
                        block.func_149727_a(world, position.xi(), position.yi(), position.zi(), usr, 0, 0.0f, 0.0f, 0.0f);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return stack;
                }
                usr.func_145747_a((IChatComponent)new ChatComponentText(LanguageRegistry.instance().getStringLocalization("message.remoteController.fail").replaceAll("%p", UnitDisplay.getDisplay(requiredEnergy, UnitDisplay.Unit.JOULES))));
            }
        }
        return stack;
    }
}

