/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mffs.api.utils;

import com.builtbroken.mc.imp.transform.region.Cube;
import com.builtbroken.mffs.api.IBlockFrequency;
import com.builtbroken.mffs.api.fortron.FrequencyGrid;
import com.builtbroken.mffs.api.security.IBiometricIdentifier;
import com.builtbroken.mffs.api.security.IInterdictionMatrix;
import com.builtbroken.mffs.api.security.Permission;
import com.builtbroken.mffs.api.vector.Vector3D;
import com.builtbroken.mffs.common.items.modules.interdiction.ItemModuleBlockAccess;
import com.builtbroken.mffs.common.items.modules.interdiction.ItemModuleBlockAlter;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class MatrixHelper {
    public static IInterdictionMatrix findMatrix(World world, Vector3D vec, Set<IBlockFrequency> seq) {
        for (IBlockFrequency freq : seq) {
            TileEntity entity = (TileEntity)freq;
            if (!(entity instanceof IInterdictionMatrix) || world != entity.func_145831_w()) continue;
            IInterdictionMatrix matrix = (IInterdictionMatrix)freq;
            Cube range = matrix.getActionRange();
            if (!matrix.isActive() || !range.isWithin(vec.x, vec.y, vec.z)) continue;
            return matrix;
        }
        return null;
    }

    public static IInterdictionMatrix findMatrix(World world, Vector3D vec) {
        for (IBlockFrequency freq : FrequencyGrid.instance().get()) {
            TileEntity tile = (TileEntity)freq;
            if (!(tile instanceof IInterdictionMatrix) || world != tile.func_145831_w()) continue;
            IInterdictionMatrix matrix = (IInterdictionMatrix)freq;
            Cube range = matrix.getActionRange();
            if (!matrix.isActive() || !range.isWithin(vec.x, vec.y, vec.z)) continue;
            return matrix;
        }
        return null;
    }

    public static boolean hasPermission(IInterdictionMatrix matrix, String name, Permission perm) {
        IBiometricIdentifier bio = matrix.getBiometricIdentifier();
        if (bio != null && matrix.isActive()) {
            return bio.isAccessGranted(name, perm);
        }
        return true;
    }

    public static boolean hasPermission(IInterdictionMatrix matrix, PlayerInteractEvent.Action action, EntityPlayer player) {
        boolean perm = true;
        if (matrix.getModuleCount(ItemModuleBlockAccess.class, new int[0]) > 0 && action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            perm = MatrixHelper.hasPermission(matrix, player.func_146103_bH().getName(), Permission.BLOCK_ACCESS);
        }
        if (perm && matrix.getModuleCount(ItemModuleBlockAlter.class, new int[0]) > 0 && (action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK || player.func_71045_bC() != null)) {
            perm = MatrixHelper.hasPermission(matrix, player.func_146103_bH().getName(), Permission.BLOCK_PLACE_ACCESS);
        }
        return perm;
    }
}

