/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mffs;

import com.builtbroken.mc.core.asm.ChunkSetBlockEvent;
import com.builtbroken.mffs.api.IBlockFrequency;
import com.builtbroken.mffs.api.fortron.FrequencyGrid;
import com.builtbroken.mffs.api.security.IInterdictionMatrix;
import com.builtbroken.mffs.api.security.Permission;
import com.builtbroken.mffs.api.utils.MatrixHelper;
import com.builtbroken.mffs.api.vector.Vector3D;
import com.builtbroken.mffs.common.items.modules.interdiction.ItemModuleAntiSpawn;
import com.builtbroken.mffs.content.field.BlockForceField;
import com.builtbroken.mffs.content.fluids.Fortron;
import com.builtbroken.mffs.content.interdiction.BlockInterdictionMatrix;
import com.builtbroken.mffs.content.projector.TileForceFieldProjector;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.FluidRegistry;

public class ForgeSubscribeHandler {
    private static final ChatComponentText ACTION_DENIED = new ChatComponentText("[InterdictionMatrix] You have no permission to do that!");

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void preTextureHook(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() == 0) {
            FluidRegistry.getFluid((int)Fortron.FLUID_ID).setIcons(event.map.func_94245_a("mffs:fortron"));
        }
    }

    @SubscribeEvent
    public void chunkModify(ChunkSetBlockEvent event) {
        if (event.world.field_72995_K || !(event.block instanceof BlockAir)) {
            return;
        }
        Vector3D vec = new Vector3D(event.x + (event.getChunk().field_76635_g << 4), event.y, event.z + (event.getChunk().field_76647_h << 4));
        for (IBlockFrequency freq : FrequencyGrid.instance().get()) {
            TileForceFieldProjector proj;
            if (!(freq instanceof TileForceFieldProjector) || ((TileEntity)freq).func_145831_w() != event.world || (proj = (TileForceFieldProjector)freq).getCalculatedField() == null || proj.markFieldUpdate || !proj.getCalculatedField().contains(vec)) continue;
            proj.markFieldUpdate = true;
            break;
        }
    }

    @SubscribeEvent
    public void playerInteraction(PlayerInteractEvent event) {
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.action != PlayerInteractEvent.Action.LEFT_CLICK_BLOCK) {
            return;
        }
        if (event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK && event.world.func_147439_a(event.x, event.y, event.z) instanceof BlockForceField) {
            event.setCanceled(true);
            return;
        }
        if (event.entityPlayer.field_71075_bZ.field_75098_d) {
            return;
        }
        Vector3D vec = new Vector3D(event.x, event.y, event.z);
        IInterdictionMatrix matrix = MatrixHelper.findMatrix(event.world, vec);
        if (matrix != null) {
            Block block = vec.getBlock((IBlockAccess)event.world);
            if (block instanceof BlockInterdictionMatrix && MatrixHelper.hasPermission(matrix, event.entityPlayer.func_146103_bH().getName(), Permission.CONFIGURE)) {
                return;
            }
            if (!MatrixHelper.hasPermission(matrix, event.action, event.entityPlayer)) {
                event.entityPlayer.func_145747_a((IChatComponent)ACTION_DENIED);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void livingSpawnEvent(LivingSpawnEvent event) {
        if (event.world.field_72995_K || event.entity instanceof EntityPlayer) {
            return;
        }
        IInterdictionMatrix matrix = MatrixHelper.findMatrix(event.world, new Vector3D((Entity)event.entityLiving));
        if (matrix != null && matrix.getModuleCount(ItemModuleAntiSpawn.class, new int[0]) > 0 && matrix.getModuleCount(ItemModuleAntiSpawn.class, new int[0]) > 0) {
            event.setResult(Event.Result.DENY);
        }
    }
}

