/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.tile;

import com.mcmoddev.lib.container.IGuiProvider;
import com.mcmoddev.lib.container.IWidgetContainer;
import com.mcmoddev.lib.container.MMDContainer;
import com.mcmoddev.lib.container.gui.MMDGuiContainer;
import com.mcmoddev.lib.util.LoggingUtil;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MMDTileEntity
extends TileEntity
implements IGuiProvider,
IWidgetContainer {
    private static final String PARTIAL_SYNC_KEY = "partial_sync";

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getClientGui(int id, EntityPlayer player, World world, int x, int y, int z) {
        BlockPos pos = this.func_174877_v();
        if (world != this.field_145850_b || pos.func_177958_n() != x || pos.func_177956_o() != y || pos.func_177952_p() != z) {
            return null;
        }
        MMDContainer container = this.getServerGui(id, player, world, x, y, z);
        return container == null ? null : new MMDGuiContainer(this, player, container);
    }

    @Override
    public MMDContainer getServerGui(int id, EntityPlayer player, World world, int x, int y, int z) {
        BlockPos pos = this.func_174877_v();
        if (world != this.field_145850_b || pos.func_177958_n() != x || pos.func_177956_o() != y || pos.func_177952_p() != z) {
            return null;
        }
        return new MMDContainer(this, player);
    }

    @Override
    @Nullable
    public NBTTagCompound getGuiUpdateTag(boolean resetDirtyFlag) {
        return null;
    }

    @Override
    public void receiveGuiUpdateTag(NBTTagCompound compound) {
        this.readFromUpdateTag(compound);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = this.func_189517_E_();
        if (!tag.func_82582_d()) {
            LoggingUtil.logNbtMessage(this, "SPacket TAG", (NBTBase)tag);
            return new SPacketUpdateTileEntity(this.func_174877_v(), 42, tag);
        }
        return null;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189517_E_();
        this.writeToUpdateTag(compound);
        if (!compound.func_82582_d()) {
            LoggingUtil.logNbtMessage(this, "GET UPDATE NBT", (NBTBase)compound);
        }
        return compound;
    }

    protected void writeToUpdateTag(NBTTagCompound tag) {
        this.func_189515_b(tag);
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        LoggingUtil.logNbtMessage(this, "HANDLE UPDATE NBT", (NBTBase)tag);
        if (tag.func_150297_b(PARTIAL_SYNC_KEY, 10)) {
            this.readFromUpdateTag(tag.func_74775_l(PARTIAL_SYNC_KEY));
        } else {
            this.readFromUpdateTag(tag);
        }
    }

    protected void readFromUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    protected void sendToListeningClients(NBTTagCompound nbt) {
        ChunkPos cp = this.field_145850_b.func_175726_f(this.field_174879_c).func_76632_l();
        PlayerChunkMapEntry entry = ((WorldServer)this.field_145850_b).func_184164_w().func_187301_b(cp.field_77276_a, cp.field_77275_b);
        if (entry != null) {
            NBTTagCompound updateTag = new NBTTagCompound();
            updateTag.func_74782_a(PARTIAL_SYNC_KEY, (NBTBase)nbt);
            LoggingUtil.logNbtMessage(this, "SEND TO CLIENT", (NBTBase)nbt);
            entry.func_187267_a((Packet)new SPacketUpdateTileEntity(this.func_174877_v(), 42, updateTag));
        }
    }
}

