/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.oregen;

import com.mcmoddev.lib.oregen.FallbackGeneratorData;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class FallbackGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int dimension = world.field_73011_w.getDimension();
        ArrayList<WorldGenMinable> ores = new ArrayList<WorldGenMinable>(FallbackGeneratorData.getInstance().getSpawnsForDimension(dimension));
        if (dimension != -1 && dimension != 1) {
            ores.addAll(FallbackGeneratorData.getInstance().getSpawnsForDimension(Integer.MIN_VALUE));
        }
        int minY = this.getMinYForDimension(dimension);
        int maxY = this.getMaxYForDimension(dimension);
        for (WorldGenMinable ore : ores) {
            for (int i = 0; i < 8; ++i) {
                int pos_x = chunkX * 16 + random.nextInt(16);
                int pos_z = chunkZ * 16 + random.nextInt(16);
                int pos_y = minY + random.nextInt(maxY - minY);
                BlockPos p = new BlockPos(pos_x, pos_y, pos_z);
                ore.func_180709_b(world, random, p);
            }
        }
    }

    private int getMaxYForDimension(int dimension) {
        return dimension == -1 ? 126 : (dimension == 1 ? 256 : 80);
    }

    private int getMinYForDimension(int dimension) {
        return dimension == -1 || dimension == 1 ? 0 : 16;
    }
}

