/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.material;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.material.Material;
import org.apache.commons.lang3.text.WordUtils;

public class MMDMaterialType {
    private final Material vanillaType;
    private final MaterialType MMDLibType;
    private final List<VariantType> variants;
    private final String variantName;

    public MMDMaterialType(String name, MaterialType mmdType, VariantType ... types) {
        this.variantName = name;
        this.MMDLibType = mmdType;
        this.vanillaType = this.getVanillaTypeInternal();
        this.variants = new LinkedList<VariantType>();
        Arrays.asList(types).stream().forEach(this.variants::add);
    }

    public MaterialType getMaterialType() {
        return this.MMDLibType;
    }

    private Material getVanillaTypeInternal() {
        switch (this.MMDLibType) {
            case METAL: {
                return Material.field_151573_f;
            }
            case GEM: 
            case ROCK: {
                return Material.field_151576_e;
            }
            case MINERAL: {
                return Material.field_151577_b;
            }
            case WOOD: {
                return Material.field_151575_d;
            }
        }
        return Material.field_151578_c;
    }

    public Material getVanillaType() {
        return this.vanillaType;
    }

    private String buildVariantName() {
        StringBuilder x = new StringBuilder();
        this.variants.stream().forEach(var -> x.append(var.toCapString()));
        return x.toString();
    }

    private String buildFullMaterialTypeName() {
        StringBuilder x = new StringBuilder();
        x.append(this.buildVariantName());
        x.append(String.format("of {} ({})", this.MMDLibType.toString(), this.vanillaType.toString()));
        return WordUtils.capitalize((String)x.toString());
    }

    private String buildFullName() {
        return String.format("{} is {}", this.variantName, this.buildFullMaterialTypeName());
    }

    public String getVariantName() {
        return this.buildVariantName();
    }

    public String getFullName() {
        return this.buildFullName();
    }

    public String getFullVariantName() {
        return this.buildFullMaterialTypeName();
    }

    public boolean hasVanilla() {
        return this.variants.contains((Object)VariantType.VANILLA);
    }

    public boolean hasRare() {
        return this.variants.contains((Object)VariantType.RARE);
    }

    public boolean hasAlloy() {
        return this.variants.contains((Object)VariantType.ALLOY);
    }

    public boolean hasOreless() {
        return this.variants.contains((Object)VariantType.ORELESS);
    }

    public boolean hasSpecial() {
        return this.variants.contains((Object)VariantType.SPECIAL);
    }

    public static enum VariantType {
        VANILLA(1),
        ORELESS(2),
        ALLOY(4),
        RARE(8),
        NORMAL(16),
        SPECIAL(32);

        private int type;

        private VariantType(int type) {
            this.type = type;
        }

        public int value() {
            return this.type;
        }

        public String toString() {
            return super.toString().toLowerCase(Locale.getDefault());
        }

        public String toCapString() {
            return WordUtils.capitalize((String)this.toString());
        }
    }

    public static enum MaterialType {
        WOOD,
        ROCK,
        METAL,
        MINERAL,
        GEM,
        CRYSTAL;

    }
}

