/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.integration.plugins.thaumcraft;

import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.integration.plugins.thaumcraft.BaseAspectGetter;
import com.mcmoddev.lib.integration.plugins.thaumcraft.TCMaterial;
import com.mcmoddev.lib.material.MMDMaterial;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class TCSyncEvent
extends Event {
    private final IForgeRegistry<TCMaterial> registry;
    private final Map<String, ResourceLocation> nameMapping;

    public TCSyncEvent(IForgeRegistry<TCMaterial> regIn, Map<String, ResourceLocation> map) {
        this.registry = regIn;
        this.nameMapping = map;
    }

    public void register(TCMaterial materialIn) {
        this.nameMapping.putIfAbsent(materialIn.getName(), materialIn.getRegistryName());
        this.registry.register((IForgeRegistryEntry)materialIn);
    }

    private TCMaterial getNewMaterial(String materialName) {
        MMDMaterial base = Materials.getMaterialByName(materialName);
        return new TCMaterial(base, new BaseAspectGetter(base));
    }

    public TCMaterial getMaterial(String materialName) {
        return this.nameMapping.containsKey(materialName) ? (TCMaterial)this.registry.getValue(this.nameMapping.get(materialName)) : this.getNewMaterial(materialName);
    }

    public boolean hasMaterial(String materialName) {
        return this.nameMapping.containsKey(materialName);
    }
}

