/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.init;

import com.mcmoddev.lib.MMDLib;
import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.material.IMMDObject;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.material.MMDMaterialType;
import com.mcmoddev.lib.registry.CrusherRecipeRegistry;
import com.mcmoddev.lib.util.CheeseMath;
import com.mcmoddev.lib.util.Config;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;

public abstract class Recipes {
    protected static final String DEFAULT_ORESMELT_XP = "%01.2f";

    protected Recipes() {
        throw new IllegalAccessError("Not a instantiable class");
    }

    public static void init() {
        Recipes.initPureVanillaOredicts();
        Recipes.initPureVanillaCrusherRecipes();
        Recipes.initGeneralRecipes();
        Recipes.initModSpecificRecipes();
    }

    protected static void initPureVanillaOredicts() {
        OreDictionary.registerOre((String)"barsIron", (Block)Blocks.field_150411_aY);
        OreDictionary.registerOre((String)"bars", (Block)Blocks.field_150411_aY);
        OreDictionary.registerOre((String)"doorIron", (Item)Items.field_151139_aw);
        OreDictionary.registerOre((String)"door", (Item)Items.field_151139_aw);
        OreDictionary.registerOre((String)"doorWood", (Item)Items.field_179570_aq);
        OreDictionary.registerOre((String)"doorWood", (Item)Items.field_179567_at);
        OreDictionary.registerOre((String)"doorWood", (Item)Items.field_179569_ar);
        OreDictionary.registerOre((String)"doorWood", (Item)Items.field_179571_av);
        OreDictionary.registerOre((String)"doorWood", (Item)Items.field_179568_as);
        OreDictionary.registerOre((String)"doorWood", (Item)Items.field_179572_au);
        OreDictionary.registerOre((String)"door", (Item)Items.field_179570_aq);
        OreDictionary.registerOre((String)"door", (Item)Items.field_179567_at);
        OreDictionary.registerOre((String)"door", (Item)Items.field_179569_ar);
        OreDictionary.registerOre((String)"door", (Item)Items.field_179571_av);
        OreDictionary.registerOre((String)"door", (Item)Items.field_179568_as);
        OreDictionary.registerOre((String)"door", (Item)Items.field_179572_au);
    }

    protected static void initPureVanillaCrusherRecipes() {
        MMDLib.logger.debug("initPureVanillaCrusherRecipes()");
        CrusherRecipeRegistry.addNewCrusherRecipe("stone", new ItemStack(Blocks.field_150347_e, 1));
        CrusherRecipeRegistry.addNewCrusherRecipe(Blocks.field_150417_aV, new ItemStack(Blocks.field_150347_e, 1));
        CrusherRecipeRegistry.addNewCrusherRecipe(new ItemStack((Block)Blocks.field_150333_U, 1, 0), new ItemStack((Block)Blocks.field_150333_U, 1, 3));
        CrusherRecipeRegistry.addNewCrusherRecipe(new ItemStack((Block)Blocks.field_150333_U, 1, 5), new ItemStack((Block)Blocks.field_150333_U, 1, 3));
        CrusherRecipeRegistry.addNewCrusherRecipe("cobblestone", new ItemStack(Blocks.field_150351_n, 1));
        CrusherRecipeRegistry.addNewCrusherRecipe(Blocks.field_150341_Y, new ItemStack(Blocks.field_150351_n, 1));
        CrusherRecipeRegistry.addNewCrusherRecipe(new ItemStack(Blocks.field_150463_bK, 1, 0), new ItemStack(Blocks.field_150351_n, 1));
        CrusherRecipeRegistry.addNewCrusherRecipe(new ItemStack(Blocks.field_150463_bK, 1, 1), new ItemStack(Blocks.field_150351_n, 1));
        CrusherRecipeRegistry.addNewCrusherRecipe("gravel", new ItemStack((Block)Blocks.field_150354_m, 1));
        CrusherRecipeRegistry.addNewCrusherRecipe(Blocks.field_150322_A, new ItemStack((Block)Blocks.field_150354_m, 4));
        CrusherRecipeRegistry.addNewCrusherRecipe(new ItemStack((Block)Blocks.field_150333_U, 1, 1), new ItemStack((Block)Blocks.field_150354_m, 2));
        CrusherRecipeRegistry.addNewCrusherRecipe(Blocks.field_150359_w, new ItemStack((Block)Blocks.field_150354_m, 1));
        CrusherRecipeRegistry.addNewCrusherRecipe(Blocks.field_180395_cM, new ItemStack((Block)Blocks.field_150354_m, 4, 1));
        CrusherRecipeRegistry.addNewCrusherRecipe(new ItemStack((Block)Blocks.field_180389_cP, 1, 0), new ItemStack((Block)Blocks.field_150354_m, 2, 1));
        CrusherRecipeRegistry.addNewCrusherRecipe((Block)Blocks.field_150399_cn, new ItemStack((Block)Blocks.field_150354_m, 4, 1));
        CrusherRecipeRegistry.addNewCrusherRecipe(Blocks.field_150426_aN, new ItemStack(Items.field_151114_aO, 4));
        MMDMaterial lapis = Materials.getMaterialByName("lapis");
        CrusherRecipeRegistry.addNewCrusherRecipe("oreLapis", lapis.getItemStack(Names.INGOT, 8));
        CrusherRecipeRegistry.addNewCrusherRecipe("blockLapis", lapis.getItemStack(Names.INGOT, 9));
        MMDMaterial redstone = Materials.getMaterialByName("redstone");
        CrusherRecipeRegistry.addNewCrusherRecipe("oreRedstone", redstone.getItemStack(Names.POWDER, 8));
        CrusherRecipeRegistry.addNewCrusherRecipe("blockRedstone", redstone.getItemStack(Names.POWDER, 9));
        CrusherRecipeRegistry.addNewCrusherRecipe(Items.field_151120_aE, new ItemStack(Items.field_151102_aT, 2));
        CrusherRecipeRegistry.addNewCrusherRecipe(Blocks.field_189880_di, new ItemStack(Items.field_151100_aR, 9, 15));
        CrusherRecipeRegistry.addNewCrusherRecipe(Items.field_151103_aS, new ItemStack(Items.field_151100_aR, 3, 15));
        CrusherRecipeRegistry.addNewCrusherRecipe(Items.field_151072_bj, new ItemStack(Items.field_151065_br, 2));
        MMDMaterial quartz = Materials.getMaterialByName("quartz");
        CrusherRecipeRegistry.addNewCrusherRecipe("oreQuartz", quartz.getItemStack(Names.INGOT, 2));
        CrusherRecipeRegistry.addNewCrusherRecipe(Blocks.field_150371_ca, quartz.getItemStack(Names.INGOT, 4));
        CrusherRecipeRegistry.addNewCrusherRecipe(new ItemStack((Block)Blocks.field_150333_U, 1, 7), quartz.getItemStack(Names.INGOT, 2));
        CrusherRecipeRegistry.addNewCrusherRecipe(new ItemStack(Blocks.field_180397_cI, 1, 0), new ItemStack(Items.field_179562_cC, 4));
        CrusherRecipeRegistry.addNewCrusherRecipe(new ItemStack(Blocks.field_180397_cI, 1, 1), new ItemStack(Items.field_179562_cC, 9));
        CrusherRecipeRegistry.addNewCrusherRecipe(new ItemStack(Blocks.field_180397_cI, 1, 2), new ItemStack(Items.field_179562_cC, 8));
        CrusherRecipeRegistry.addNewCrusherRecipe(Blocks.field_180398_cJ, new ItemStack(Items.field_179563_cD, 5));
        CrusherRecipeRegistry.addNewCrusherRecipe(Blocks.field_180399_cE, new ItemStack(Items.field_151123_aH, 9));
        CrusherRecipeRegistry.addNewCrusherRecipe(Blocks.field_150343_Z, Materials.getMaterialByName("obsidian").getItemStack(Names.POWDER, 4));
    }

    protected static void initVanillaRecipes() {
    }

    protected static void initGeneralRecipes() {
        MMDLib.logger.debug("initGeneralRecipes()");
        for (MMDMaterial material : Materials.getAllMaterials()) {
            if (material.isEmpty()) continue;
            MMDLib.logger.debug("-> material {}", (Object)material.getCapitalizedName());
            Recipes.makePowderRecipes(material);
            Recipes.makeIngotRecipes(material);
            Recipes.makeNuggetRecipes(material);
            Recipes.makeSimpleRecipes(material);
            Recipes.makeModRecipes(material);
            if (material.hasItem(Names.ROD)) {
                Recipes.makeCrossbowRecipes(material);
                Recipes.makeBowRecipes(material);
            }
            if (material.hasItem(Names.INGOT)) {
                Recipes.generateBaseTools(material);
            }
            Recipes.furnaceSpecial(material);
        }
    }

    private static void makeBowRecipes(@Nonnull MMDMaterial material) {
        float baseXP = Float.parseFloat(String.format(Locale.ENGLISH, DEFAULT_ORESMELT_XP, Float.valueOf(material.getOreSmeltXP())));
        float nuggetXP = Float.parseFloat(String.format(DEFAULT_ORESMELT_XP, Float.valueOf(baseXP / 9.0f)));
        MMDLib.logger.debug("--> makeBowRecipes({})", (Object)material);
        if (Recipes.isMMDItem(material, Names.ARROW)) {
            Recipes.addFurnaceRecipe(material.getItemStack(Names.ARROW), material.getItemStack(Names.NUGGET, 1), nuggetXP);
        }
        if (Recipes.isMMDItem(material, Names.BOW)) {
            Recipes.addFurnaceRecipe(material.getItemStack(Names.BOW), material.getItemStack(Names.INGOT, 1), baseXP);
        }
    }

    private static void makeCrossbowRecipes(@Nonnull MMDMaterial material) {
        float baseXP = Float.parseFloat(String.format(Locale.ENGLISH, DEFAULT_ORESMELT_XP, Float.valueOf(material.getOreSmeltXP())));
        float nuggetXP = Float.parseFloat(String.format(DEFAULT_ORESMELT_XP, Float.valueOf(baseXP / 9.0f)));
        MMDLib.logger.debug("--> makeCrossbowRecipes({})", (Object)material);
        if (material.hasItem(Names.GEAR) && material.hasItem(Names.CROSSBOW)) {
            int count = CheeseMath.getIngotCount(material, material.getItemStack(Names.CROSSBOW));
            Recipes.addFurnaceRecipe(material.getItemStack(Names.CROSSBOW), material.getItemStack(Names.INGOT, count), baseXP);
        }
        if (material.hasItem(Names.BOLT)) {
            Recipes.addFurnaceRecipe(material.getItemStack(Names.BOLT), material.getItemStack(Names.NUGGET, 2), nuggetXP);
        }
    }

    private static void makeNuggetRecipes(@Nonnull MMDMaterial material) {
        float baseXP = Float.parseFloat(String.format(Locale.ENGLISH, DEFAULT_ORESMELT_XP, Float.valueOf(material.getOreSmeltXP())));
        float nuggetXP = Float.parseFloat(String.format(Locale.ENGLISH, DEFAULT_ORESMELT_XP, Float.valueOf(baseXP / 9.0f)));
        String oreDictName = material.getCapitalizedName();
        MMDLib.logger.debug("--> makeNuggetRecipes({})", (Object)material);
        if (material.hasItem(Names.NUGGET)) {
            if (Recipes.isMMDBlock(material, Names.BUTTON)) {
                Recipes.addFurnaceRecipe(material.getBlockItemStack(Names.BUTTON), material.getItemStack(Names.NUGGET, 2), nuggetXP);
            }
            if (material.hasItem(Names.ROD)) {
                int cheeseQty = CheeseMath.getNuggetCount(material, material.getItemStack(Names.ROD));
                ItemStack out = cheeseQty >= 9 ? material.getItemStack(Names.INGOT) : (cheeseQty > 0 ? material.getItemStack(Names.NUGGET) : ItemStack.field_190927_a);
                float xp = nuggetXP;
                if (!out.func_190926_b()) {
                    if (cheeseQty >= 9) {
                        cheeseQty /= 9;
                        xp = baseXP;
                    }
                    out.func_190920_e(cheeseQty);
                    Recipes.addFurnaceRecipe(material.getItemStack(Names.ROD), out, xp);
                } else {
                    MMDLib.logger.debug("Rods per craft set to {} - got {} nuggets when trying to generate a cheese recipe, stopping it from happening (material {})", (Object)Config.Options.rodQuantity(), (Object)cheeseQty, (Object)material.getName());
                }
            }
            if (material.hasItem(Names.POWDER) && material.hasItem(Names.SMALLPOWDER) && !material.getName().equals("coal") && !material.getName().equals("charcoal")) {
                Recipes.addFurnaceRecipe(material.getItemStack(Names.SMALLPOWDER), material.getItemStack(Names.NUGGET, 1), nuggetXP);
                CrusherRecipeRegistry.addNewCrusherRecipe("nugget" + oreDictName, material.getItemStack(Names.SMALLPOWDER, 1));
            }
        }
        if (material.hasItem(Names.SMALLBLEND)) {
            Recipes.addFurnaceRecipe(material.getItemStack(Names.SMALLBLEND), material.getItemStack(Names.NUGGET, 1), nuggetXP);
        }
    }

    private static void makeModRecipes(@Nonnull MMDMaterial material) {
        if (material.hasItem(Names.GEAR) && material.hasItem(Names.INGOT)) {
            int resCount = CheeseMath.getNuggetCount(material, material.getItemStack(Names.GEAR));
            float ingotXP = Float.parseFloat(String.format(Locale.ENGLISH, DEFAULT_ORESMELT_XP, Float.valueOf(material.getOreSmeltXP())));
            float nuggetXP = Float.parseFloat(String.format(Locale.ENGLISH, DEFAULT_ORESMELT_XP, Float.valueOf(ingotXP / 9.0f)));
            MMDLib.logger.debug("--> makeModRecipes({})", (Object)material);
            if (resCount < 9 && resCount > 0) {
                Recipes.addFurnaceRecipe(new ItemStack(material.getItem(Names.GEAR)), material.getItemStack(Names.NUGGET, resCount), nuggetXP);
            } else if (resCount >= 9) {
                Recipes.addFurnaceRecipe(new ItemStack(material.getItem(Names.GEAR)), material.getItemStack(Names.INGOT, resCount / 9), ingotXP);
            } else {
                MMDLib.logger.debug("Gears Per Craft set to {} - got a result nugget count of {} when trying to make the cheese recipe for Gears (material {})", (Object)Config.Options.gearQuantity(), (Object)resCount, (Object)material.getName());
            }
        }
    }

    private static void makeSimpleRecipes(@Nonnull MMDMaterial material) {
        float baseXP = Float.parseFloat(String.format(Locale.ENGLISH, DEFAULT_ORESMELT_XP, Float.valueOf(material.getOreSmeltXP())));
        float nuggetXP = Float.parseFloat(String.format(Locale.ENGLISH, DEFAULT_ORESMELT_XP, Float.valueOf(baseXP / 9.0f)));
        MMDLib.logger.debug("--> makeSimpleRecipes({})", (Object)material);
        if (material.hasBlock(Names.BLOCK) && material.hasItem(Names.SLAB)) {
            Recipes.addFurnaceRecipe(material.getItemStack(Names.SLAB), material.getItemStack(Names.NUGGET, 4), nuggetXP);
        }
        if (material.hasItem(Names.ROD) && material.hasBlock(Names.LEVER)) {
            Recipes.addFurnaceRecipe(material.getBlockItemStack(Names.LEVER), material.getItemStack(Names.INGOT, 1), baseXP);
        }
        if (material.hasBlock(Names.WALL)) {
            Recipes.addFurnaceRecipe(material.getBlockItemStack(Names.WALL), material.getBlockItemStack(Names.BLOCK, 1), 0.0f);
        }
        TreeMap<Names, Integer> stuff = new TreeMap<Names, Integer>();
        stuff.put(Names.PRESSURE_PLATE, 2);
        stuff.put(Names.DOOR, 2);
        stuff.put(Names.TRAPDOOR, 4);
        stuff.put(Names.HORSE_ARMOR, 6);
        stuff.put(Names.FISHING_ROD, 1);
        stuff.entrySet().stream().filter(ent -> Recipes.isMMDBlock(material, (Names)((Object)((Object)ent.getKey())))).forEach(ent -> Recipes.addFurnaceRecipe(material.getBlockItemStack((Names)((Object)((Object)ent.getKey()))), material.getItemStack(Names.INGOT, (int)((Integer)ent.getValue())), baseXP));
        if (material.hasBlock(Names.PLATE) && Recipes.isMMDBlock(material, Names.PLATE)) {
            int nuggetCount = CheeseMath.getNuggetCount(material, material.getBlockItemStack(Names.PLATE));
            if (nuggetCount > 9) {
                Recipes.addFurnaceRecipe(material.getBlockItemStack(Names.PLATE), material.getItemStack(Names.INGOT, CheeseMath.getIngotCount(material, material.getItemStack(Names.PLATE))), nuggetXP);
            } else if (nuggetCount > 0) {
                Recipes.addFurnaceRecipe(material.getBlockItemStack(Names.PLATE), material.getItemStack(Names.NUGGET, nuggetCount), baseXP);
            } else {
                MMDLib.logger.debug("Plates Per Craft set to {} - got a result nugget count of {} when trying to make the cheese recipe for plates (material {})", (Object)Config.Options.plateQuantity(), (Object)nuggetCount, (Object)material.getName());
            }
        }
        if (Recipes.isMMDBlock(material, Names.BARS)) {
            Recipes.addFurnaceRecipe(material.getBlockItemStack(Names.BARS), material.getItemStack(Names.NUGGET, 3), nuggetXP);
        }
    }

    private static void makeIngotRecipes(@Nonnull MMDMaterial material) {
        float oreSmeltXP = material.getOreSmeltXP();
        MMDLib.logger.debug("--> makeIngotRecipes({})", (Object)material);
        if (material.hasItem(Names.INGOT)) {
            if (material.hasOre()) {
                Recipes.addFurnaceRecipe(material.getBlockItemStack(Names.ORE), material.getItemStack(Names.INGOT, 1), oreSmeltXP);
            } else if (material.hasBlend()) {
                Recipes.addFurnaceRecipe(material.getItemStack(Names.BLEND), material.getItemStack(Names.INGOT, 1), oreSmeltXP);
            }
            if (material.hasItem(Names.POWDER)) {
                if (material.getName().equals("charcoal") || material.getName().equals("coal")) {
                    return;
                }
                ItemStack ingot = material.getItemStack(Names.INGOT);
                ItemStack powder = material.getItemStack(Names.POWDER);
                Recipes.addFurnaceRecipe(powder, ingot, oreSmeltXP);
            }
        }
    }

    private static void makePowderRecipes(@Nonnull MMDMaterial material) {
        String oreDictName = material.getCapitalizedName();
        MMDLib.logger.debug("--> makePowderRecipes({})", (Object)material);
        if (material.hasItem(Names.POWDER)) {
            Recipes.crushOre(material, oreDictName);
            Recipes.crushIngot(material, oreDictName);
            Recipes.crushBlock(material, oreDictName);
            Recipes.doSmallPowder(material, oreDictName);
        }
    }

    private static void crushOre(@Nonnull MMDMaterial material, @Nonnull String oreDictName) {
        if (material.hasOre() || material.hasBlock(Names.ORE)) {
            CrusherRecipeRegistry.addNewCrusherRecipe("ore" + oreDictName, material.getItemStack(Names.POWDER, Config.Options.twoDustDrop() ? 2 : 1));
        }
    }

    private static void crushIngot(@Nonnull MMDMaterial material, @Nonnull String oreDictName) {
        if (material.hasItem(Names.INGOT)) {
            if (material.getName().equals("charcoal") || material.getName().equals("coal")) {
                CrusherRecipeRegistry.addNewCrusherRecipe(material.getItemStack(Names.INGOT), material.getItemStack(Names.POWDER, 1));
            } else {
                CrusherRecipeRegistry.addNewCrusherRecipe("ingot" + oreDictName, material.getItemStack(Names.POWDER, 1));
            }
        }
    }

    private static void crushBlock(@Nonnull MMDMaterial material, @Nonnull String oreDictName) {
        if (material.hasBlock(Names.BLOCK)) {
            CrusherRecipeRegistry.addNewCrusherRecipe("block" + oreDictName, material.getItemStack(Names.POWDER, 9));
        }
    }

    private static void doSmallPowder(@Nonnull MMDMaterial material, @Nonnull String oreDictName) {
        if (material.hasItem(Names.SMALLPOWDER) && material.hasItem(Names.NUGGET)) {
            CrusherRecipeRegistry.addNewCrusherRecipe("nugget" + oreDictName, material.getItemStack(Names.SMALLPOWDER, 1));
        }
    }

    private static void generateBaseTools(@Nonnull MMDMaterial material) {
        MMDLib.logger.debug("--> generateBaseTools({})", (Object)material);
        if (Recipes.isMMDItem(material, Names.SHEARS)) {
            Recipes.addFurnaceRecipe(material.getItemStack(Names.SHEARS), material.getItemStack(Names.INGOT, 2), material.getOreSmeltXP());
        }
    }

    private static void addFurnaceRecipe(@Nonnull ItemStack input, @Nonnull ItemStack output, float experience) {
        Recipes.maybeRemoveRecipe(input);
        if (input.func_190926_b()) {
            return;
        }
        float actualXP = Math.max(FurnaceRecipes.func_77602_a().func_151398_b(output), experience);
        MMDLib.logger.debug("---> addFurnaceRecipe({}, {}, {})", (Object)input, (Object)output, (Object)Float.valueOf(experience));
        GameRegistry.addSmelting((ItemStack)input, (ItemStack)output, (float)actualXP);
    }

    public static void dumpFurnaceRecipes() {
        Map smeltingMap = FurnaceRecipes.func_77602_a().func_77599_b();
        smeltingMap.entrySet().forEach(ent -> {
            ItemStack res = FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)ent.getKey());
            float exp = FurnaceRecipes.func_77602_a().func_151398_b(res);
            MMDLib.logger.debug("Furnace Recipe, {} -> {} with {} exp", ent.getKey(), ent.getValue(), (Object)String.format(DEFAULT_ORESMELT_XP, Float.valueOf(exp)));
        });
    }

    private static ItemStack findMatchingItemStack(List<ItemStack> list, ItemStack match) {
        for (ItemStack item : list) {
            if (item.func_190916_E() != match.func_190916_E() || item.func_77952_i() != Short.MAX_VALUE && item.func_77952_i() != match.func_77952_i() && match.func_77952_i() != Short.MAX_VALUE || !item.func_77973_b().equals(match.func_77973_b())) continue;
            return item;
        }
        return ItemStack.field_190927_a;
    }

    private static void maybeRemoveRecipe(@Nonnull ItemStack forItem) {
        Map smeltingMap = FurnaceRecipes.func_77602_a().func_77599_b();
        ItemStack matcher = Recipes.findMatchingItemStack(smeltingMap.keySet().stream().collect(Collectors.toList()), forItem);
        if (matcher.func_190926_b()) {
            MMDLib.logger.debug(":--> maybeRemoveRecipe({}) - matcher is empty", (Object)forItem);
            return;
        }
        ItemStack output = smeltingMap.getOrDefault(matcher, ItemStack.field_190927_a);
        if (output.func_190926_b()) {
            MMDLib.logger.debug(":--> maybeRemoveRecipe({}) - output is empty", (Object)forItem);
        }
        FurnaceRecipes.func_77602_a().func_77599_b().remove(matcher, output);
    }

    protected static void furnaceSpecial(@Nonnull MMDMaterial material) {
        float baseXP = Float.parseFloat(String.format(Locale.ENGLISH, DEFAULT_ORESMELT_XP, Float.valueOf(material.getOreSmeltXP())));
        MMDLib.logger.debug("--> furnaceSpecial({})", (Object)material);
        if (Config.Options.furnaceCheese() && material.hasItem(Names.INGOT)) {
            List<Names> itemNames = Arrays.asList(Names.BOOTS, Names.HELMET, Names.SWORD, Names.SHOVEL, Names.PICKAXE, Names.HOE, Names.AXE, Names.LEGGINGS, Names.CHESTPLATE);
            itemNames.stream().filter(name -> material.hasItem((Names)((Object)name))).forEach(name -> {
                ItemStack target = material.getItemStack((Names)((Object)name));
                target.func_77964_b(Short.MAX_VALUE);
                Recipes.maybeRemoveRecipe(target);
                int outCount = CheeseMath.getIngotCount(material, target);
                MMDLib.logger.debug("!--> furnace cheese - {} :: {} @ {} :: {}", (Object)name, (Object)Names.INGOT, (Object)outCount, (Object)Float.valueOf(baseXP));
                Recipes.addFurnaceRecipe(material.getItemStack((Names)((Object)name)), material.getItemStack(Names.INGOT, outCount), baseXP);
            });
            if (material.hasItem(Names.CRACKHAMMER)) {
                Recipes.addFurnaceRecipe(material.getItemStack(Names.CRACKHAMMER), material.getBlockItemStack(Names.BLOCK, 1), 0.0f);
            }
        }
    }

    private static void initModSpecificRecipes() {
        for (MMDMaterial material : Materials.getAllMaterials()) {
            if (material.isEmpty()) continue;
            MMDLib.logger.debug("-> initModSpecificRecipes({})", (Object)material);
            if (!Config.Options.isModEnabled("ic2")) continue;
            if (Recipes.isMMDItem(material, Names.CRUSHED) && material.hasItem(Names.INGOT)) {
                Recipes.addFurnaceRecipe(material.getItemStack(Names.CRUSHED), material.getItemStack(Names.INGOT), material.getOreSmeltXP());
            }
            if (!Recipes.isMMDItem(material, Names.CRUSHED_PURIFIED) || !material.hasItem(Names.INGOT)) continue;
            Recipes.addFurnaceRecipe(material.getItemStack(Names.CRUSHED_PURIFIED), material.getItemStack(Names.INGOT), material.getOreSmeltXP());
        }
    }

    protected static void addAdditionalOredicts(@Nonnull String materialName, String oreDictName) {
        Recipes.addAdditionalOredicts(Materials.getMaterialByName(materialName), oreDictName);
    }

    protected static void addAdditionalOredicts(@Nonnull MMDMaterial material, @Nonnull String oreDictNameIn) {
        if (material.isEmpty()) {
            return;
        }
        String oreDictName = StringUtils.capitalize((String)oreDictNameIn);
        if (material.hasOre() && material.hasBlock(Names.ORE)) {
            OreDictionary.registerOre((String)("ore" + oreDictName), (ItemStack)material.getBlockItemStack(Names.ORE));
        }
        if (material.hasBlock(Names.BLOCK)) {
            OreDictionary.registerOre((String)("block" + oreDictName), (ItemStack)material.getBlockItemStack(Names.BLOCK));
        }
        TreeMap<Names, String> stuff = new TreeMap<Names, String>();
        stuff.put(Names.PLATE, "plate");
        stuff.put(Names.DOOR, "door");
        stuff.put(Names.NUGGET, "nugget");
        stuff.put(Names.TRAPDOOR, "trapdoor");
        stuff.put(Names.NUGGET, "nugget");
        stuff.put(Names.POWDER, "dust");
        stuff.put(Names.GEAR, "gear");
        stuff.put(Names.ROD, "rod");
        stuff.entrySet().stream().filter(ent -> material.hasItem((Names)((Object)((Object)ent.getKey())))).forEach(ent -> OreDictionary.registerOre((String)((String)ent.getValue() + oreDictName), (ItemStack)material.getItemStack((Names)((Object)((Object)ent.getKey())))));
        if (material.hasBlock(Names.BARS)) {
            OreDictionary.registerOre((String)("bars" + oreDictName), (ItemStack)material.getBlockItemStack(Names.BARS));
        }
        if (material.hasBlend()) {
            if (material.hasItem(Names.BLEND)) {
                OreDictionary.registerOre((String)("dust" + oreDictName), (ItemStack)material.getItemStack(Names.BLEND));
            }
            if (material.hasItem(Names.SMALLBLEND)) {
                OreDictionary.registerOre((String)("dustTiny" + oreDictName), (ItemStack)material.getItemStack(Names.SMALLBLEND));
                OreDictionary.registerOre((String)("dustSmall" + oreDictName), (ItemStack)material.getItemStack(Names.SMALLBLEND));
            }
        }
        if (material.hasItem(Names.INGOT)) {
            if (material.getType() != MMDMaterialType.MaterialType.GEM) {
                OreDictionary.registerOre((String)("ingot" + oreDictName), (ItemStack)material.getItemStack(Names.INGOT));
            } else if (material.getType() == MMDMaterialType.MaterialType.GEM) {
                OreDictionary.registerOre((String)("gem" + oreDictName), (ItemStack)material.getItemStack(Names.INGOT));
            }
        }
        if (material.hasItem(Names.SMALLPOWDER)) {
            OreDictionary.registerOre((String)("dustTiny" + oreDictName), (ItemStack)material.getItemStack(Names.SMALLPOWDER));
            OreDictionary.registerOre((String)("dustSmall" + oreDictName), (ItemStack)material.getItemStack(Names.SMALLPOWDER));
        }
    }

    public static void register(RegistryEvent.Register<IRecipe> event) {
        String mod = Loader.instance().activeModContainer().getModId();
        if (!Materials.hasMaterialFromMod(mod)) {
            return;
        }
        Recipes.initPureVanillaOredicts();
        Recipes.initPureVanillaCrusherRecipes();
        Recipes.initVanillaRecipes();
        Recipes.initGeneralRecipes();
        Recipes.initModSpecificRecipes();
    }

    protected static boolean isMMDBlock(MMDMaterial material, Names name) {
        return material.hasBlock(name) && material.getBlock(name) instanceof IMMDObject;
    }

    protected static boolean isMMDItem(MMDMaterial material, Names name) {
        return material.hasItem(name) && material.getItem(name) instanceof IMMDObject;
    }
}

