/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.feature;

import com.mcmoddev.lib.capability.ICapabilitiesContainer;
import com.mcmoddev.lib.container.IWidgetContainer;
import com.mcmoddev.lib.container.gui.BaseWidgetGui;
import com.mcmoddev.lib.container.gui.FluidWidgetGui;
import com.mcmoddev.lib.container.gui.GuiContext;
import com.mcmoddev.lib.container.gui.GuiPieceLayer;
import com.mcmoddev.lib.container.gui.GuiSprites;
import com.mcmoddev.lib.container.gui.IWidgetGui;
import com.mcmoddev.lib.container.gui.MMDGuiContainer;
import com.mcmoddev.lib.container.gui.SpriteBackgroundGui;
import com.mcmoddev.lib.container.gui.SpriteForegroundGui;
import com.mcmoddev.lib.container.gui.layout.CanvasLayout;
import com.mcmoddev.lib.container.widget.ActionWidget;
import com.mcmoddev.lib.container.widget.IWidget;
import com.mcmoddev.lib.feature.BaseFeature;
import com.mcmoddev.lib.feature.IClientFeature;
import com.mcmoddev.lib.inventory.FilteredFluidTank;
import com.mcmoddev.lib.inventory.FluidTankHandler;
import com.mcmoddev.lib.inventory.IFluidTankModifiable;
import com.mcmoddev.lib.inventory.IResponsiveFluidTank;
import com.mcmoddev.lib.inventory.ResponsiveFluidTankWrapper;
import com.mcmoddev.lib.inventory.SimpleFluidTank;
import com.mcmoddev.lib.util.FluidUtils;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class FluidTankFeature
extends BaseFeature
implements IClientFeature,
IWidgetContainer {
    private final IFluidTankModifiable internalTank;
    private final IFluidTank externalTank;

    public FluidTankFeature(String key, int capacity, @Nullable Predicate<FluidStack> fillFilter, @Nullable Predicate<FluidStack> drainFilter) {
        this(key, new SimpleFluidTank(capacity), fillFilter, drainFilter);
    }

    public FluidTankFeature(String key, Fluid fluid, int capacity, @Nullable Predicate<FluidStack> drainFilter) {
        this(key, new SimpleFluidTank(capacity), (FluidStack stack) -> stack.getFluid() == fluid, drainFilter);
    }

    public FluidTankFeature(String key, IFluidTankModifiable tank, @Nullable Predicate<FluidStack> fillFilter, @Nullable Predicate<FluidStack> drainFilter) {
        super(key);
        if (tank instanceof IResponsiveFluidTank) {
            ((IResponsiveFluidTank)((Object)tank)).addResponsiveTarget(t -> this.onTankContentsChanged());
            this.internalTank = tank;
        } else {
            this.internalTank = new ResponsiveFluidTankWrapper(tank, t -> this.onTankContentsChanged());
        }
        this.externalTank = new FilteredFluidTank(this.internalTank, fillFilter, drainFilter);
    }

    public IFluidTankModifiable getInternalTank() {
        return this.internalTank;
    }

    public IFluidTank getExternalTank() {
        return this.externalTank;
    }

    private void onTankContentsChanged() {
        this.setDirty();
    }

    @Override
    public void initCapabilities(ICapabilitiesContainer container) {
        container.addCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f -> new FluidTankHandler(this.externalTank));
    }

    @Override
    protected void writeToNBT(NBTTagCompound tag) {
        FluidStack fluid = this.internalTank.getFluid();
        if (fluid != null) {
            NBTTagCompound fluidTag = new NBTTagCompound();
            fluid.writeToNBT(fluidTag);
            tag.func_74782_a("fluid", (NBTBase)fluidTag);
        }
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b("fluid", 10)) {
            NBTTagCompound fluidTag = nbt.func_74775_l("fluid");
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
            this.internalTank.setFluid(fluid);
        } else {
            this.internalTank.setFluid(null);
        }
    }

    @Override
    public List<IWidget> getWidgets(GuiContext context) {
        return Collections.singletonList(new FluidTankWidget());
    }

    @Override
    public IWidgetGui getRootWidgetGui(GuiContext context) {
        CanvasLayout layout = new CanvasLayout();
        layout.addPiece(new SpriteBackgroundGui(GuiSprites.TANK_CONTAINER), 0, 0);
        layout.addPiece(new FluidWidgetGui(() -> {
            FluidStack stack = this.internalTank.getFluid();
            return stack == null ? null : stack.getFluid();
        }, GuiSprites.TANK_CONTAINER.getWidth() - 6, GuiSprites.TANK_CONTAINER.getHeight() - 6, GuiPieceLayer.MIDDLE, () -> {
            FluidStack stack = this.internalTank.getFluid();
            return Float.valueOf(stack == null || stack.amount == 0 ? 0.0f : (float)stack.amount / (float)this.internalTank.getCapacity());
        }), 3, 3);
        layout.addPiece(new SpriteForegroundGui(GuiSprites.TANK_OVERLAY, GuiSprites.TANK_CONTAINER.getWidth(), GuiSprites.TANK_CONTAINER.getHeight()), 0, 0);
        layout.addPiece(new FluidTankWidgetGui(GuiSprites.TANK_CONTAINER.getWidth(), GuiSprites.TANK_CONTAINER.getHeight()), 0, 0);
        return layout;
    }

    @Nullable
    public FluidStack getFluid() {
        return this.internalTank.getFluid();
    }

    public boolean supportsClickToFill() {
        return true;
    }

    public boolean supportsClickToDrain() {
        return true;
    }

    private class FluidTankWidgetGui
    extends BaseWidgetGui {
        FluidTankWidgetGui(int width, int height) {
            super(width, height);
        }

        @Override
        public GuiPieceLayer[] getLayers() {
            return new GuiPieceLayer[0];
        }

        @Override
        public void getTooltip(List<String> lines) {
            FluidStack fluid = FluidTankFeature.this.getFluid();
            if (fluid == null || fluid.amount == 0) {
                lines.add(TextFormatting.DARK_GRAY + "EMPTY TANK");
            } else {
                lines.add(TextFormatting.AQUA + String.format("%d mb of %s", fluid.amount, fluid.getLocalizedName()));
            }
            boolean canFill = FluidTankFeature.this.supportsClickToFill();
            boolean canDrain = FluidTankFeature.this.supportsClickToDrain();
            if (canFill | canDrain) {
                ItemStack holdingStack = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
                canFill = canFill && FluidUtils.canFillFrom(FluidTankFeature.this.getExternalTank(), holdingStack);
                canDrain = canDrain && FluidUtils.canDrainInto(FluidTankFeature.this.getExternalTank(), holdingStack);
                String hoveringText = holdingStack.func_82833_r();
                if (canFill && canDrain) {
                    lines.add("Right click to fill tank from " + hoveringText + ".");
                    lines.add("Left click to drain tank into " + hoveringText + ".");
                } else if (canFill) {
                    lines.add("Click to fill tank from " + hoveringText + ".");
                } else if (canDrain) {
                    lines.add("Click to drain tank into " + hoveringText + ".");
                }
            }
        }

        @Override
        public boolean mouseReleased(MMDGuiContainer container, int mouseX, int mouseY, int state) {
            boolean canDrain;
            boolean canFill = FluidTankFeature.this.supportsClickToFill();
            if (canFill | (canDrain = FluidTankFeature.this.supportsClickToDrain())) {
                ItemStack holdingStack = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
                canFill = canFill && FluidUtils.canFillFrom(FluidTankFeature.this.getExternalTank(), holdingStack);
                canDrain = canDrain && FluidUtils.canDrainInto(FluidTankFeature.this.getExternalTank(), holdingStack);
                String action = null;
                if (canFill && canDrain) {
                    action = state == 1 ? "fill" : "drain";
                } else if (canFill) {
                    action = "fill";
                } else if (canDrain) {
                    action = "drain";
                }
                if (action != null) {
                    NBTTagCompound actionTag = new NBTTagCompound();
                    actionTag.func_74778_a("action", action);
                    ((FluidTankWidget)container.findWidgetByKey(FluidTankFeature.this.getKey() + "_handler")).actionPerformed(actionTag);
                }
            }
            return false;
        }
    }

    private class FluidTankWidget
    extends ActionWidget {
        protected FluidTankWidget() {
            super(FluidTankFeature.this.getKey() + "_handler");
            this.setServerSideConsumer(this::serverCallback);
        }

        private void serverCallback(NBTTagCompound data) {
            if (data.func_150297_b("action", 8)) {
                String action = data.func_74779_i("action");
                EntityPlayer player = this.getPlayer();
                boolean stackChanged = false;
                if (player != null && action.equals("fill")) {
                    ItemStack holdingStack = player.field_71071_by.func_70445_o();
                    IFluidTank tank = FluidTankFeature.this.getExternalTank();
                    if (FluidUtils.canFillFrom(tank, holdingStack)) {
                        player.field_71071_by.func_70437_b(FluidUtils.fillFrom(tank, holdingStack));
                        stackChanged = true;
                    }
                } else if (player != null && action.equals("drain")) {
                    ItemStack holdingStack = player.field_71071_by.func_70445_o();
                    IFluidTank tank = FluidTankFeature.this.getExternalTank();
                    if (FluidUtils.canDrainInto(tank, holdingStack)) {
                        player.field_71071_by.func_70437_b(FluidUtils.drainInto(tank, holdingStack));
                        stackChanged = true;
                    }
                }
                if (stackChanged && player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketSetSlot(-1, 0, player.field_71071_by.func_70445_o()));
                }
            }
        }
    }
}

